<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCRoutingPlanCategoryInfo StructType
 * @subpackage Structs
 */
class WCRoutingPlanCategoryInfo extends AbstractStructBase
{
    /**
     * The i_routing_plan_cat
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the plan category
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_routing_plan_cat;
    /**
     * The i_route_category
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the route category, either this or name is mandatory.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $i_route_category;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the route category, either this or i_route_category is mandatory.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The i_route_category_order
     * Meta informations extracted from the WSDL
     * - documentation: Order of the category in the plan (1..99)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_route_category_order;
    /**
     * Constructor method for WCRoutingPlanCategoryInfo
     * @uses WCRoutingPlanCategoryInfo::setI_routing_plan_cat()
     * @uses WCRoutingPlanCategoryInfo::setI_route_category()
     * @uses WCRoutingPlanCategoryInfo::setName()
     * @uses WCRoutingPlanCategoryInfo::setI_route_category_order()
     * @param int $i_routing_plan_cat
     * @param int $i_route_category
     * @param string $name
     * @param int $i_route_category_order
     */
    public function __construct($i_routing_plan_cat = null, $i_route_category = null, $name = null, $i_route_category_order = null)
    {
        $this
            ->setI_routing_plan_cat($i_routing_plan_cat)
            ->setI_route_category($i_route_category)
            ->setName($name)
            ->setI_route_category_order($i_route_category_order);
    }
    /**
     * Get i_routing_plan_cat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_routing_plan_cat()
    {
        return isset($this->i_routing_plan_cat) ? $this->i_routing_plan_cat : null;
    }
    /**
     * Set i_routing_plan_cat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_routing_plan_cat
     * @return \StructType\WCRoutingPlanCategoryInfo
     */
    public function setI_routing_plan_cat($i_routing_plan_cat = null)
    {
        // validation for constraint: int
        if (!is_null($i_routing_plan_cat) && !is_numeric($i_routing_plan_cat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_routing_plan_cat)), __LINE__);
        }
        if (is_null($i_routing_plan_cat) || (is_array($i_routing_plan_cat) && empty($i_routing_plan_cat))) {
            unset($this->i_routing_plan_cat);
        } else {
            $this->i_routing_plan_cat = $i_routing_plan_cat;
        }
        return $this;
    }
    /**
     * Get i_route_category value
     * @return int|null
     */
    public function getI_route_category()
    {
        return $this->i_route_category;
    }
    /**
     * Set i_route_category value
     * @param int $i_route_category
     * @return \StructType\WCRoutingPlanCategoryInfo
     */
    public function setI_route_category($i_route_category = null)
    {
        // validation for constraint: int
        if (!is_null($i_route_category) && !is_numeric($i_route_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_route_category)), __LINE__);
        }
        $this->i_route_category = $i_route_category;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\WCRoutingPlanCategoryInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_route_category_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_route_category_order()
    {
        return isset($this->i_route_category_order) ? $this->i_route_category_order : null;
    }
    /**
     * Set i_route_category_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_route_category_order
     * @return \StructType\WCRoutingPlanCategoryInfo
     */
    public function setI_route_category_order($i_route_category_order = null)
    {
        // validation for constraint: int
        if (!is_null($i_route_category_order) && !is_numeric($i_route_category_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_route_category_order)), __LINE__);
        }
        if (is_null($i_route_category_order) || (is_array($i_route_category_order) && empty($i_route_category_order))) {
            unset($this->i_route_category_order);
        } else {
            $this->i_route_category_order = $i_route_category_order;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCRoutingPlanCategoryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
