<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetSubscriptionsResponse StructType
 * @subpackage Structs
 */
class WCGetSubscriptionsResponse extends AbstractStructBase
{
    /**
     * The subscriptions
     * Meta informations extracted from the WSDL
     * - documentation: Array of subscriptions for given type of object
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:WCSubscriptionInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\WCSubscriptionInfo[]
     */
    public $subscriptions;
    /**
     * Constructor method for WCGetSubscriptionsResponse
     * @uses WCGetSubscriptionsResponse::setSubscriptions()
     * @param \StructType\WCSubscriptionInfo[] $subscriptions
     */
    public function __construct(array $subscriptions = array())
    {
        $this
            ->setSubscriptions($subscriptions);
    }
    /**
     * Get subscriptions value
     * @return \StructType\WCSubscriptionInfo[]
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }
    /**
     * Set subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\WCSubscriptionInfo[] $subscriptions
     * @return \StructType\WCGetSubscriptionsResponse
     */
    public function setSubscriptions(array $subscriptions = array())
    {
        foreach ($subscriptions as $wCGetSubscriptionsResponseSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$wCGetSubscriptionsResponseSubscriptionsItem instanceof \StructType\WCSubscriptionInfo) {
                throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\WCSubscriptionInfo, "%s" given', is_object($wCGetSubscriptionsResponseSubscriptionsItem) ? get_class($wCGetSubscriptionsResponseSubscriptionsItem) : gettype($wCGetSubscriptionsResponseSubscriptionsItem)), __LINE__);
            }
        }
        $this->subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Add item to subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\WCSubscriptionInfo $item
     * @return \StructType\WCGetSubscriptionsResponse
     */
    public function addToSubscriptions(\StructType\WCSubscriptionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WCSubscriptionInfo) {
            throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\WCSubscriptionInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subscriptions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetSubscriptionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
