<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetSubscriptionPlanInfoRequest StructType
 * @subpackage Structs
 */
class WCGetSubscriptionPlanInfoRequest extends AbstractStructBase
{
    /**
     * The i_subscription
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of Subscription Plan
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $i_subscription;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name to look up subscription plan by
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * Constructor method for WCGetSubscriptionPlanInfoRequest
     * @uses WCGetSubscriptionPlanInfoRequest::setI_subscription()
     * @uses WCGetSubscriptionPlanInfoRequest::setName()
     * @param int $i_subscription
     * @param string $name
     */
    public function __construct($i_subscription = null, $name = null)
    {
        $this
            ->setI_subscription($i_subscription)
            ->setName($name);
    }
    /**
     * Get i_subscription value
     * @return int|null
     */
    public function getI_subscription()
    {
        return $this->i_subscription;
    }
    /**
     * Set i_subscription value
     * @param int $i_subscription
     * @return \StructType\WCGetSubscriptionPlanInfoRequest
     */
    public function setI_subscription($i_subscription = null)
    {
        // validation for constraint: int
        if (!is_null($i_subscription) && !is_numeric($i_subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_subscription)), __LINE__);
        }
        $this->i_subscription = $i_subscription;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\WCGetSubscriptionPlanInfoRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetSubscriptionPlanInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
