<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorAccountInfo StructType
 * @subpackage Structs
 */
class VendorAccountInfo extends AbstractStructBase
{
    /**
     * The i_vendor_acc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_vendor_acc;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The i_vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_vendor;
    /**
     * The del
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $del;
    /**
     * Constructor method for VendorAccountInfo
     * @uses VendorAccountInfo::setI_vendor_acc()
     * @uses VendorAccountInfo::setName()
     * @uses VendorAccountInfo::setLogin()
     * @uses VendorAccountInfo::setPassword()
     * @uses VendorAccountInfo::setI_vendor()
     * @uses VendorAccountInfo::setDel()
     * @param int $i_vendor_acc
     * @param string $name
     * @param string $login
     * @param string $password
     * @param int $i_vendor
     * @param int $del
     */
    public function __construct($i_vendor_acc = null, $name = null, $login = null, $password = null, $i_vendor = null, $del = null)
    {
        $this
            ->setI_vendor_acc($i_vendor_acc)
            ->setName($name)
            ->setLogin($login)
            ->setPassword($password)
            ->setI_vendor($i_vendor)
            ->setDel($del);
    }
    /**
     * Get i_vendor_acc value
     * @return int|null
     */
    public function getI_vendor_acc()
    {
        return $this->i_vendor_acc;
    }
    /**
     * Set i_vendor_acc value
     * @param int $i_vendor_acc
     * @return \StructType\VendorAccountInfo
     */
    public function setI_vendor_acc($i_vendor_acc = null)
    {
        // validation for constraint: int
        if (!is_null($i_vendor_acc) && !is_numeric($i_vendor_acc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vendor_acc)), __LINE__);
        }
        $this->i_vendor_acc = $i_vendor_acc;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\VendorAccountInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\VendorAccountInfo
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\VendorAccountInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get i_vendor value
     * @return int|null
     */
    public function getI_vendor()
    {
        return $this->i_vendor;
    }
    /**
     * Set i_vendor value
     * @param int $i_vendor
     * @return \StructType\VendorAccountInfo
     */
    public function setI_vendor($i_vendor = null)
    {
        // validation for constraint: int
        if (!is_null($i_vendor) && !is_numeric($i_vendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vendor)), __LINE__);
        }
        $this->i_vendor = $i_vendor;
        return $this;
    }
    /**
     * Get del value
     * @return int|null
     */
    public function getDel()
    {
        return $this->del;
    }
    /**
     * Set del value
     * @param int $del
     * @return \StructType\VendorAccountInfo
     */
    public function setDel($del = null)
    {
        // validation for constraint: int
        if (!is_null($del) && !is_numeric($del)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($del)), __LINE__);
        }
        $this->del = $del;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorAccountInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
