<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerServiceFeaturesRequest StructType
 * @subpackage Structs
 */
class UpdateCustomerServiceFeaturesRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $i_customer;
    /**
     * The service_features
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: pst:ServiceFeatureInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureInfo[]
     */
    public $service_features;
    /**
     * Constructor method for UpdateCustomerServiceFeaturesRequest
     * @uses UpdateCustomerServiceFeaturesRequest::setI_customer()
     * @uses UpdateCustomerServiceFeaturesRequest::setService_features()
     * @param int $i_customer
     * @param \StructType\ServiceFeatureInfo[] $service_features
     */
    public function __construct($i_customer = null, array $service_features = array())
    {
        $this
            ->setI_customer($i_customer)
            ->setService_features($service_features);
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\UpdateCustomerServiceFeaturesRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get service_features value
     * @return \StructType\ServiceFeatureInfo[]|null
     */
    public function getService_features()
    {
        return $this->service_features;
    }
    /**
     * Set service_features value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo[] $service_features
     * @return \StructType\UpdateCustomerServiceFeaturesRequest
     */
    public function setService_features(array $service_features = array())
    {
        foreach ($service_features as $updateCustomerServiceFeaturesRequestService_featuresItem) {
            // validation for constraint: itemType
            if (!$updateCustomerServiceFeaturesRequestService_featuresItem instanceof \StructType\ServiceFeatureInfo) {
                throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($updateCustomerServiceFeaturesRequestService_featuresItem) ? get_class($updateCustomerServiceFeaturesRequestService_featuresItem) : gettype($updateCustomerServiceFeaturesRequestService_featuresItem)), __LINE__);
            }
        }
        $this->service_features = $service_features;
        return $this;
    }
    /**
     * Add item to service_features value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo $item
     * @return \StructType\UpdateCustomerServiceFeaturesRequest
     */
    public function addToService_features(\StructType\ServiceFeatureInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureInfo) {
            throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service_features[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerServiceFeaturesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
