<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerExtensionRequest StructType
 * @subpackage Structs
 */
class UpdateCustomerExtensionRequest extends AbstractStructBase
{
    /**
     * The i_c_ext
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_c_ext;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_account;
    /**
     * The prompt_action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prompt_action;
    /**
     * The published
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $published;
    /**
     * The primary_i_c_group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $primary_i_c_group;
    /**
     * Constructor method for UpdateCustomerExtensionRequest
     * @uses UpdateCustomerExtensionRequest::setI_c_ext()
     * @uses UpdateCustomerExtensionRequest::setI_customer()
     * @uses UpdateCustomerExtensionRequest::setId()
     * @uses UpdateCustomerExtensionRequest::setName()
     * @uses UpdateCustomerExtensionRequest::setI_account()
     * @uses UpdateCustomerExtensionRequest::setPrompt_action()
     * @uses UpdateCustomerExtensionRequest::setPublished()
     * @uses UpdateCustomerExtensionRequest::setPrimary_i_c_group()
     * @param int $i_c_ext
     * @param int $i_customer
     * @param string $id
     * @param string $name
     * @param int $i_account
     * @param string $prompt_action
     * @param string $published
     * @param int $primary_i_c_group
     */
    public function __construct($i_c_ext = null, $i_customer = null, $id = null, $name = null, $i_account = null, $prompt_action = null, $published = null, $primary_i_c_group = null)
    {
        $this
            ->setI_c_ext($i_c_ext)
            ->setI_customer($i_customer)
            ->setId($id)
            ->setName($name)
            ->setI_account($i_account)
            ->setPrompt_action($prompt_action)
            ->setPublished($published)
            ->setPrimary_i_c_group($primary_i_c_group);
    }
    /**
     * Get i_c_ext value
     * @return int
     */
    public function getI_c_ext()
    {
        return $this->i_c_ext;
    }
    /**
     * Set i_c_ext value
     * @param int $i_c_ext
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setI_c_ext($i_c_ext = null)
    {
        // validation for constraint: int
        if (!is_null($i_c_ext) && !is_numeric($i_c_ext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_c_ext)), __LINE__);
        }
        $this->i_c_ext = $i_c_ext;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get i_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_account()
    {
        return isset($this->i_account) ? $this->i_account : null;
    }
    /**
     * Set i_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_account
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        if (is_null($i_account) || (is_array($i_account) && empty($i_account))) {
            unset($this->i_account);
        } else {
            $this->i_account = $i_account;
        }
        return $this;
    }
    /**
     * Get prompt_action value
     * @return string|null
     */
    public function getPrompt_action()
    {
        return $this->prompt_action;
    }
    /**
     * Set prompt_action value
     * @param string $prompt_action
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setPrompt_action($prompt_action = null)
    {
        // validation for constraint: string
        if (!is_null($prompt_action) && !is_string($prompt_action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prompt_action)), __LINE__);
        }
        $this->prompt_action = $prompt_action;
        return $this;
    }
    /**
     * Get published value
     * @return string|null
     */
    public function getPublished()
    {
        return $this->published;
    }
    /**
     * Set published value
     * @param string $published
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setPublished($published = null)
    {
        // validation for constraint: string
        if (!is_null($published) && !is_string($published)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($published)), __LINE__);
        }
        $this->published = $published;
        return $this;
    }
    /**
     * Get primary_i_c_group value
     * @return int|null
     */
    public function getPrimary_i_c_group()
    {
        return $this->primary_i_c_group;
    }
    /**
     * Set primary_i_c_group value
     * @param int $primary_i_c_group
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public function setPrimary_i_c_group($primary_i_c_group = null)
    {
        // validation for constraint: int
        if (!is_null($primary_i_c_group) && !is_numeric($primary_i_c_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($primary_i_c_group)), __LINE__);
        }
        $this->primary_i_c_group = $primary_i_c_group;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerExtensionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
