<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerCustomFieldsValuesResponse StructType
 * @subpackage Structs
 */
class UpdateCustomerCustomFieldsValuesResponse extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_customer;
    /**
     * The custom_fields_values
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:CustomFieldsValuesInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomFieldsValuesInfo[]
     */
    public $custom_fields_values;
    /**
     * Constructor method for UpdateCustomerCustomFieldsValuesResponse
     * @uses UpdateCustomerCustomFieldsValuesResponse::setI_customer()
     * @uses UpdateCustomerCustomFieldsValuesResponse::setCustom_fields_values()
     * @param int $i_customer
     * @param \StructType\CustomFieldsValuesInfo[] $custom_fields_values
     */
    public function __construct($i_customer = null, array $custom_fields_values = array())
    {
        $this
            ->setI_customer($i_customer)
            ->setCustom_fields_values($custom_fields_values);
    }
    /**
     * Get i_customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_customer()
    {
        return isset($this->i_customer) ? $this->i_customer : null;
    }
    /**
     * Set i_customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_customer
     * @return \StructType\UpdateCustomerCustomFieldsValuesResponse
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        if (is_null($i_customer) || (is_array($i_customer) && empty($i_customer))) {
            unset($this->i_customer);
        } else {
            $this->i_customer = $i_customer;
        }
        return $this;
    }
    /**
     * Get custom_fields_values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomFieldsValuesInfo[]|null
     */
    public function getCustom_fields_values()
    {
        return isset($this->custom_fields_values) ? $this->custom_fields_values : null;
    }
    /**
     * Set custom_fields_values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsValuesInfo[] $custom_fields_values
     * @return \StructType\UpdateCustomerCustomFieldsValuesResponse
     */
    public function setCustom_fields_values(array $custom_fields_values = array())
    {
        foreach ($custom_fields_values as $updateCustomerCustomFieldsValuesResponseCustom_fields_valuesItem) {
            // validation for constraint: itemType
            if (!$updateCustomerCustomFieldsValuesResponseCustom_fields_valuesItem instanceof \StructType\CustomFieldsValuesInfo) {
                throw new \InvalidArgumentException(sprintf('The custom_fields_values property can only contain items of \StructType\CustomFieldsValuesInfo, "%s" given', is_object($updateCustomerCustomFieldsValuesResponseCustom_fields_valuesItem) ? get_class($updateCustomerCustomFieldsValuesResponseCustom_fields_valuesItem) : gettype($updateCustomerCustomFieldsValuesResponseCustom_fields_valuesItem)), __LINE__);
            }
        }
        if (is_null($custom_fields_values) || (is_array($custom_fields_values) && empty($custom_fields_values))) {
            unset($this->custom_fields_values);
        } else {
            $this->custom_fields_values = $custom_fields_values;
        }
        return $this;
    }
    /**
     * Add item to custom_fields_values value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsValuesInfo $item
     * @return \StructType\UpdateCustomerCustomFieldsValuesResponse
     */
    public function addToCustom_fields_values(\StructType\CustomFieldsValuesInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldsValuesInfo) {
            throw new \InvalidArgumentException(sprintf('The custom_fields_values property can only contain items of \StructType\CustomFieldsValuesInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->custom_fields_values[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerCustomFieldsValuesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
