<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxationInfo StructType
 * @subpackage Structs
 */
class TaxationInfo extends AbstractStructBase
{
    /**
     * The processor
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $processor;
    /**
     * The options_vat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxationOptionsVat
     */
    public $options_vat;
    /**
     * The options_billsoft
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxationOptionsBillsoft
     */
    public $options_billsoft;
    /**
     * Constructor method for TaxationInfo
     * @uses TaxationInfo::setProcessor()
     * @uses TaxationInfo::setOptions_vat()
     * @uses TaxationInfo::setOptions_billsoft()
     * @param string $processor
     * @param \StructType\TaxationOptionsVat $options_vat
     * @param \StructType\TaxationOptionsBillsoft $options_billsoft
     */
    public function __construct($processor = null, \StructType\TaxationOptionsVat $options_vat = null, \StructType\TaxationOptionsBillsoft $options_billsoft = null)
    {
        $this
            ->setProcessor($processor)
            ->setOptions_vat($options_vat)
            ->setOptions_billsoft($options_billsoft);
    }
    /**
     * Get processor value
     * @return string
     */
    public function getProcessor()
    {
        return $this->processor;
    }
    /**
     * Set processor value
     * @param string $processor
     * @return \StructType\TaxationInfo
     */
    public function setProcessor($processor = null)
    {
        // validation for constraint: string
        if (!is_null($processor) && !is_string($processor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processor)), __LINE__);
        }
        $this->processor = $processor;
        return $this;
    }
    /**
     * Get options_vat value
     * @return \StructType\TaxationOptionsVat|null
     */
    public function getOptions_vat()
    {
        return $this->options_vat;
    }
    /**
     * Set options_vat value
     * @param \StructType\TaxationOptionsVat $options_vat
     * @return \StructType\TaxationInfo
     */
    public function setOptions_vat(\StructType\TaxationOptionsVat $options_vat = null)
    {
        $this->options_vat = $options_vat;
        return $this;
    }
    /**
     * Get options_billsoft value
     * @return \StructType\TaxationOptionsBillsoft|null
     */
    public function getOptions_billsoft()
    {
        return $this->options_billsoft;
    }
    /**
     * Set options_billsoft value
     * @param \StructType\TaxationOptionsBillsoft $options_billsoft
     * @return \StructType\TaxationInfo
     */
    public function setOptions_billsoft(\StructType\TaxationOptionsBillsoft $options_billsoft = null)
    {
        $this->options_billsoft = $options_billsoft;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TaxationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
