<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SipStatusInfo StructType
 * @subpackage Structs
 */
class SipStatusInfo extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The user_agent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $user_agent;
    /**
     * The contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contact;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The callid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callid;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $flags;
    /**
     * The expires
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expires;
    /**
     * The last_modified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_modified;
    /**
     * Constructor method for SipStatusInfo
     * @uses SipStatusInfo::setUsername()
     * @uses SipStatusInfo::setUser_agent()
     * @uses SipStatusInfo::setContact()
     * @uses SipStatusInfo::setDomain()
     * @uses SipStatusInfo::setCallid()
     * @uses SipStatusInfo::setFlags()
     * @uses SipStatusInfo::setExpires()
     * @uses SipStatusInfo::setLast_modified()
     * @param string $username
     * @param string $user_agent
     * @param string $contact
     * @param string $domain
     * @param string $callid
     * @param int $flags
     * @param string $expires
     * @param string $last_modified
     */
    public function __construct($username = null, $user_agent = null, $contact = null, $domain = null, $callid = null, $flags = null, $expires = null, $last_modified = null)
    {
        $this
            ->setUsername($username)
            ->setUser_agent($user_agent)
            ->setContact($contact)
            ->setDomain($domain)
            ->setCallid($callid)
            ->setFlags($flags)
            ->setExpires($expires)
            ->setLast_modified($last_modified);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\SipStatusInfo
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get user_agent value
     * @return string|null
     */
    public function getUser_agent()
    {
        return $this->user_agent;
    }
    /**
     * Set user_agent value
     * @param string $user_agent
     * @return \StructType\SipStatusInfo
     */
    public function setUser_agent($user_agent = null)
    {
        // validation for constraint: string
        if (!is_null($user_agent) && !is_string($user_agent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user_agent)), __LINE__);
        }
        $this->user_agent = $user_agent;
        return $this;
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \StructType\SipStatusInfo
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\SipStatusInfo
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get callid value
     * @return string|null
     */
    public function getCallid()
    {
        return $this->callid;
    }
    /**
     * Set callid value
     * @param string $callid
     * @return \StructType\SipStatusInfo
     */
    public function setCallid($callid = null)
    {
        // validation for constraint: string
        if (!is_null($callid) && !is_string($callid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callid)), __LINE__);
        }
        $this->callid = $callid;
        return $this;
    }
    /**
     * Get flags value
     * @return int|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param int $flags
     * @return \StructType\SipStatusInfo
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: int
        if (!is_null($flags) && !is_numeric($flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flags)), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get expires value
     * @return string|null
     */
    public function getExpires()
    {
        return $this->expires;
    }
    /**
     * Set expires value
     * @param string $expires
     * @return \StructType\SipStatusInfo
     */
    public function setExpires($expires = null)
    {
        // validation for constraint: string
        if (!is_null($expires) && !is_string($expires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expires)), __LINE__);
        }
        $this->expires = $expires;
        return $this;
    }
    /**
     * Get last_modified value
     * @return string|null
     */
    public function getLast_modified()
    {
        return $this->last_modified;
    }
    /**
     * Set last_modified value
     * @param string $last_modified
     * @return \StructType\SipStatusInfo
     */
    public function setLast_modified($last_modified = null)
    {
        // validation for constraint: string
        if (!is_null($last_modified) && !is_string($last_modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_modified)), __LINE__);
        }
        $this->last_modified = $last_modified;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SipStatusInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
