<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceAndRatingInfo StructType
 * @subpackage Structs
 */
class ServiceAndRatingInfo extends AbstractStructBase
{
    /**
     * The i_accessibility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_accessibility;
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_product;
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff;
    /**
     * The i_tariff_reseller
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff_reseller;
    /**
     * The tariff_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tariff_name;
    /**
     * The reseller_tariff_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reseller_tariff_name;
    /**
     * The i_node
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_node;
    /**
     * The cld
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cld;
    /**
     * The i_oli
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_oli;
    /**
     * The i_service_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service_type;
    /**
     * The max_auth_funds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $max_auth_funds;
    /**
     * The check_funds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $check_funds;
    /**
     * The min_session_funds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $min_session_funds;
    /**
     * The max_session_funds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $max_session_funds;
    /**
     * The alert_overuse_reject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alert_overuse_reject;
    /**
     * The i_rate_match_mode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_rate_match_mode;
    /**
     * The routing_list
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - arrayType: pst:ServiceAndRatingRoutingInfo[]
     * - ref: soapenc:arrayType
     * @var ServiceAndRatingRoutingInfo
     */
    public $routing_list;
    /**
     * Constructor method for ServiceAndRatingInfo
     * @uses ServiceAndRatingInfo::setI_accessibility()
     * @uses ServiceAndRatingInfo::setI_product()
     * @uses ServiceAndRatingInfo::setI_tariff()
     * @uses ServiceAndRatingInfo::setI_tariff_reseller()
     * @uses ServiceAndRatingInfo::setTariff_name()
     * @uses ServiceAndRatingInfo::setReseller_tariff_name()
     * @uses ServiceAndRatingInfo::setI_node()
     * @uses ServiceAndRatingInfo::setCld()
     * @uses ServiceAndRatingInfo::setI_oli()
     * @uses ServiceAndRatingInfo::setI_service_type()
     * @uses ServiceAndRatingInfo::setMax_auth_funds()
     * @uses ServiceAndRatingInfo::setCheck_funds()
     * @uses ServiceAndRatingInfo::setMin_session_funds()
     * @uses ServiceAndRatingInfo::setMax_session_funds()
     * @uses ServiceAndRatingInfo::setAlert_overuse_reject()
     * @uses ServiceAndRatingInfo::setI_rate_match_mode()
     * @uses ServiceAndRatingInfo::setRouting_list()
     * @param int $i_accessibility
     * @param int $i_product
     * @param int $i_tariff
     * @param int $i_tariff_reseller
     * @param string $tariff_name
     * @param string $reseller_tariff_name
     * @param int $i_node
     * @param string $cld
     * @param int $i_oli
     * @param int $i_service_type
     * @param float $max_auth_funds
     * @param string $check_funds
     * @param float $min_session_funds
     * @param float $max_session_funds
     * @param string $alert_overuse_reject
     * @param int $i_rate_match_mode
     * @param ServiceAndRatingRoutingInfo $routing_list
     */
    public function __construct($i_accessibility = null, $i_product = null, $i_tariff = null, $i_tariff_reseller = null, $tariff_name = null, $reseller_tariff_name = null, $i_node = null, $cld = null, $i_oli = null, $i_service_type = null, $max_auth_funds = null, $check_funds = null, $min_session_funds = null, $max_session_funds = null, $alert_overuse_reject = null, $i_rate_match_mode = null, ServiceAndRatingRoutingInfo $routing_list = null)
    {
        $this
            ->setI_accessibility($i_accessibility)
            ->setI_product($i_product)
            ->setI_tariff($i_tariff)
            ->setI_tariff_reseller($i_tariff_reseller)
            ->setTariff_name($tariff_name)
            ->setReseller_tariff_name($reseller_tariff_name)
            ->setI_node($i_node)
            ->setCld($cld)
            ->setI_oli($i_oli)
            ->setI_service_type($i_service_type)
            ->setMax_auth_funds($max_auth_funds)
            ->setCheck_funds($check_funds)
            ->setMin_session_funds($min_session_funds)
            ->setMax_session_funds($max_session_funds)
            ->setAlert_overuse_reject($alert_overuse_reject)
            ->setI_rate_match_mode($i_rate_match_mode)
            ->setRouting_list($routing_list);
    }
    /**
     * Get i_accessibility value
     * @return int|null
     */
    public function getI_accessibility()
    {
        return $this->i_accessibility;
    }
    /**
     * Set i_accessibility value
     * @param int $i_accessibility
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_accessibility($i_accessibility = null)
    {
        // validation for constraint: int
        if (!is_null($i_accessibility) && !is_numeric($i_accessibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_accessibility)), __LINE__);
        }
        $this->i_accessibility = $i_accessibility;
        return $this;
    }
    /**
     * Get i_product value
     * @return int|null
     */
    public function getI_product()
    {
        return $this->i_product;
    }
    /**
     * Set i_product value
     * @param int $i_product
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        $this->i_product = $i_product;
        return $this;
    }
    /**
     * Get i_tariff value
     * @return int|null
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get i_tariff_reseller value
     * @return int|null
     */
    public function getI_tariff_reseller()
    {
        return $this->i_tariff_reseller;
    }
    /**
     * Set i_tariff_reseller value
     * @param int $i_tariff_reseller
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_tariff_reseller($i_tariff_reseller = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff_reseller) && !is_numeric($i_tariff_reseller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff_reseller)), __LINE__);
        }
        $this->i_tariff_reseller = $i_tariff_reseller;
        return $this;
    }
    /**
     * Get tariff_name value
     * @return string|null
     */
    public function getTariff_name()
    {
        return $this->tariff_name;
    }
    /**
     * Set tariff_name value
     * @param string $tariff_name
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setTariff_name($tariff_name = null)
    {
        // validation for constraint: string
        if (!is_null($tariff_name) && !is_string($tariff_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariff_name)), __LINE__);
        }
        $this->tariff_name = $tariff_name;
        return $this;
    }
    /**
     * Get reseller_tariff_name value
     * @return string|null
     */
    public function getReseller_tariff_name()
    {
        return $this->reseller_tariff_name;
    }
    /**
     * Set reseller_tariff_name value
     * @param string $reseller_tariff_name
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setReseller_tariff_name($reseller_tariff_name = null)
    {
        // validation for constraint: string
        if (!is_null($reseller_tariff_name) && !is_string($reseller_tariff_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reseller_tariff_name)), __LINE__);
        }
        $this->reseller_tariff_name = $reseller_tariff_name;
        return $this;
    }
    /**
     * Get i_node value
     * @return int|null
     */
    public function getI_node()
    {
        return $this->i_node;
    }
    /**
     * Set i_node value
     * @param int $i_node
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_node($i_node = null)
    {
        // validation for constraint: int
        if (!is_null($i_node) && !is_numeric($i_node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_node)), __LINE__);
        }
        $this->i_node = $i_node;
        return $this;
    }
    /**
     * Get cld value
     * @return string|null
     */
    public function getCld()
    {
        return $this->cld;
    }
    /**
     * Set cld value
     * @param string $cld
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setCld($cld = null)
    {
        // validation for constraint: string
        if (!is_null($cld) && !is_string($cld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cld)), __LINE__);
        }
        $this->cld = $cld;
        return $this;
    }
    /**
     * Get i_oli value
     * @return int|null
     */
    public function getI_oli()
    {
        return $this->i_oli;
    }
    /**
     * Set i_oli value
     * @param int $i_oli
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_oli($i_oli = null)
    {
        // validation for constraint: int
        if (!is_null($i_oli) && !is_numeric($i_oli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_oli)), __LINE__);
        }
        $this->i_oli = $i_oli;
        return $this;
    }
    /**
     * Get i_service_type value
     * @return int|null
     */
    public function getI_service_type()
    {
        return $this->i_service_type;
    }
    /**
     * Set i_service_type value
     * @param int $i_service_type
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_service_type($i_service_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_service_type) && !is_numeric($i_service_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service_type)), __LINE__);
        }
        $this->i_service_type = $i_service_type;
        return $this;
    }
    /**
     * Get max_auth_funds value
     * @return float|null
     */
    public function getMax_auth_funds()
    {
        return $this->max_auth_funds;
    }
    /**
     * Set max_auth_funds value
     * @param float $max_auth_funds
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setMax_auth_funds($max_auth_funds = null)
    {
        $this->max_auth_funds = $max_auth_funds;
        return $this;
    }
    /**
     * Get check_funds value
     * @return string|null
     */
    public function getCheck_funds()
    {
        return $this->check_funds;
    }
    /**
     * Set check_funds value
     * @param string $check_funds
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setCheck_funds($check_funds = null)
    {
        // validation for constraint: string
        if (!is_null($check_funds) && !is_string($check_funds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($check_funds)), __LINE__);
        }
        $this->check_funds = $check_funds;
        return $this;
    }
    /**
     * Get min_session_funds value
     * @return float|null
     */
    public function getMin_session_funds()
    {
        return $this->min_session_funds;
    }
    /**
     * Set min_session_funds value
     * @param float $min_session_funds
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setMin_session_funds($min_session_funds = null)
    {
        $this->min_session_funds = $min_session_funds;
        return $this;
    }
    /**
     * Get max_session_funds value
     * @return float|null
     */
    public function getMax_session_funds()
    {
        return $this->max_session_funds;
    }
    /**
     * Set max_session_funds value
     * @param float $max_session_funds
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setMax_session_funds($max_session_funds = null)
    {
        $this->max_session_funds = $max_session_funds;
        return $this;
    }
    /**
     * Get alert_overuse_reject value
     * @return string|null
     */
    public function getAlert_overuse_reject()
    {
        return $this->alert_overuse_reject;
    }
    /**
     * Set alert_overuse_reject value
     * @param string $alert_overuse_reject
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setAlert_overuse_reject($alert_overuse_reject = null)
    {
        // validation for constraint: string
        if (!is_null($alert_overuse_reject) && !is_string($alert_overuse_reject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alert_overuse_reject)), __LINE__);
        }
        $this->alert_overuse_reject = $alert_overuse_reject;
        return $this;
    }
    /**
     * Get i_rate_match_mode value
     * @return int|null
     */
    public function getI_rate_match_mode()
    {
        return $this->i_rate_match_mode;
    }
    /**
     * Set i_rate_match_mode value
     * @param int $i_rate_match_mode
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setI_rate_match_mode($i_rate_match_mode = null)
    {
        // validation for constraint: int
        if (!is_null($i_rate_match_mode) && !is_numeric($i_rate_match_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_rate_match_mode)), __LINE__);
        }
        $this->i_rate_match_mode = $i_rate_match_mode;
        return $this;
    }
    /**
     * Get routing_list value
     * @return ServiceAndRatingRoutingInfo|null
     */
    public function getRouting_list()
    {
        return $this->routing_list;
    }
    /**
     * Set routing_list value
     * @param ServiceAndRatingRoutingInfo $routing_list
     * @return \StructType\ServiceAndRatingInfo
     */
    public function setRouting_list(ServiceAndRatingRoutingInfo $routing_list = null)
    {
        $this->routing_list = $routing_list;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceAndRatingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
