<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReserveDIDNumberResponse StructType
 * @subpackage Structs
 */
class ReserveDIDNumberResponse extends AbstractStructBase
{
    /**
     * The success
     * @var int
     */
    public $success;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * Constructor method for ReserveDIDNumberResponse
     * @uses ReserveDIDNumberResponse::setSuccess()
     * @uses ReserveDIDNumberResponse::setTimestamp()
     * @param int $success
     * @param string $timestamp
     */
    public function __construct($success = null, $timestamp = null)
    {
        $this
            ->setSuccess($success)
            ->setTimestamp($timestamp);
    }
    /**
     * Get success value
     * @return int|null
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param int $success
     * @return \StructType\ReserveDIDNumberResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: int
        if (!is_null($success) && !is_numeric($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($success)), __LINE__);
        }
        $this->success = $success;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\ReserveDIDNumberResponse
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReserveDIDNumberResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
