<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPConnectionInfo StructType
 * @subpackage Structs
 */
class RPConnectionInfo extends AbstractStructBase
{
    /**
     * The i_rp_connection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_rp_connection;
    /**
     * The i_routing_plan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_routing_plan;
    /**
     * The i_dest_group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_dest_group;
    /**
     * The i_connection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_connection;
    /**
     * The hunt_order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $hunt_order;
    /**
     * The hunt_order_exclusive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hunt_order_exclusive;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $weight;
    /**
     * Constructor method for RPConnectionInfo
     * @uses RPConnectionInfo::setI_rp_connection()
     * @uses RPConnectionInfo::setI_routing_plan()
     * @uses RPConnectionInfo::setI_dest_group()
     * @uses RPConnectionInfo::setI_connection()
     * @uses RPConnectionInfo::setHunt_order()
     * @uses RPConnectionInfo::setHunt_order_exclusive()
     * @uses RPConnectionInfo::setWeight()
     * @param int $i_rp_connection
     * @param int $i_routing_plan
     * @param int $i_dest_group
     * @param int $i_connection
     * @param int $hunt_order
     * @param string $hunt_order_exclusive
     * @param int $weight
     */
    public function __construct($i_rp_connection = null, $i_routing_plan = null, $i_dest_group = null, $i_connection = null, $hunt_order = null, $hunt_order_exclusive = null, $weight = null)
    {
        $this
            ->setI_rp_connection($i_rp_connection)
            ->setI_routing_plan($i_routing_plan)
            ->setI_dest_group($i_dest_group)
            ->setI_connection($i_connection)
            ->setHunt_order($hunt_order)
            ->setHunt_order_exclusive($hunt_order_exclusive)
            ->setWeight($weight);
    }
    /**
     * Get i_rp_connection value
     * @return int|null
     */
    public function getI_rp_connection()
    {
        return $this->i_rp_connection;
    }
    /**
     * Set i_rp_connection value
     * @param int $i_rp_connection
     * @return \StructType\RPConnectionInfo
     */
    public function setI_rp_connection($i_rp_connection = null)
    {
        // validation for constraint: int
        if (!is_null($i_rp_connection) && !is_numeric($i_rp_connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_rp_connection)), __LINE__);
        }
        $this->i_rp_connection = $i_rp_connection;
        return $this;
    }
    /**
     * Get i_routing_plan value
     * @return int|null
     */
    public function getI_routing_plan()
    {
        return $this->i_routing_plan;
    }
    /**
     * Set i_routing_plan value
     * @param int $i_routing_plan
     * @return \StructType\RPConnectionInfo
     */
    public function setI_routing_plan($i_routing_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_routing_plan) && !is_numeric($i_routing_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_routing_plan)), __LINE__);
        }
        $this->i_routing_plan = $i_routing_plan;
        return $this;
    }
    /**
     * Get i_dest_group value
     * @return int|null
     */
    public function getI_dest_group()
    {
        return $this->i_dest_group;
    }
    /**
     * Set i_dest_group value
     * @param int $i_dest_group
     * @return \StructType\RPConnectionInfo
     */
    public function setI_dest_group($i_dest_group = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest_group) && !is_numeric($i_dest_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest_group)), __LINE__);
        }
        $this->i_dest_group = $i_dest_group;
        return $this;
    }
    /**
     * Get i_connection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_connection()
    {
        return isset($this->i_connection) ? $this->i_connection : null;
    }
    /**
     * Set i_connection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_connection
     * @return \StructType\RPConnectionInfo
     */
    public function setI_connection($i_connection = null)
    {
        // validation for constraint: int
        if (!is_null($i_connection) && !is_numeric($i_connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_connection)), __LINE__);
        }
        if (is_null($i_connection) || (is_array($i_connection) && empty($i_connection))) {
            unset($this->i_connection);
        } else {
            $this->i_connection = $i_connection;
        }
        return $this;
    }
    /**
     * Get hunt_order value
     * @return int|null
     */
    public function getHunt_order()
    {
        return $this->hunt_order;
    }
    /**
     * Set hunt_order value
     * @param int $hunt_order
     * @return \StructType\RPConnectionInfo
     */
    public function setHunt_order($hunt_order = null)
    {
        // validation for constraint: int
        if (!is_null($hunt_order) && !is_numeric($hunt_order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hunt_order)), __LINE__);
        }
        $this->hunt_order = $hunt_order;
        return $this;
    }
    /**
     * Get hunt_order_exclusive value
     * @return string|null
     */
    public function getHunt_order_exclusive()
    {
        return $this->hunt_order_exclusive;
    }
    /**
     * Set hunt_order_exclusive value
     * @param string $hunt_order_exclusive
     * @return \StructType\RPConnectionInfo
     */
    public function setHunt_order_exclusive($hunt_order_exclusive = null)
    {
        // validation for constraint: string
        if (!is_null($hunt_order_exclusive) && !is_string($hunt_order_exclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hunt_order_exclusive)), __LINE__);
        }
        $this->hunt_order_exclusive = $hunt_order_exclusive;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \StructType\RPConnectionInfo
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RPConnectionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
