<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManageActiveCallRecordingRequest StructType
 * @subpackage Structs
 */
class ManageActiveCallRecordingRequest extends AbstractStructBase
{
    /**
     * The call_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $call_id;
    /**
     * The command
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $command;
    /**
     * Constructor method for ManageActiveCallRecordingRequest
     * @uses ManageActiveCallRecordingRequest::setCall_id()
     * @uses ManageActiveCallRecordingRequest::setCommand()
     * @param string $call_id
     * @param string $command
     */
    public function __construct($call_id = null, $command = null)
    {
        $this
            ->setCall_id($call_id)
            ->setCommand($command);
    }
    /**
     * Get call_id value
     * @return string
     */
    public function getCall_id()
    {
        return $this->call_id;
    }
    /**
     * Set call_id value
     * @param string $call_id
     * @return \StructType\ManageActiveCallRecordingRequest
     */
    public function setCall_id($call_id = null)
    {
        // validation for constraint: string
        if (!is_null($call_id) && !is_string($call_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($call_id)), __LINE__);
        }
        $this->call_id = $call_id;
        return $this;
    }
    /**
     * Get command value
     * @return string
     */
    public function getCommand()
    {
        return $this->command;
    }
    /**
     * Set command value
     * @param string $command
     * @return \StructType\ManageActiveCallRecordingRequest
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($command)), __LINE__);
        }
        $this->command = $command;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManageActiveCallRecordingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
