<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeVendorTransactionRequest StructType
 * @subpackage Structs
 */
class MakeVendorTransactionRequest extends AbstractStructBase
{
    /**
     * The i_vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_vendor;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $action;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $amount;
    /**
     * The visible_comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $visible_comment;
    /**
     * The internal_comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internal_comment;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service;
    /**
     * The date_inside_billing_period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $date_inside_billing_period;
    /**
     * Constructor method for MakeVendorTransactionRequest
     * @uses MakeVendorTransactionRequest::setI_vendor()
     * @uses MakeVendorTransactionRequest::setAction()
     * @uses MakeVendorTransactionRequest::setAmount()
     * @uses MakeVendorTransactionRequest::setVisible_comment()
     * @uses MakeVendorTransactionRequest::setInternal_comment()
     * @uses MakeVendorTransactionRequest::setI_service()
     * @uses MakeVendorTransactionRequest::setDate_inside_billing_period()
     * @param int $i_vendor
     * @param string $action
     * @param float $amount
     * @param string $visible_comment
     * @param string $internal_comment
     * @param int $i_service
     * @param string $date_inside_billing_period
     */
    public function __construct($i_vendor = null, $action = null, $amount = null, $visible_comment = null, $internal_comment = null, $i_service = null, $date_inside_billing_period = null)
    {
        $this
            ->setI_vendor($i_vendor)
            ->setAction($action)
            ->setAmount($amount)
            ->setVisible_comment($visible_comment)
            ->setInternal_comment($internal_comment)
            ->setI_service($i_service)
            ->setDate_inside_billing_period($date_inside_billing_period);
    }
    /**
     * Get i_vendor value
     * @return int
     */
    public function getI_vendor()
    {
        return $this->i_vendor;
    }
    /**
     * Set i_vendor value
     * @param int $i_vendor
     * @return \StructType\MakeVendorTransactionRequest
     */
    public function setI_vendor($i_vendor = null)
    {
        // validation for constraint: int
        if (!is_null($i_vendor) && !is_numeric($i_vendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vendor)), __LINE__);
        }
        $this->i_vendor = $i_vendor;
        return $this;
    }
    /**
     * Get action value
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param string $action
     * @return \StructType\MakeVendorTransactionRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\MakeVendorTransactionRequest
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get visible_comment value
     * @return string|null
     */
    public function getVisible_comment()
    {
        return $this->visible_comment;
    }
    /**
     * Set visible_comment value
     * @param string $visible_comment
     * @return \StructType\MakeVendorTransactionRequest
     */
    public function setVisible_comment($visible_comment = null)
    {
        // validation for constraint: string
        if (!is_null($visible_comment) && !is_string($visible_comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($visible_comment)), __LINE__);
        }
        $this->visible_comment = $visible_comment;
        return $this;
    }
    /**
     * Get internal_comment value
     * @return string|null
     */
    public function getInternal_comment()
    {
        return $this->internal_comment;
    }
    /**
     * Set internal_comment value
     * @param string $internal_comment
     * @return \StructType\MakeVendorTransactionRequest
     */
    public function setInternal_comment($internal_comment = null)
    {
        // validation for constraint: string
        if (!is_null($internal_comment) && !is_string($internal_comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internal_comment)), __LINE__);
        }
        $this->internal_comment = $internal_comment;
        return $this;
    }
    /**
     * Get i_service value
     * @return int|null
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\MakeVendorTransactionRequest
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get date_inside_billing_period value
     * @return string|null
     */
    public function getDate_inside_billing_period()
    {
        return $this->date_inside_billing_period;
    }
    /**
     * Set date_inside_billing_period value
     * @param string $date_inside_billing_period
     * @return \StructType\MakeVendorTransactionRequest
     */
    public function setDate_inside_billing_period($date_inside_billing_period = null)
    {
        // validation for constraint: string
        if (!is_null($date_inside_billing_period) && !is_string($date_inside_billing_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_inside_billing_period)), __LINE__);
        }
        $this->date_inside_billing_period = $date_inside_billing_period;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeVendorTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
