<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GlobalCurrencyInfo StructType
 * @subpackage Structs
 */
class GlobalCurrencyInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The iso_4217_num
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217_num;
    /**
     * The decimal_digits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $decimal_digits;
    /**
     * The name_major
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name_major;
    /**
     * The name_minor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name_minor;
    /**
     * The obsolete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $obsolete;
    /**
     * Constructor method for GlobalCurrencyInfo
     * @uses GlobalCurrencyInfo::setName()
     * @uses GlobalCurrencyInfo::setIso_4217()
     * @uses GlobalCurrencyInfo::setIso_4217_num()
     * @uses GlobalCurrencyInfo::setDecimal_digits()
     * @uses GlobalCurrencyInfo::setName_major()
     * @uses GlobalCurrencyInfo::setName_minor()
     * @uses GlobalCurrencyInfo::setObsolete()
     * @param string $name
     * @param string $iso_4217
     * @param string $iso_4217_num
     * @param int $decimal_digits
     * @param string $name_major
     * @param string $name_minor
     * @param string $obsolete
     */
    public function __construct($name = null, $iso_4217 = null, $iso_4217_num = null, $decimal_digits = null, $name_major = null, $name_minor = null, $obsolete = null)
    {
        $this
            ->setName($name)
            ->setIso_4217($iso_4217)
            ->setIso_4217_num($iso_4217_num)
            ->setDecimal_digits($decimal_digits)
            ->setName_major($name_major)
            ->setName_minor($name_minor)
            ->setObsolete($obsolete);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GlobalCurrencyInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\GlobalCurrencyInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get iso_4217_num value
     * @return string|null
     */
    public function getIso_4217_num()
    {
        return $this->iso_4217_num;
    }
    /**
     * Set iso_4217_num value
     * @param string $iso_4217_num
     * @return \StructType\GlobalCurrencyInfo
     */
    public function setIso_4217_num($iso_4217_num = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217_num) && !is_string($iso_4217_num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217_num)), __LINE__);
        }
        $this->iso_4217_num = $iso_4217_num;
        return $this;
    }
    /**
     * Get decimal_digits value
     * @return int|null
     */
    public function getDecimal_digits()
    {
        return $this->decimal_digits;
    }
    /**
     * Set decimal_digits value
     * @param int $decimal_digits
     * @return \StructType\GlobalCurrencyInfo
     */
    public function setDecimal_digits($decimal_digits = null)
    {
        // validation for constraint: int
        if (!is_null($decimal_digits) && !is_numeric($decimal_digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimal_digits)), __LINE__);
        }
        $this->decimal_digits = $decimal_digits;
        return $this;
    }
    /**
     * Get name_major value
     * @return string|null
     */
    public function getName_major()
    {
        return $this->name_major;
    }
    /**
     * Set name_major value
     * @param string $name_major
     * @return \StructType\GlobalCurrencyInfo
     */
    public function setName_major($name_major = null)
    {
        // validation for constraint: string
        if (!is_null($name_major) && !is_string($name_major)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name_major)), __LINE__);
        }
        $this->name_major = $name_major;
        return $this;
    }
    /**
     * Get name_minor value
     * @return string|null
     */
    public function getName_minor()
    {
        return $this->name_minor;
    }
    /**
     * Set name_minor value
     * @param string $name_minor
     * @return \StructType\GlobalCurrencyInfo
     */
    public function setName_minor($name_minor = null)
    {
        // validation for constraint: string
        if (!is_null($name_minor) && !is_string($name_minor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name_minor)), __LINE__);
        }
        $this->name_minor = $name_minor;
        return $this;
    }
    /**
     * Get obsolete value
     * @return string|null
     */
    public function getObsolete()
    {
        return $this->obsolete;
    }
    /**
     * Set obsolete value
     * @param string $obsolete
     * @return \StructType\GlobalCurrencyInfo
     */
    public function setObsolete($obsolete = null)
    {
        // validation for constraint: string
        if (!is_null($obsolete) && !is_string($obsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obsolete)), __LINE__);
        }
        $this->obsolete = $obsolete;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GlobalCurrencyInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
