<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUAListRequest StructType
 * @subpackage Structs
 */
class GetUAListRequest extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $profile;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mac;
    /**
     * The inventory_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inventory_id;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usage;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $offset;
    /**
     * Constructor method for GetUAListRequest
     * @uses GetUAListRequest::setName()
     * @uses GetUAListRequest::setType()
     * @uses GetUAListRequest::setProfile()
     * @uses GetUAListRequest::setDescription()
     * @uses GetUAListRequest::setMac()
     * @uses GetUAListRequest::setInventory_id()
     * @uses GetUAListRequest::setUsage()
     * @uses GetUAListRequest::setLimit()
     * @uses GetUAListRequest::setOffset()
     * @param string $name
     * @param string $type
     * @param string $profile
     * @param string $description
     * @param string $mac
     * @param string $inventory_id
     * @param string $usage
     * @param int $limit
     * @param int $offset
     */
    public function __construct($name = null, $type = null, $profile = null, $description = null, $mac = null, $inventory_id = null, $usage = null, $limit = null, $offset = null)
    {
        $this
            ->setName($name)
            ->setType($type)
            ->setProfile($profile)
            ->setDescription($description)
            ->setMac($mac)
            ->setInventory_id($inventory_id)
            ->setUsage($usage)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetUAListRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\GetUAListRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get profile value
     * @return string|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param string $profile
     * @return \StructType\GetUAListRequest
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profile)), __LINE__);
        }
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\GetUAListRequest
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \StructType\GetUAListRequest
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mac)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get inventory_id value
     * @return string|null
     */
    public function getInventory_id()
    {
        return $this->inventory_id;
    }
    /**
     * Set inventory_id value
     * @param string $inventory_id
     * @return \StructType\GetUAListRequest
     */
    public function setInventory_id($inventory_id = null)
    {
        // validation for constraint: string
        if (!is_null($inventory_id) && !is_string($inventory_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventory_id)), __LINE__);
        }
        $this->inventory_id = $inventory_id;
        return $this;
    }
    /**
     * Get usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param string $usage
     * @return \StructType\GetUAListRequest
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: string
        if (!is_null($usage) && !is_string($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usage)), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetUAListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetUAListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUAListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
