<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTransferInfoResponse StructType
 * @subpackage Structs
 */
class GetTransferInfoResponse extends AbstractStructBase
{
    /**
     * The status_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $status_code;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The output_currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $output_currency;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The denomination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $denomination;
    /**
     * Constructor method for GetTransferInfoResponse
     * @uses GetTransferInfoResponse::setStatus_code()
     * @uses GetTransferInfoResponse::setDescription()
     * @uses GetTransferInfoResponse::setOutput_currency()
     * @uses GetTransferInfoResponse::setDestination()
     * @uses GetTransferInfoResponse::setDenomination()
     * @param int $status_code
     * @param string $description
     * @param string $output_currency
     * @param string $destination
     * @param float $denomination
     */
    public function __construct($status_code = null, $description = null, $output_currency = null, $destination = null, $denomination = null)
    {
        $this
            ->setStatus_code($status_code)
            ->setDescription($description)
            ->setOutput_currency($output_currency)
            ->setDestination($destination)
            ->setDenomination($denomination);
    }
    /**
     * Get status_code value
     * @return int
     */
    public function getStatus_code()
    {
        return $this->status_code;
    }
    /**
     * Set status_code value
     * @param int $status_code
     * @return \StructType\GetTransferInfoResponse
     */
    public function setStatus_code($status_code = null)
    {
        // validation for constraint: int
        if (!is_null($status_code) && !is_numeric($status_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status_code)), __LINE__);
        }
        $this->status_code = $status_code;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\GetTransferInfoResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get output_currency value
     * @return string|null
     */
    public function getOutput_currency()
    {
        return $this->output_currency;
    }
    /**
     * Set output_currency value
     * @param string $output_currency
     * @return \StructType\GetTransferInfoResponse
     */
    public function setOutput_currency($output_currency = null)
    {
        // validation for constraint: string
        if (!is_null($output_currency) && !is_string($output_currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($output_currency)), __LINE__);
        }
        $this->output_currency = $output_currency;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\GetTransferInfoResponse
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get denomination value
     * @return float|null
     */
    public function getDenomination()
    {
        return $this->denomination;
    }
    /**
     * Set denomination value
     * @param float $denomination
     * @return \StructType\GetTransferInfoResponse
     */
    public function setDenomination($denomination = null)
    {
        $this->denomination = $denomination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTransferInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
