<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRetailCustomerXDRListResponse StructType
 * @subpackage Structs
 */
class GetRetailCustomerXDRListResponse extends AbstractStructBase
{
    /**
     * The xdr_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:CustomerXDRInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomerXDRInfo[]
     */
    public $xdr_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetRetailCustomerXDRListResponse
     * @uses GetRetailCustomerXDRListResponse::setXdr_list()
     * @uses GetRetailCustomerXDRListResponse::setTotal()
     * @param \StructType\CustomerXDRInfo[] $xdr_list
     * @param int $total
     */
    public function __construct(array $xdr_list = array(), $total = null)
    {
        $this
            ->setXdr_list($xdr_list)
            ->setTotal($total);
    }
    /**
     * Get xdr_list value
     * @return \StructType\CustomerXDRInfo[]|null
     */
    public function getXdr_list()
    {
        return $this->xdr_list;
    }
    /**
     * Set xdr_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerXDRInfo[] $xdr_list
     * @return \StructType\GetRetailCustomerXDRListResponse
     */
    public function setXdr_list(array $xdr_list = array())
    {
        foreach ($xdr_list as $getRetailCustomerXDRListResponseXdr_listItem) {
            // validation for constraint: itemType
            if (!$getRetailCustomerXDRListResponseXdr_listItem instanceof \StructType\CustomerXDRInfo) {
                throw new \InvalidArgumentException(sprintf('The xdr_list property can only contain items of \StructType\CustomerXDRInfo, "%s" given', is_object($getRetailCustomerXDRListResponseXdr_listItem) ? get_class($getRetailCustomerXDRListResponseXdr_listItem) : gettype($getRetailCustomerXDRListResponseXdr_listItem)), __LINE__);
            }
        }
        $this->xdr_list = $xdr_list;
        return $this;
    }
    /**
     * Add item to xdr_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerXDRInfo $item
     * @return \StructType\GetRetailCustomerXDRListResponse
     */
    public function addToXdr_list(\StructType\CustomerXDRInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerXDRInfo) {
            throw new \InvalidArgumentException(sprintf('The xdr_list property can only contain items of \StructType\CustomerXDRInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->xdr_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetRetailCustomerXDRListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRetailCustomerXDRListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
