<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRetailCustomerXDRListRequest StructType
 * @subpackage Structs
 */
class GetRetailCustomerXDRListRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_customer;
    /**
     * The from_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $to_date;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_service;
    /**
     * The i_service_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service_type;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The cdr_entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cdr_entity;
    /**
     * The billing_model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $billing_model;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $get_total;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The show_unsuccessful
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $show_unsuccessful;
    /**
     * Constructor method for GetRetailCustomerXDRListRequest
     * @uses GetRetailCustomerXDRListRequest::setI_customer()
     * @uses GetRetailCustomerXDRListRequest::setFrom_date()
     * @uses GetRetailCustomerXDRListRequest::setTo_date()
     * @uses GetRetailCustomerXDRListRequest::setI_service()
     * @uses GetRetailCustomerXDRListRequest::setI_service_type()
     * @uses GetRetailCustomerXDRListRequest::setLimit()
     * @uses GetRetailCustomerXDRListRequest::setOffset()
     * @uses GetRetailCustomerXDRListRequest::setCdr_entity()
     * @uses GetRetailCustomerXDRListRequest::setBilling_model()
     * @uses GetRetailCustomerXDRListRequest::setGet_total()
     * @uses GetRetailCustomerXDRListRequest::setFormat()
     * @uses GetRetailCustomerXDRListRequest::setShow_unsuccessful()
     * @param int $i_customer
     * @param string $from_date
     * @param string $to_date
     * @param int $i_service
     * @param int $i_service_type
     * @param int $limit
     * @param int $offset
     * @param string $cdr_entity
     * @param int $billing_model
     * @param int $get_total
     * @param string $format
     * @param int $show_unsuccessful
     */
    public function __construct($i_customer = null, $from_date = null, $to_date = null, $i_service = null, $i_service_type = null, $limit = null, $offset = null, $cdr_entity = null, $billing_model = null, $get_total = null, $format = null, $show_unsuccessful = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setI_service($i_service)
            ->setI_service_type($i_service_type)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setCdr_entity($cdr_entity)
            ->setBilling_model($billing_model)
            ->setGet_total($get_total)
            ->setFormat($format)
            ->setShow_unsuccessful($show_unsuccessful);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get from_date value
     * @return string
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Get i_service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_service()
    {
        return isset($this->i_service) ? $this->i_service : null;
    }
    /**
     * Set i_service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_service
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        if (is_null($i_service) || (is_array($i_service) && empty($i_service))) {
            unset($this->i_service);
        } else {
            $this->i_service = $i_service;
        }
        return $this;
    }
    /**
     * Get i_service_type value
     * @return int|null
     */
    public function getI_service_type()
    {
        return $this->i_service_type;
    }
    /**
     * Set i_service_type value
     * @param int $i_service_type
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setI_service_type($i_service_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_service_type) && !is_numeric($i_service_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service_type)), __LINE__);
        }
        $this->i_service_type = $i_service_type;
        return $this;
    }
    /**
     * Get limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLimit()
    {
        return isset($this->limit) ? $this->limit : null;
    }
    /**
     * Set limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $limit
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        if (is_null($limit) || (is_array($limit) && empty($limit))) {
            unset($this->limit);
        } else {
            $this->limit = $limit;
        }
        return $this;
    }
    /**
     * Get offset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOffset()
    {
        return isset($this->offset) ? $this->offset : null;
    }
    /**
     * Set offset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $offset
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        if (is_null($offset) || (is_array($offset) && empty($offset))) {
            unset($this->offset);
        } else {
            $this->offset = $offset;
        }
        return $this;
    }
    /**
     * Get cdr_entity value
     * @return string|null
     */
    public function getCdr_entity()
    {
        return $this->cdr_entity;
    }
    /**
     * Set cdr_entity value
     * @param string $cdr_entity
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setCdr_entity($cdr_entity = null)
    {
        // validation for constraint: string
        if (!is_null($cdr_entity) && !is_string($cdr_entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cdr_entity)), __LINE__);
        }
        $this->cdr_entity = $cdr_entity;
        return $this;
    }
    /**
     * Get billing_model value
     * @return int|null
     */
    public function getBilling_model()
    {
        return $this->billing_model;
    }
    /**
     * Set billing_model value
     * @param int $billing_model
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setBilling_model($billing_model = null)
    {
        // validation for constraint: int
        if (!is_null($billing_model) && !is_numeric($billing_model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billing_model)), __LINE__);
        }
        $this->billing_model = $billing_model;
        return $this;
    }
    /**
     * Get get_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGet_total()
    {
        return isset($this->get_total) ? $this->get_total : null;
    }
    /**
     * Set get_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $get_total
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        if (is_null($get_total) || (is_array($get_total) && empty($get_total))) {
            unset($this->get_total);
        } else {
            $this->get_total = $get_total;
        }
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get show_unsuccessful value
     * @return int|null
     */
    public function getShow_unsuccessful()
    {
        return $this->show_unsuccessful;
    }
    /**
     * Set show_unsuccessful value
     * @param int $show_unsuccessful
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public function setShow_unsuccessful($show_unsuccessful = null)
    {
        // validation for constraint: int
        if (!is_null($show_unsuccessful) && !is_numeric($show_unsuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($show_unsuccessful)), __LINE__);
        }
        $this->show_unsuccessful = $show_unsuccessful;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRetailCustomerXDRListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
