<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPaymentMethodsForOwnerRequest StructType
 * @subpackage Structs
 */
class GetPaymentMethodsForOwnerRequest extends AbstractStructBase
{
    /**
     * The owner_type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $owner_type;
    /**
     * The i_owner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_owner;
    /**
     * Constructor method for GetPaymentMethodsForOwnerRequest
     * @uses GetPaymentMethodsForOwnerRequest::setOwner_type()
     * @uses GetPaymentMethodsForOwnerRequest::setI_owner()
     * @param string $owner_type
     * @param int $i_owner
     */
    public function __construct($owner_type = null, $i_owner = null)
    {
        $this
            ->setOwner_type($owner_type)
            ->setI_owner($i_owner);
    }
    /**
     * Get owner_type value
     * @return string|null
     */
    public function getOwner_type()
    {
        return $this->owner_type;
    }
    /**
     * Set owner_type value
     * @param string $owner_type
     * @return \StructType\GetPaymentMethodsForOwnerRequest
     */
    public function setOwner_type($owner_type = null)
    {
        // validation for constraint: string
        if (!is_null($owner_type) && !is_string($owner_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($owner_type)), __LINE__);
        }
        $this->owner_type = $owner_type;
        return $this;
    }
    /**
     * Get i_owner value
     * @return int|null
     */
    public function getI_owner()
    {
        return $this->i_owner;
    }
    /**
     * Set i_owner value
     * @param int $i_owner
     * @return \StructType\GetPaymentMethodsForOwnerRequest
     */
    public function setI_owner($i_owner = null)
    {
        // validation for constraint: int
        if (!is_null($i_owner) && !is_numeric($i_owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_owner)), __LINE__);
        }
        $this->i_owner = $i_owner;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPaymentMethodsForOwnerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
