<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNetworkConnectivityListResponse StructType
 * @subpackage Structs
 */
class GetNetworkConnectivityListResponse extends AbstractStructBase
{
    /**
     * The connectivities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:NetworkConnectivityInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\NetworkConnectivityInfo[]
     */
    public $connectivities;
    /**
     * Constructor method for GetNetworkConnectivityListResponse
     * @uses GetNetworkConnectivityListResponse::setConnectivities()
     * @param \StructType\NetworkConnectivityInfo[] $connectivities
     */
    public function __construct(array $connectivities = array())
    {
        $this
            ->setConnectivities($connectivities);
    }
    /**
     * Get connectivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NetworkConnectivityInfo[]|null
     */
    public function getConnectivities()
    {
        return isset($this->connectivities) ? $this->connectivities : null;
    }
    /**
     * Set connectivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NetworkConnectivityInfo[] $connectivities
     * @return \StructType\GetNetworkConnectivityListResponse
     */
    public function setConnectivities(array $connectivities = array())
    {
        foreach ($connectivities as $getNetworkConnectivityListResponseConnectivitiesItem) {
            // validation for constraint: itemType
            if (!$getNetworkConnectivityListResponseConnectivitiesItem instanceof \StructType\NetworkConnectivityInfo) {
                throw new \InvalidArgumentException(sprintf('The connectivities property can only contain items of \StructType\NetworkConnectivityInfo, "%s" given', is_object($getNetworkConnectivityListResponseConnectivitiesItem) ? get_class($getNetworkConnectivityListResponseConnectivitiesItem) : gettype($getNetworkConnectivityListResponseConnectivitiesItem)), __LINE__);
            }
        }
        if (is_null($connectivities) || (is_array($connectivities) && empty($connectivities))) {
            unset($this->connectivities);
        } else {
            $this->connectivities = $connectivities;
        }
        return $this;
    }
    /**
     * Add item to connectivities value
     * @throws \InvalidArgumentException
     * @param \StructType\NetworkConnectivityInfo $item
     * @return \StructType\GetNetworkConnectivityListResponse
     */
    public function addToConnectivities(\StructType\NetworkConnectivityInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NetworkConnectivityInfo) {
            throw new \InvalidArgumentException(sprintf('The connectivities property can only contain items of \StructType\NetworkConnectivityInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->connectivities[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetNetworkConnectivityListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
