<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceTemplateListResponse StructType
 * @subpackage Structs
 */
class GetInvoiceTemplateListResponse extends AbstractStructBase
{
    /**
     * The template_list
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - arrayType: pst:InvoiceTemplateInfo[]
     * - ref: soapenc:arrayType
     * @var InvoiceTemplateInfo
     */
    public $template_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetInvoiceTemplateListResponse
     * @uses GetInvoiceTemplateListResponse::setTemplate_list()
     * @uses GetInvoiceTemplateListResponse::setTotal()
     * @param InvoiceTemplateInfo $template_list
     * @param int $total
     */
    public function __construct(InvoiceTemplateInfo $template_list = null, $total = null)
    {
        $this
            ->setTemplate_list($template_list)
            ->setTotal($total);
    }
    /**
     * Get template_list value
     * @return InvoiceTemplateInfo
     */
    public function getTemplate_list()
    {
        return $this->template_list;
    }
    /**
     * Set template_list value
     * @param InvoiceTemplateInfo $template_list
     * @return \StructType\GetInvoiceTemplateListResponse
     */
    public function setTemplate_list(InvoiceTemplateInfo $template_list = null)
    {
        $this->template_list = $template_list;
        return $this;
    }
    /**
     * Get total value
     * @return int
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetInvoiceTemplateListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoiceTemplateListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
