<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceListRequest StructType
 * @subpackage Structs
 */
class GetInvoiceListRequest extends AbstractStructBase
{
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $offset;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The invoice_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $invoice_number;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The i_parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_parent;
    /**
     * The from_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $to_date;
    /**
     * Constructor method for GetInvoiceListRequest
     * @uses GetInvoiceListRequest::setOffset()
     * @uses GetInvoiceListRequest::setLimit()
     * @uses GetInvoiceListRequest::setInvoice_number()
     * @uses GetInvoiceListRequest::setI_customer()
     * @uses GetInvoiceListRequest::setI_parent()
     * @uses GetInvoiceListRequest::setFrom_date()
     * @uses GetInvoiceListRequest::setTo_date()
     * @param int $offset
     * @param int $limit
     * @param int $invoice_number
     * @param int $i_customer
     * @param int $i_parent
     * @param string $from_date
     * @param string $to_date
     */
    public function __construct($offset = null, $limit = null, $invoice_number = null, $i_customer = null, $i_parent = null, $from_date = null, $to_date = null)
    {
        $this
            ->setOffset($offset)
            ->setLimit($limit)
            ->setInvoice_number($invoice_number)
            ->setI_customer($i_customer)
            ->setI_parent($i_parent)
            ->setFrom_date($from_date)
            ->setTo_date($to_date);
    }
    /**
     * Get offset value
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetInvoiceListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetInvoiceListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get invoice_number value
     * @return int|null
     */
    public function getInvoice_number()
    {
        return $this->invoice_number;
    }
    /**
     * Set invoice_number value
     * @param int $invoice_number
     * @return \StructType\GetInvoiceListRequest
     */
    public function setInvoice_number($invoice_number = null)
    {
        // validation for constraint: int
        if (!is_null($invoice_number) && !is_numeric($invoice_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoice_number)), __LINE__);
        }
        $this->invoice_number = $invoice_number;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetInvoiceListRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_parent value
     * @return int|null
     */
    public function getI_parent()
    {
        return $this->i_parent;
    }
    /**
     * Set i_parent value
     * @param int $i_parent
     * @return \StructType\GetInvoiceListRequest
     */
    public function setI_parent($i_parent = null)
    {
        // validation for constraint: int
        if (!is_null($i_parent) && !is_numeric($i_parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_parent)), __LINE__);
        }
        $this->i_parent = $i_parent;
        return $this;
    }
    /**
     * Get from_date value
     * @return string|null
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \StructType\GetInvoiceListRequest
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string|null
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \StructType\GetInvoiceListRequest
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoiceListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
