<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDestGroupSetListResponse StructType
 * @subpackage Structs
 */
class GetDestGroupSetListResponse extends AbstractStructBase
{
    /**
     * The dest_group_set_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:DestGroupSetInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DestGroupSetInfo[]
     */
    public $dest_group_set_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetDestGroupSetListResponse
     * @uses GetDestGroupSetListResponse::setDest_group_set_list()
     * @uses GetDestGroupSetListResponse::setTotal()
     * @param \StructType\DestGroupSetInfo[] $dest_group_set_list
     * @param int $total
     */
    public function __construct(array $dest_group_set_list = array(), $total = null)
    {
        $this
            ->setDest_group_set_list($dest_group_set_list)
            ->setTotal($total);
    }
    /**
     * Get dest_group_set_list value
     * @return \StructType\DestGroupSetInfo[]|null
     */
    public function getDest_group_set_list()
    {
        return $this->dest_group_set_list;
    }
    /**
     * Set dest_group_set_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestGroupSetInfo[] $dest_group_set_list
     * @return \StructType\GetDestGroupSetListResponse
     */
    public function setDest_group_set_list(array $dest_group_set_list = array())
    {
        foreach ($dest_group_set_list as $getDestGroupSetListResponseDest_group_set_listItem) {
            // validation for constraint: itemType
            if (!$getDestGroupSetListResponseDest_group_set_listItem instanceof \StructType\DestGroupSetInfo) {
                throw new \InvalidArgumentException(sprintf('The dest_group_set_list property can only contain items of \StructType\DestGroupSetInfo, "%s" given', is_object($getDestGroupSetListResponseDest_group_set_listItem) ? get_class($getDestGroupSetListResponseDest_group_set_listItem) : gettype($getDestGroupSetListResponseDest_group_set_listItem)), __LINE__);
            }
        }
        $this->dest_group_set_list = $dest_group_set_list;
        return $this;
    }
    /**
     * Add item to dest_group_set_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestGroupSetInfo $item
     * @return \StructType\GetDestGroupSetListResponse
     */
    public function addToDest_group_set_list(\StructType\DestGroupSetInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DestGroupSetInfo) {
            throw new \InvalidArgumentException(sprintf('The dest_group_set_list property can only contain items of \StructType\DestGroupSetInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dest_group_set_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetDestGroupSetListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDestGroupSetListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
