<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDestGroupInfoResponse StructType
 * @subpackage Structs
 */
class GetDestGroupInfoResponse extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The destination_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:DestinationPrefixInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DestinationPrefixInfo[]
     */
    public $destination_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetDestGroupInfoResponse
     * @uses GetDestGroupInfoResponse::setName()
     * @uses GetDestGroupInfoResponse::setDestination_list()
     * @uses GetDestGroupInfoResponse::setTotal()
     * @param string $name
     * @param \StructType\DestinationPrefixInfo[] $destination_list
     * @param int $total
     */
    public function __construct($name = null, array $destination_list = array(), $total = null)
    {
        $this
            ->setName($name)
            ->setDestination_list($destination_list)
            ->setTotal($total);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetDestGroupInfoResponse
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get destination_list value
     * @return \StructType\DestinationPrefixInfo[]|null
     */
    public function getDestination_list()
    {
        return $this->destination_list;
    }
    /**
     * Set destination_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationPrefixInfo[] $destination_list
     * @return \StructType\GetDestGroupInfoResponse
     */
    public function setDestination_list(array $destination_list = array())
    {
        foreach ($destination_list as $getDestGroupInfoResponseDestination_listItem) {
            // validation for constraint: itemType
            if (!$getDestGroupInfoResponseDestination_listItem instanceof \StructType\DestinationPrefixInfo) {
                throw new \InvalidArgumentException(sprintf('The destination_list property can only contain items of \StructType\DestinationPrefixInfo, "%s" given', is_object($getDestGroupInfoResponseDestination_listItem) ? get_class($getDestGroupInfoResponseDestination_listItem) : gettype($getDestGroupInfoResponseDestination_listItem)), __LINE__);
            }
        }
        $this->destination_list = $destination_list;
        return $this;
    }
    /**
     * Add item to destination_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationPrefixInfo $item
     * @return \StructType\GetDestGroupInfoResponse
     */
    public function addToDestination_list(\StructType\DestinationPrefixInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DestinationPrefixInfo) {
            throw new \InvalidArgumentException(sprintf('The destination_list property can only contain items of \StructType\DestinationPrefixInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->destination_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetDestGroupInfoResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDestGroupInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
