<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerSitesResponse StructType
 * @subpackage Structs
 */
class GetCustomerSitesResponse extends AbstractStructBase
{
    /**
     * The sites
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:CustomerSiteInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomerSiteInfo[]
     */
    public $sites;
    /**
     * Constructor method for GetCustomerSitesResponse
     * @uses GetCustomerSitesResponse::setSites()
     * @param \StructType\CustomerSiteInfo[] $sites
     */
    public function __construct(array $sites = array())
    {
        $this
            ->setSites($sites);
    }
    /**
     * Get sites value
     * @return \StructType\CustomerSiteInfo[]
     */
    public function getSites()
    {
        return $this->sites;
    }
    /**
     * Set sites value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSiteInfo[] $sites
     * @return \StructType\GetCustomerSitesResponse
     */
    public function setSites(array $sites = array())
    {
        foreach ($sites as $getCustomerSitesResponseSitesItem) {
            // validation for constraint: itemType
            if (!$getCustomerSitesResponseSitesItem instanceof \StructType\CustomerSiteInfo) {
                throw new \InvalidArgumentException(sprintf('The sites property can only contain items of \StructType\CustomerSiteInfo, "%s" given', is_object($getCustomerSitesResponseSitesItem) ? get_class($getCustomerSitesResponseSitesItem) : gettype($getCustomerSitesResponseSitesItem)), __LINE__);
            }
        }
        $this->sites = $sites;
        return $this;
    }
    /**
     * Add item to sites value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSiteInfo $item
     * @return \StructType\GetCustomerSitesResponse
     */
    public function addToSites(\StructType\CustomerSiteInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSiteInfo) {
            throw new \InvalidArgumentException(sprintf('The sites property can only contain items of \StructType\CustomerSiteInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->sites[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerSitesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
