<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerInvoicesResponse StructType
 * @subpackage Structs
 */
class GetCustomerInvoicesResponse extends AbstractStructBase
{
    /**
     * The invoices
     * Meta informations extracted from the WSDL
     * - arrayType: pst:CustomerInvoicesListInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomerInvoicesListInfo[]
     */
    public $invoices;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * The recommended_amount_to_pay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $recommended_amount_to_pay;
    /**
     * The last_due_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $last_due_date;
    /**
     * Constructor method for GetCustomerInvoicesResponse
     * @uses GetCustomerInvoicesResponse::setInvoices()
     * @uses GetCustomerInvoicesResponse::setTotal()
     * @uses GetCustomerInvoicesResponse::setRecommended_amount_to_pay()
     * @uses GetCustomerInvoicesResponse::setLast_due_date()
     * @param \StructType\CustomerInvoicesListInfo[] $invoices
     * @param int $total
     * @param float $recommended_amount_to_pay
     * @param string $last_due_date
     */
    public function __construct(array $invoices = array(), $total = null, $recommended_amount_to_pay = null, $last_due_date = null)
    {
        $this
            ->setInvoices($invoices)
            ->setTotal($total)
            ->setRecommended_amount_to_pay($recommended_amount_to_pay)
            ->setLast_due_date($last_due_date);
    }
    /**
     * Get invoices value
     * @return \StructType\CustomerInvoicesListInfo[]|null
     */
    public function getInvoices()
    {
        return $this->invoices;
    }
    /**
     * Set invoices value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerInvoicesListInfo[] $invoices
     * @return \StructType\GetCustomerInvoicesResponse
     */
    public function setInvoices(array $invoices = array())
    {
        foreach ($invoices as $getCustomerInvoicesResponseInvoicesItem) {
            // validation for constraint: itemType
            if (!$getCustomerInvoicesResponseInvoicesItem instanceof \StructType\CustomerInvoicesListInfo) {
                throw new \InvalidArgumentException(sprintf('The invoices property can only contain items of \StructType\CustomerInvoicesListInfo, "%s" given', is_object($getCustomerInvoicesResponseInvoicesItem) ? get_class($getCustomerInvoicesResponseInvoicesItem) : gettype($getCustomerInvoicesResponseInvoicesItem)), __LINE__);
            }
        }
        $this->invoices = $invoices;
        return $this;
    }
    /**
     * Add item to invoices value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerInvoicesListInfo $item
     * @return \StructType\GetCustomerInvoicesResponse
     */
    public function addToInvoices(\StructType\CustomerInvoicesListInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerInvoicesListInfo) {
            throw new \InvalidArgumentException(sprintf('The invoices property can only contain items of \StructType\CustomerInvoicesListInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->invoices[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetCustomerInvoicesResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Get recommended_amount_to_pay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRecommended_amount_to_pay()
    {
        return isset($this->recommended_amount_to_pay) ? $this->recommended_amount_to_pay : null;
    }
    /**
     * Set recommended_amount_to_pay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $recommended_amount_to_pay
     * @return \StructType\GetCustomerInvoicesResponse
     */
    public function setRecommended_amount_to_pay($recommended_amount_to_pay = null)
    {
        if (is_null($recommended_amount_to_pay) || (is_array($recommended_amount_to_pay) && empty($recommended_amount_to_pay))) {
            unset($this->recommended_amount_to_pay);
        } else {
            $this->recommended_amount_to_pay = $recommended_amount_to_pay;
        }
        return $this;
    }
    /**
     * Get last_due_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLast_due_date()
    {
        return isset($this->last_due_date) ? $this->last_due_date : null;
    }
    /**
     * Set last_due_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $last_due_date
     * @return \StructType\GetCustomerInvoicesResponse
     */
    public function setLast_due_date($last_due_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_due_date) && !is_string($last_due_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_due_date)), __LINE__);
        }
        if (is_null($last_due_date) || (is_array($last_due_date) && empty($last_due_date))) {
            unset($this->last_due_date);
        } else {
            $this->last_due_date = $last_due_date;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerInvoicesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
