<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerInvoicesRequest StructType
 * @subpackage Structs
 */
class GetCustomerInvoicesRequest extends AbstractStructBase
{
    /**
     * The invoice_number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoice_number;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The from_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $to_date;
    /**
     * The show_void
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $show_void;
    /**
     * The only_pay_required
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $only_pay_required;
    /**
     * The only_last_unpaid_invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $only_last_unpaid_invoice;
    /**
     * Constructor method for GetCustomerInvoicesRequest
     * @uses GetCustomerInvoicesRequest::setInvoice_number()
     * @uses GetCustomerInvoicesRequest::setI_customer()
     * @uses GetCustomerInvoicesRequest::setLimit()
     * @uses GetCustomerInvoicesRequest::setOffset()
     * @uses GetCustomerInvoicesRequest::setFrom_date()
     * @uses GetCustomerInvoicesRequest::setTo_date()
     * @uses GetCustomerInvoicesRequest::setShow_void()
     * @uses GetCustomerInvoicesRequest::setOnly_pay_required()
     * @uses GetCustomerInvoicesRequest::setOnly_last_unpaid_invoice()
     * @param string $invoice_number
     * @param int $i_customer
     * @param int $limit
     * @param int $offset
     * @param string $from_date
     * @param string $to_date
     * @param int $show_void
     * @param int $only_pay_required
     * @param int $only_last_unpaid_invoice
     */
    public function __construct($invoice_number = null, $i_customer = null, $limit = null, $offset = null, $from_date = null, $to_date = null, $show_void = null, $only_pay_required = null, $only_last_unpaid_invoice = null)
    {
        $this
            ->setInvoice_number($invoice_number)
            ->setI_customer($i_customer)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setShow_void($show_void)
            ->setOnly_pay_required($only_pay_required)
            ->setOnly_last_unpaid_invoice($only_last_unpaid_invoice);
    }
    /**
     * Get invoice_number value
     * @return string|null
     */
    public function getInvoice_number()
    {
        return $this->invoice_number;
    }
    /**
     * Set invoice_number value
     * @param string $invoice_number
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setInvoice_number($invoice_number = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_number) && !is_string($invoice_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_number)), __LINE__);
        }
        $this->invoice_number = $invoice_number;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOffset()
    {
        return isset($this->offset) ? $this->offset : null;
    }
    /**
     * Set offset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $offset
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        if (is_null($offset) || (is_array($offset) && empty($offset))) {
            unset($this->offset);
        } else {
            $this->offset = $offset;
        }
        return $this;
    }
    /**
     * Get from_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrom_date()
    {
        return isset($this->from_date) ? $this->from_date : null;
    }
    /**
     * Set from_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $from_date
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        if (is_null($from_date) || (is_array($from_date) && empty($from_date))) {
            unset($this->from_date);
        } else {
            $this->from_date = $from_date;
        }
        return $this;
    }
    /**
     * Get to_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTo_date()
    {
        return isset($this->to_date) ? $this->to_date : null;
    }
    /**
     * Set to_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $to_date
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        if (is_null($to_date) || (is_array($to_date) && empty($to_date))) {
            unset($this->to_date);
        } else {
            $this->to_date = $to_date;
        }
        return $this;
    }
    /**
     * Get show_void value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShow_void()
    {
        return isset($this->show_void) ? $this->show_void : null;
    }
    /**
     * Set show_void value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $show_void
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setShow_void($show_void = null)
    {
        // validation for constraint: int
        if (!is_null($show_void) && !is_numeric($show_void)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($show_void)), __LINE__);
        }
        if (is_null($show_void) || (is_array($show_void) && empty($show_void))) {
            unset($this->show_void);
        } else {
            $this->show_void = $show_void;
        }
        return $this;
    }
    /**
     * Get only_pay_required value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnly_pay_required()
    {
        return isset($this->only_pay_required) ? $this->only_pay_required : null;
    }
    /**
     * Set only_pay_required value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $only_pay_required
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setOnly_pay_required($only_pay_required = null)
    {
        // validation for constraint: int
        if (!is_null($only_pay_required) && !is_numeric($only_pay_required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($only_pay_required)), __LINE__);
        }
        if (is_null($only_pay_required) || (is_array($only_pay_required) && empty($only_pay_required))) {
            unset($this->only_pay_required);
        } else {
            $this->only_pay_required = $only_pay_required;
        }
        return $this;
    }
    /**
     * Get only_last_unpaid_invoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnly_last_unpaid_invoice()
    {
        return isset($this->only_last_unpaid_invoice) ? $this->only_last_unpaid_invoice : null;
    }
    /**
     * Set only_last_unpaid_invoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $only_last_unpaid_invoice
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public function setOnly_last_unpaid_invoice($only_last_unpaid_invoice = null)
    {
        // validation for constraint: int
        if (!is_null($only_last_unpaid_invoice) && !is_numeric($only_last_unpaid_invoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($only_last_unpaid_invoice)), __LINE__);
        }
        if (is_null($only_last_unpaid_invoice) || (is_array($only_last_unpaid_invoice) && empty($only_last_unpaid_invoice))) {
            unset($this->only_last_unpaid_invoice);
        } else {
            $this->only_last_unpaid_invoice = $only_last_unpaid_invoice;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerInvoicesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
