<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerDIDNumbersResponse StructType
 * @subpackage Structs
 */
class GetCustomerDIDNumbersResponse extends AbstractStructBase
{
    /**
     * The number_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:CustomerDIDNumberInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomerDIDNumberInfo[]
     */
    public $number_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetCustomerDIDNumbersResponse
     * @uses GetCustomerDIDNumbersResponse::setNumber_list()
     * @uses GetCustomerDIDNumbersResponse::setTotal()
     * @param \StructType\CustomerDIDNumberInfo[] $number_list
     * @param int $total
     */
    public function __construct(array $number_list = array(), $total = null)
    {
        $this
            ->setNumber_list($number_list)
            ->setTotal($total);
    }
    /**
     * Get number_list value
     * @return \StructType\CustomerDIDNumberInfo[]|null
     */
    public function getNumber_list()
    {
        return $this->number_list;
    }
    /**
     * Set number_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDIDNumberInfo[] $number_list
     * @return \StructType\GetCustomerDIDNumbersResponse
     */
    public function setNumber_list(array $number_list = array())
    {
        foreach ($number_list as $getCustomerDIDNumbersResponseNumber_listItem) {
            // validation for constraint: itemType
            if (!$getCustomerDIDNumbersResponseNumber_listItem instanceof \StructType\CustomerDIDNumberInfo) {
                throw new \InvalidArgumentException(sprintf('The number_list property can only contain items of \StructType\CustomerDIDNumberInfo, "%s" given', is_object($getCustomerDIDNumbersResponseNumber_listItem) ? get_class($getCustomerDIDNumbersResponseNumber_listItem) : gettype($getCustomerDIDNumbersResponseNumber_listItem)), __LINE__);
            }
        }
        $this->number_list = $number_list;
        return $this;
    }
    /**
     * Add item to number_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerDIDNumberInfo $item
     * @return \StructType\GetCustomerDIDNumbersResponse
     */
    public function addToNumber_list(\StructType\CustomerDIDNumberInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerDIDNumberInfo) {
            throw new \InvalidArgumentException(sprintf('The number_list property can only contain items of \StructType\CustomerDIDNumberInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->number_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetCustomerDIDNumbersResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerDIDNumbersResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
