<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerConsumedServiceRequest StructType
 * @subpackage Structs
 */
class GetCustomerConsumedServiceRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * @var int
     */
    public $i_customer;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_service;
    /**
     * The from_date
     * @var string
     */
    public $from_date;
    /**
     * The to_date
     * @var string
     */
    public $to_date;
    /**
     * The billing_model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $billing_model;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $offset;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $get_total;
    /**
     * The show_unsuccessful
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $show_unsuccessful;
    /**
     * Constructor method for GetCustomerConsumedServiceRequest
     * @uses GetCustomerConsumedServiceRequest::setI_customer()
     * @uses GetCustomerConsumedServiceRequest::setI_service()
     * @uses GetCustomerConsumedServiceRequest::setFrom_date()
     * @uses GetCustomerConsumedServiceRequest::setTo_date()
     * @uses GetCustomerConsumedServiceRequest::setBilling_model()
     * @uses GetCustomerConsumedServiceRequest::setLimit()
     * @uses GetCustomerConsumedServiceRequest::setOffset()
     * @uses GetCustomerConsumedServiceRequest::setGet_total()
     * @uses GetCustomerConsumedServiceRequest::setShow_unsuccessful()
     * @param int $i_customer
     * @param int $i_service
     * @param string $from_date
     * @param string $to_date
     * @param int $billing_model
     * @param int $limit
     * @param int $offset
     * @param int $get_total
     * @param int $show_unsuccessful
     */
    public function __construct($i_customer = null, $i_service = null, $from_date = null, $to_date = null, $billing_model = null, $limit = null, $offset = null, $get_total = null, $show_unsuccessful = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setI_service($i_service)
            ->setFrom_date($from_date)
            ->setTo_date($to_date)
            ->setBilling_model($billing_model)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setGet_total($get_total)
            ->setShow_unsuccessful($show_unsuccessful);
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_service()
    {
        return isset($this->i_service) ? $this->i_service : null;
    }
    /**
     * Set i_service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_service
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        if (is_null($i_service) || (is_array($i_service) && empty($i_service))) {
            unset($this->i_service);
        } else {
            $this->i_service = $i_service;
        }
        return $this;
    }
    /**
     * Get from_date value
     * @return string|null
     */
    public function getFrom_date()
    {
        return $this->from_date;
    }
    /**
     * Set from_date value
     * @param string $from_date
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setFrom_date($from_date = null)
    {
        // validation for constraint: string
        if (!is_null($from_date) && !is_string($from_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from_date)), __LINE__);
        }
        $this->from_date = $from_date;
        return $this;
    }
    /**
     * Get to_date value
     * @return string|null
     */
    public function getTo_date()
    {
        return $this->to_date;
    }
    /**
     * Set to_date value
     * @param string $to_date
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setTo_date($to_date = null)
    {
        // validation for constraint: string
        if (!is_null($to_date) && !is_string($to_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to_date)), __LINE__);
        }
        $this->to_date = $to_date;
        return $this;
    }
    /**
     * Get billing_model value
     * @return int|null
     */
    public function getBilling_model()
    {
        return $this->billing_model;
    }
    /**
     * Set billing_model value
     * @param int $billing_model
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setBilling_model($billing_model = null)
    {
        // validation for constraint: int
        if (!is_null($billing_model) && !is_numeric($billing_model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billing_model)), __LINE__);
        }
        $this->billing_model = $billing_model;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get get_total value
     * @return int|null
     */
    public function getGet_total()
    {
        return $this->get_total;
    }
    /**
     * Set get_total value
     * @param int $get_total
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        $this->get_total = $get_total;
        return $this;
    }
    /**
     * Get show_unsuccessful value
     * @return int|null
     */
    public function getShow_unsuccessful()
    {
        return $this->show_unsuccessful;
    }
    /**
     * Set show_unsuccessful value
     * @param int $show_unsuccessful
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public function setShow_unsuccessful($show_unsuccessful = null)
    {
        // validation for constraint: int
        if (!is_null($show_unsuccessful) && !is_numeric($show_unsuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($show_unsuccessful)), __LINE__);
        }
        $this->show_unsuccessful = $show_unsuccessful;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerConsumedServiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
