<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerClassListResponse StructType
 * @subpackage Structs
 */
class GetCustomerClassListResponse extends AbstractStructBase
{
    /**
     * The customer_class_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:CustomerClassInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomerClassInfo[]
     */
    public $customer_class_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetCustomerClassListResponse
     * @uses GetCustomerClassListResponse::setCustomer_class_list()
     * @uses GetCustomerClassListResponse::setTotal()
     * @param \StructType\CustomerClassInfo[] $customer_class_list
     * @param int $total
     */
    public function __construct(array $customer_class_list = array(), $total = null)
    {
        $this
            ->setCustomer_class_list($customer_class_list)
            ->setTotal($total);
    }
    /**
     * Get customer_class_list value
     * @return \StructType\CustomerClassInfo[]|null
     */
    public function getCustomer_class_list()
    {
        return $this->customer_class_list;
    }
    /**
     * Set customer_class_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerClassInfo[] $customer_class_list
     * @return \StructType\GetCustomerClassListResponse
     */
    public function setCustomer_class_list(array $customer_class_list = array())
    {
        foreach ($customer_class_list as $getCustomerClassListResponseCustomer_class_listItem) {
            // validation for constraint: itemType
            if (!$getCustomerClassListResponseCustomer_class_listItem instanceof \StructType\CustomerClassInfo) {
                throw new \InvalidArgumentException(sprintf('The customer_class_list property can only contain items of \StructType\CustomerClassInfo, "%s" given', is_object($getCustomerClassListResponseCustomer_class_listItem) ? get_class($getCustomerClassListResponseCustomer_class_listItem) : gettype($getCustomerClassListResponseCustomer_class_listItem)), __LINE__);
            }
        }
        $this->customer_class_list = $customer_class_list;
        return $this;
    }
    /**
     * Add item to customer_class_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerClassInfo $item
     * @return \StructType\GetCustomerClassListResponse
     */
    public function addToCustomer_class_list(\StructType\CustomerClassInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerClassInfo) {
            throw new \InvalidArgumentException(sprintf('The customer_class_list property can only contain items of \StructType\CustomerClassInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customer_class_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetCustomerClassListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerClassListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
