<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCPConditionListResponse StructType
 * @subpackage Structs
 */
class GetCPConditionListResponse extends AbstractStructBase
{
    /**
     * The cp_condition_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:CPConditionInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CPConditionInfo[]
     */
    public $cp_condition_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetCPConditionListResponse
     * @uses GetCPConditionListResponse::setCp_condition_list()
     * @uses GetCPConditionListResponse::setTotal()
     * @param \StructType\CPConditionInfo[] $cp_condition_list
     * @param int $total
     */
    public function __construct(array $cp_condition_list = array(), $total = null)
    {
        $this
            ->setCp_condition_list($cp_condition_list)
            ->setTotal($total);
    }
    /**
     * Get cp_condition_list value
     * @return \StructType\CPConditionInfo[]|null
     */
    public function getCp_condition_list()
    {
        return $this->cp_condition_list;
    }
    /**
     * Set cp_condition_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CPConditionInfo[] $cp_condition_list
     * @return \StructType\GetCPConditionListResponse
     */
    public function setCp_condition_list(array $cp_condition_list = array())
    {
        foreach ($cp_condition_list as $getCPConditionListResponseCp_condition_listItem) {
            // validation for constraint: itemType
            if (!$getCPConditionListResponseCp_condition_listItem instanceof \StructType\CPConditionInfo) {
                throw new \InvalidArgumentException(sprintf('The cp_condition_list property can only contain items of \StructType\CPConditionInfo, "%s" given', is_object($getCPConditionListResponseCp_condition_listItem) ? get_class($getCPConditionListResponseCp_condition_listItem) : gettype($getCPConditionListResponseCp_condition_listItem)), __LINE__);
            }
        }
        $this->cp_condition_list = $cp_condition_list;
        return $this;
    }
    /**
     * Add item to cp_condition_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CPConditionInfo $item
     * @return \StructType\GetCPConditionListResponse
     */
    public function addToCp_condition_list(\StructType\CPConditionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CPConditionInfo) {
            throw new \InvalidArgumentException(sprintf('The cp_condition_list property can only contain items of \StructType\CPConditionInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cp_condition_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetCPConditionListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCPConditionListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
