<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountPermittedProxyInfoResponse StructType
 * @subpackage Structs
 */
class GetAccountPermittedProxyInfoResponse extends AbstractStructBase
{
    /**
     * The is_add_new_sip_proxy_allowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $is_add_new_sip_proxy_allowed;
    /**
     * The permitted_sip_proxies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:PermittedSipProxiesInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\PermittedSipProxiesInfo[]
     */
    public $permitted_sip_proxies;
    /**
     * Constructor method for GetAccountPermittedProxyInfoResponse
     * @uses GetAccountPermittedProxyInfoResponse::setIs_add_new_sip_proxy_allowed()
     * @uses GetAccountPermittedProxyInfoResponse::setPermitted_sip_proxies()
     * @param int $is_add_new_sip_proxy_allowed
     * @param \StructType\PermittedSipProxiesInfo[] $permitted_sip_proxies
     */
    public function __construct($is_add_new_sip_proxy_allowed = null, array $permitted_sip_proxies = array())
    {
        $this
            ->setIs_add_new_sip_proxy_allowed($is_add_new_sip_proxy_allowed)
            ->setPermitted_sip_proxies($permitted_sip_proxies);
    }
    /**
     * Get is_add_new_sip_proxy_allowed value
     * @return int|null
     */
    public function getIs_add_new_sip_proxy_allowed()
    {
        return $this->is_add_new_sip_proxy_allowed;
    }
    /**
     * Set is_add_new_sip_proxy_allowed value
     * @param int $is_add_new_sip_proxy_allowed
     * @return \StructType\GetAccountPermittedProxyInfoResponse
     */
    public function setIs_add_new_sip_proxy_allowed($is_add_new_sip_proxy_allowed = null)
    {
        // validation for constraint: int
        if (!is_null($is_add_new_sip_proxy_allowed) && !is_numeric($is_add_new_sip_proxy_allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_add_new_sip_proxy_allowed)), __LINE__);
        }
        $this->is_add_new_sip_proxy_allowed = $is_add_new_sip_proxy_allowed;
        return $this;
    }
    /**
     * Get permitted_sip_proxies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PermittedSipProxiesInfo[]|null
     */
    public function getPermitted_sip_proxies()
    {
        return isset($this->permitted_sip_proxies) ? $this->permitted_sip_proxies : null;
    }
    /**
     * Set permitted_sip_proxies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PermittedSipProxiesInfo[] $permitted_sip_proxies
     * @return \StructType\GetAccountPermittedProxyInfoResponse
     */
    public function setPermitted_sip_proxies(array $permitted_sip_proxies = array())
    {
        foreach ($permitted_sip_proxies as $getAccountPermittedProxyInfoResponsePermitted_sip_proxiesItem) {
            // validation for constraint: itemType
            if (!$getAccountPermittedProxyInfoResponsePermitted_sip_proxiesItem instanceof \StructType\PermittedSipProxiesInfo) {
                throw new \InvalidArgumentException(sprintf('The permitted_sip_proxies property can only contain items of \StructType\PermittedSipProxiesInfo, "%s" given', is_object($getAccountPermittedProxyInfoResponsePermitted_sip_proxiesItem) ? get_class($getAccountPermittedProxyInfoResponsePermitted_sip_proxiesItem) : gettype($getAccountPermittedProxyInfoResponsePermitted_sip_proxiesItem)), __LINE__);
            }
        }
        if (is_null($permitted_sip_proxies) || (is_array($permitted_sip_proxies) && empty($permitted_sip_proxies))) {
            unset($this->permitted_sip_proxies);
        } else {
            $this->permitted_sip_proxies = $permitted_sip_proxies;
        }
        return $this;
    }
    /**
     * Add item to permitted_sip_proxies value
     * @throws \InvalidArgumentException
     * @param \StructType\PermittedSipProxiesInfo $item
     * @return \StructType\GetAccountPermittedProxyInfoResponse
     */
    public function addToPermitted_sip_proxies(\StructType\PermittedSipProxiesInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PermittedSipProxiesInfo) {
            throw new \InvalidArgumentException(sprintf('The permitted_sip_proxies property can only contain items of \StructType\PermittedSipProxiesInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->permitted_sip_proxies[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountPermittedProxyInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
