<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountFollowMeResponse StructType
 * @subpackage Structs
 */
class GetAccountFollowMeResponse extends AbstractStructBase
{
    /**
     * The followme_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FollowMeInfo
     */
    public $followme_info;
    /**
     * The followme_numbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:FollowMeNumberInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\FollowMeNumberInfo[]
     */
    public $followme_numbers;
    /**
     * The default_followme_numbers_timeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $default_followme_numbers_timeout;
    /**
     * Constructor method for GetAccountFollowMeResponse
     * @uses GetAccountFollowMeResponse::setFollowme_info()
     * @uses GetAccountFollowMeResponse::setFollowme_numbers()
     * @uses GetAccountFollowMeResponse::setDefault_followme_numbers_timeout()
     * @param \StructType\FollowMeInfo $followme_info
     * @param \StructType\FollowMeNumberInfo[] $followme_numbers
     * @param int $default_followme_numbers_timeout
     */
    public function __construct(\StructType\FollowMeInfo $followme_info = null, array $followme_numbers = array(), $default_followme_numbers_timeout = null)
    {
        $this
            ->setFollowme_info($followme_info)
            ->setFollowme_numbers($followme_numbers)
            ->setDefault_followme_numbers_timeout($default_followme_numbers_timeout);
    }
    /**
     * Get followme_info value
     * @return \StructType\FollowMeInfo|null
     */
    public function getFollowme_info()
    {
        return $this->followme_info;
    }
    /**
     * Set followme_info value
     * @param \StructType\FollowMeInfo $followme_info
     * @return \StructType\GetAccountFollowMeResponse
     */
    public function setFollowme_info(\StructType\FollowMeInfo $followme_info = null)
    {
        $this->followme_info = $followme_info;
        return $this;
    }
    /**
     * Get followme_numbers value
     * @return \StructType\FollowMeNumberInfo[]|null
     */
    public function getFollowme_numbers()
    {
        return $this->followme_numbers;
    }
    /**
     * Set followme_numbers value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowMeNumberInfo[] $followme_numbers
     * @return \StructType\GetAccountFollowMeResponse
     */
    public function setFollowme_numbers(array $followme_numbers = array())
    {
        foreach ($followme_numbers as $getAccountFollowMeResponseFollowme_numbersItem) {
            // validation for constraint: itemType
            if (!$getAccountFollowMeResponseFollowme_numbersItem instanceof \StructType\FollowMeNumberInfo) {
                throw new \InvalidArgumentException(sprintf('The followme_numbers property can only contain items of \StructType\FollowMeNumberInfo, "%s" given', is_object($getAccountFollowMeResponseFollowme_numbersItem) ? get_class($getAccountFollowMeResponseFollowme_numbersItem) : gettype($getAccountFollowMeResponseFollowme_numbersItem)), __LINE__);
            }
        }
        $this->followme_numbers = $followme_numbers;
        return $this;
    }
    /**
     * Add item to followme_numbers value
     * @throws \InvalidArgumentException
     * @param \StructType\FollowMeNumberInfo $item
     * @return \StructType\GetAccountFollowMeResponse
     */
    public function addToFollowme_numbers(\StructType\FollowMeNumberInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FollowMeNumberInfo) {
            throw new \InvalidArgumentException(sprintf('The followme_numbers property can only contain items of \StructType\FollowMeNumberInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->followme_numbers[] = $item;
        return $this;
    }
    /**
     * Get default_followme_numbers_timeout value
     * @return int|null
     */
    public function getDefault_followme_numbers_timeout()
    {
        return $this->default_followme_numbers_timeout;
    }
    /**
     * Set default_followme_numbers_timeout value
     * @param int $default_followme_numbers_timeout
     * @return \StructType\GetAccountFollowMeResponse
     */
    public function setDefault_followme_numbers_timeout($default_followme_numbers_timeout = null)
    {
        // validation for constraint: int
        if (!is_null($default_followme_numbers_timeout) && !is_numeric($default_followme_numbers_timeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($default_followme_numbers_timeout)), __LINE__);
        }
        $this->default_followme_numbers_timeout = $default_followme_numbers_timeout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountFollowMeResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
