<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountAliasListResponse StructType
 * @subpackage Structs
 */
class GetAccountAliasListResponse extends AbstractStructBase
{
    /**
     * The alias_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:AliasInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AliasInfo[]
     */
    public $alias_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetAccountAliasListResponse
     * @uses GetAccountAliasListResponse::setAlias_list()
     * @uses GetAccountAliasListResponse::setTotal()
     * @param \StructType\AliasInfo[] $alias_list
     * @param int $total
     */
    public function __construct(array $alias_list = array(), $total = null)
    {
        $this
            ->setAlias_list($alias_list)
            ->setTotal($total);
    }
    /**
     * Get alias_list value
     * @return \StructType\AliasInfo[]|null
     */
    public function getAlias_list()
    {
        return $this->alias_list;
    }
    /**
     * Set alias_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AliasInfo[] $alias_list
     * @return \StructType\GetAccountAliasListResponse
     */
    public function setAlias_list(array $alias_list = array())
    {
        foreach ($alias_list as $getAccountAliasListResponseAlias_listItem) {
            // validation for constraint: itemType
            if (!$getAccountAliasListResponseAlias_listItem instanceof \StructType\AliasInfo) {
                throw new \InvalidArgumentException(sprintf('The alias_list property can only contain items of \StructType\AliasInfo, "%s" given', is_object($getAccountAliasListResponseAlias_listItem) ? get_class($getAccountAliasListResponseAlias_listItem) : gettype($getAccountAliasListResponseAlias_listItem)), __LINE__);
            }
        }
        $this->alias_list = $alias_list;
        return $this;
    }
    /**
     * Add item to alias_list value
     * @throws \InvalidArgumentException
     * @param \StructType\AliasInfo $item
     * @return \StructType\GetAccountAliasListResponse
     */
    public function addToAlias_list(\StructType\AliasInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AliasInfo) {
            throw new \InvalidArgumentException(sprintf('The alias_list property can only contain items of \StructType\AliasInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->alias_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotal()
    {
        return isset($this->total) ? $this->total : null;
    }
    /**
     * Set total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $total
     * @return \StructType\GetAccountAliasListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        if (is_null($total) || (is_array($total) && empty($total))) {
            unset($this->total);
        } else {
            $this->total = $total;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountAliasListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
