<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountPlanInfo StructType
 * @subpackage Structs
 */
class DiscountPlanInfo extends AbstractStructBase
{
    /**
     * The i_vd_plan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_vd_plan;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The managed_by
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $managed_by;
    /**
     * The i_dest_group_set
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_dest_group_set;
    /**
     * The dest_group_set_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dest_group_set_name;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The destination_lookup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination_lookup;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for DiscountPlanInfo
     * @uses DiscountPlanInfo::setI_vd_plan()
     * @uses DiscountPlanInfo::setI_customer()
     * @uses DiscountPlanInfo::setManaged_by()
     * @uses DiscountPlanInfo::setI_dest_group_set()
     * @uses DiscountPlanInfo::setDest_group_set_name()
     * @uses DiscountPlanInfo::setIso_4217()
     * @uses DiscountPlanInfo::setDestination_lookup()
     * @uses DiscountPlanInfo::setDescription()
     * @uses DiscountPlanInfo::setName()
     * @param int $i_vd_plan
     * @param int $i_customer
     * @param string $managed_by
     * @param int $i_dest_group_set
     * @param string $dest_group_set_name
     * @param string $iso_4217
     * @param string $destination_lookup
     * @param string $description
     * @param string $name
     */
    public function __construct($i_vd_plan = null, $i_customer = null, $managed_by = null, $i_dest_group_set = null, $dest_group_set_name = null, $iso_4217 = null, $destination_lookup = null, $description = null, $name = null)
    {
        $this
            ->setI_vd_plan($i_vd_plan)
            ->setI_customer($i_customer)
            ->setManaged_by($managed_by)
            ->setI_dest_group_set($i_dest_group_set)
            ->setDest_group_set_name($dest_group_set_name)
            ->setIso_4217($iso_4217)
            ->setDestination_lookup($destination_lookup)
            ->setDescription($description)
            ->setName($name);
    }
    /**
     * Get i_vd_plan value
     * @return int|null
     */
    public function getI_vd_plan()
    {
        return $this->i_vd_plan;
    }
    /**
     * Set i_vd_plan value
     * @param int $i_vd_plan
     * @return \StructType\DiscountPlanInfo
     */
    public function setI_vd_plan($i_vd_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_vd_plan) && !is_numeric($i_vd_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vd_plan)), __LINE__);
        }
        $this->i_vd_plan = $i_vd_plan;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\DiscountPlanInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get managed_by value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManaged_by()
    {
        return isset($this->managed_by) ? $this->managed_by : null;
    }
    /**
     * Set managed_by value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $managed_by
     * @return \StructType\DiscountPlanInfo
     */
    public function setManaged_by($managed_by = null)
    {
        // validation for constraint: string
        if (!is_null($managed_by) && !is_string($managed_by)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managed_by)), __LINE__);
        }
        if (is_null($managed_by) || (is_array($managed_by) && empty($managed_by))) {
            unset($this->managed_by);
        } else {
            $this->managed_by = $managed_by;
        }
        return $this;
    }
    /**
     * Get i_dest_group_set value
     * @return int|null
     */
    public function getI_dest_group_set()
    {
        return $this->i_dest_group_set;
    }
    /**
     * Set i_dest_group_set value
     * @param int $i_dest_group_set
     * @return \StructType\DiscountPlanInfo
     */
    public function setI_dest_group_set($i_dest_group_set = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest_group_set) && !is_numeric($i_dest_group_set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest_group_set)), __LINE__);
        }
        $this->i_dest_group_set = $i_dest_group_set;
        return $this;
    }
    /**
     * Get dest_group_set_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDest_group_set_name()
    {
        return isset($this->dest_group_set_name) ? $this->dest_group_set_name : null;
    }
    /**
     * Set dest_group_set_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dest_group_set_name
     * @return \StructType\DiscountPlanInfo
     */
    public function setDest_group_set_name($dest_group_set_name = null)
    {
        // validation for constraint: string
        if (!is_null($dest_group_set_name) && !is_string($dest_group_set_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dest_group_set_name)), __LINE__);
        }
        if (is_null($dest_group_set_name) || (is_array($dest_group_set_name) && empty($dest_group_set_name))) {
            unset($this->dest_group_set_name);
        } else {
            $this->dest_group_set_name = $dest_group_set_name;
        }
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\DiscountPlanInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get destination_lookup value
     * @return string|null
     */
    public function getDestination_lookup()
    {
        return $this->destination_lookup;
    }
    /**
     * Set destination_lookup value
     * @param string $destination_lookup
     * @return \StructType\DiscountPlanInfo
     */
    public function setDestination_lookup($destination_lookup = null)
    {
        // validation for constraint: string
        if (!is_null($destination_lookup) && !is_string($destination_lookup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination_lookup)), __LINE__);
        }
        $this->destination_lookup = $destination_lookup;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DiscountPlanInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\DiscountPlanInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscountPlanInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
