<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDNumberListInfo StructType
 * @subpackage Structs
 */
class DIDNumberListInfo extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $id;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The req_params
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DIDRequestParameters
     */
    public $req_params;
    /**
     * The pricing
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DIDPricing
     */
    public $pricing;
    /**
     * Constructor method for DIDNumberListInfo
     * @uses DIDNumberListInfo::setId()
     * @uses DIDNumberListInfo::setNumber()
     * @uses DIDNumberListInfo::setReq_params()
     * @uses DIDNumberListInfo::setPricing()
     * @param int $id
     * @param string $number
     * @param \StructType\DIDRequestParameters $req_params
     * @param \StructType\DIDPricing $pricing
     */
    public function __construct($id = null, $number = null, \StructType\DIDRequestParameters $req_params = null, \StructType\DIDPricing $pricing = null)
    {
        $this
            ->setId($id)
            ->setNumber($number)
            ->setReq_params($req_params)
            ->setPricing($pricing);
    }
    /**
     * Get id value
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DIDNumberListInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\DIDNumberListInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get req_params value
     * @return \StructType\DIDRequestParameters|null
     */
    public function getReq_params()
    {
        return $this->req_params;
    }
    /**
     * Set req_params value
     * @param \StructType\DIDRequestParameters $req_params
     * @return \StructType\DIDNumberListInfo
     */
    public function setReq_params(\StructType\DIDRequestParameters $req_params = null)
    {
        $this->req_params = $req_params;
        return $this;
    }
    /**
     * Get pricing value
     * @return \StructType\DIDPricing|null
     */
    public function getPricing()
    {
        return $this->pricing;
    }
    /**
     * Set pricing value
     * @param \StructType\DIDPricing $pricing
     * @return \StructType\DIDNumberListInfo
     */
    public function setPricing(\StructType\DIDPricing $pricing = null)
    {
        $this->pricing = $pricing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDNumberListInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
