<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIDCostsInfo StructType
 * @subpackage Structs
 */
class DIDCostsInfo extends AbstractStructBase
{
    /**
     * The activation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $activation;
    /**
     * The periodic
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $periodic;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * Constructor method for DIDCostsInfo
     * @uses DIDCostsInfo::setActivation()
     * @uses DIDCostsInfo::setPeriodic()
     * @uses DIDCostsInfo::setIso_4217()
     * @param float $activation
     * @param float $periodic
     * @param string $iso_4217
     */
    public function __construct($activation = null, $periodic = null, $iso_4217 = null)
    {
        $this
            ->setActivation($activation)
            ->setPeriodic($periodic)
            ->setIso_4217($iso_4217);
    }
    /**
     * Get activation value
     * @return float|null
     */
    public function getActivation()
    {
        return $this->activation;
    }
    /**
     * Set activation value
     * @param float $activation
     * @return \StructType\DIDCostsInfo
     */
    public function setActivation($activation = null)
    {
        $this->activation = $activation;
        return $this;
    }
    /**
     * Get periodic value
     * @return float|null
     */
    public function getPeriodic()
    {
        return $this->periodic;
    }
    /**
     * Set periodic value
     * @param float $periodic
     * @return \StructType\DIDCostsInfo
     */
    public function setPeriodic($periodic = null)
    {
        $this->periodic = $periodic;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\DIDCostsInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIDCostsInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
