<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInfo StructType
 * @subpackage Structs
 */
class CustomerInfo extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The refnum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $refnum;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The i_customer_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer_type;
    /**
     * The i_parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_parent;
    /**
     * The i_distributor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_distributor;
    /**
     * The override_tariffs_enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $override_tariffs_enabled;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The opening_balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $opening_balance;
    /**
     * The balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The i_billing_period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_billing_period;
    /**
     * The i_acl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_acl;
    /**
     * The i_routing_plan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_routing_plan;
    /**
     * The i_vd_plan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_vd_plan;
    /**
     * The i_moh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_moh;
    /**
     * The i_customer_class
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer_class;
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff;
    /**
     * The i_tariff_incoming
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff_incoming;
    /**
     * The i_template
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_template;
    /**
     * The i_rep
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_rep;
    /**
     * The i_time_zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_time_zone;
    /**
     * The time_zone_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $time_zone_name;
    /**
     * The i_ui_time_zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_ui_time_zone;
    /**
     * The ui_time_zone_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ui_time_zone_name;
    /**
     * The i_lang
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $i_lang;
    /**
     * The service_flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service_flags;
    /**
     * The service_features
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:ServiceFeatureInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureInfo[]
     */
    public $service_features;
    /**
     * The companyname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $companyname;
    /**
     * The salutation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salutation;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The midinit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $midinit;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The baddr1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr1;
    /**
     * The baddr2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr2;
    /**
     * The baddr3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr3;
    /**
     * The baddr4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr4;
    /**
     * The baddr5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr5;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The zip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * The faxnum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faxnum;
    /**
     * The cont1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cont1;
    /**
     * The phone1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone1;
    /**
     * The cont2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cont2;
    /**
     * The phone2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone2;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The bcc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bcc;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The tax_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tax_id;
    /**
     * The credit_limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $credit_limit;
    /**
     * The credit_limit_warning
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $credit_limit_warning;
    /**
     * The temp_credit_limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $temp_credit_limit;
    /**
     * The credit_limit_until
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $credit_limit_until;
    /**
     * The perm_credit_limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $perm_credit_limit;
    /**
     * The send_statistics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $send_statistics;
    /**
     * The blocked
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blocked;
    /**
     * The ppm_enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ppm_enabled;
    /**
     * The drm_enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $drm_enabled;
    /**
     * The callshop_enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callshop_enabled;
    /**
     * The bp_charge_cc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bp_charge_cc;
    /**
     * The bill_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bill_status;
    /**
     * The max_abbreviated_length
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $max_abbreviated_length;
    /**
     * The discount_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discount_rate;
    /**
     * The out_date_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $out_date_format;
    /**
     * The out_time_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $out_time_format;
    /**
     * The out_date_time_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $out_date_time_format;
    /**
     * The in_date_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $in_date_format;
    /**
     * The in_time_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $in_time_format;
    /**
     * The cld_translation_rule
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cld_translation_rule;
    /**
     * The cli_in_translation_rule
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cli_in_translation_rule;
    /**
     * The dialing_rules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DialingRuleOptionsInfo
     */
    public $dialing_rules;
    /**
     * The send_invoices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $send_invoices;
    /**
     * The creation_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $creation_date;
    /**
     * The payment_method_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentMethodInfo
     */
    public $payment_method_info;
    /**
     * The sale_commission_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sale_commission_rate;
    /**
     * The payment_commission_rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $payment_commission_rate;
    /**
     * The bill_suspension_delayed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bill_suspension_delayed;
    /**
     * The credit_exceed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $credit_exceed;
    /**
     * The i_do_batch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_do_batch;
    /**
     * The new_i_billing_period
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $new_i_billing_period;
    /**
     * The new_i_time_zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $new_i_time_zone;
    /**
     * The scheduled_billing_change
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $scheduled_billing_change;
    /**
     * The shifted_billing_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shifted_billing_date;
    /**
     * The has_custom_fields
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $has_custom_fields;
    /**
     * Constructor method for CustomerInfo
     * @uses CustomerInfo::setI_customer()
     * @uses CustomerInfo::setRefnum()
     * @uses CustomerInfo::setName()
     * @uses CustomerInfo::setI_customer_type()
     * @uses CustomerInfo::setI_parent()
     * @uses CustomerInfo::setI_distributor()
     * @uses CustomerInfo::setOverride_tariffs_enabled()
     * @uses CustomerInfo::setIso_4217()
     * @uses CustomerInfo::setOpening_balance()
     * @uses CustomerInfo::setBalance()
     * @uses CustomerInfo::setI_billing_period()
     * @uses CustomerInfo::setI_acl()
     * @uses CustomerInfo::setI_routing_plan()
     * @uses CustomerInfo::setI_vd_plan()
     * @uses CustomerInfo::setI_moh()
     * @uses CustomerInfo::setI_customer_class()
     * @uses CustomerInfo::setI_tariff()
     * @uses CustomerInfo::setI_tariff_incoming()
     * @uses CustomerInfo::setI_template()
     * @uses CustomerInfo::setI_rep()
     * @uses CustomerInfo::setI_time_zone()
     * @uses CustomerInfo::setTime_zone_name()
     * @uses CustomerInfo::setI_ui_time_zone()
     * @uses CustomerInfo::setUi_time_zone_name()
     * @uses CustomerInfo::setI_lang()
     * @uses CustomerInfo::setService_flags()
     * @uses CustomerInfo::setService_features()
     * @uses CustomerInfo::setCompanyname()
     * @uses CustomerInfo::setSalutation()
     * @uses CustomerInfo::setFirstname()
     * @uses CustomerInfo::setMidinit()
     * @uses CustomerInfo::setLastname()
     * @uses CustomerInfo::setBaddr1()
     * @uses CustomerInfo::setBaddr2()
     * @uses CustomerInfo::setBaddr3()
     * @uses CustomerInfo::setBaddr4()
     * @uses CustomerInfo::setBaddr5()
     * @uses CustomerInfo::setCity()
     * @uses CustomerInfo::setState()
     * @uses CustomerInfo::setZip()
     * @uses CustomerInfo::setCountry()
     * @uses CustomerInfo::setNote()
     * @uses CustomerInfo::setFaxnum()
     * @uses CustomerInfo::setCont1()
     * @uses CustomerInfo::setPhone1()
     * @uses CustomerInfo::setCont2()
     * @uses CustomerInfo::setPhone2()
     * @uses CustomerInfo::setEmail()
     * @uses CustomerInfo::setBcc()
     * @uses CustomerInfo::setLogin()
     * @uses CustomerInfo::setPassword()
     * @uses CustomerInfo::setTax_id()
     * @uses CustomerInfo::setCredit_limit()
     * @uses CustomerInfo::setCredit_limit_warning()
     * @uses CustomerInfo::setTemp_credit_limit()
     * @uses CustomerInfo::setCredit_limit_until()
     * @uses CustomerInfo::setPerm_credit_limit()
     * @uses CustomerInfo::setSend_statistics()
     * @uses CustomerInfo::setBlocked()
     * @uses CustomerInfo::setPpm_enabled()
     * @uses CustomerInfo::setDrm_enabled()
     * @uses CustomerInfo::setCallshop_enabled()
     * @uses CustomerInfo::setBp_charge_cc()
     * @uses CustomerInfo::setBill_status()
     * @uses CustomerInfo::setMax_abbreviated_length()
     * @uses CustomerInfo::setDiscount_rate()
     * @uses CustomerInfo::setOut_date_format()
     * @uses CustomerInfo::setOut_time_format()
     * @uses CustomerInfo::setOut_date_time_format()
     * @uses CustomerInfo::setIn_date_format()
     * @uses CustomerInfo::setIn_time_format()
     * @uses CustomerInfo::setCld_translation_rule()
     * @uses CustomerInfo::setCli_in_translation_rule()
     * @uses CustomerInfo::setDialing_rules()
     * @uses CustomerInfo::setSend_invoices()
     * @uses CustomerInfo::setCreation_date()
     * @uses CustomerInfo::setPayment_method_info()
     * @uses CustomerInfo::setSale_commission_rate()
     * @uses CustomerInfo::setPayment_commission_rate()
     * @uses CustomerInfo::setBill_suspension_delayed()
     * @uses CustomerInfo::setCredit_exceed()
     * @uses CustomerInfo::setI_do_batch()
     * @uses CustomerInfo::setNew_i_billing_period()
     * @uses CustomerInfo::setNew_i_time_zone()
     * @uses CustomerInfo::setScheduled_billing_change()
     * @uses CustomerInfo::setShifted_billing_date()
     * @uses CustomerInfo::setHas_custom_fields()
     * @param int $i_customer
     * @param string $refnum
     * @param string $name
     * @param int $i_customer_type
     * @param int $i_parent
     * @param int $i_distributor
     * @param string $override_tariffs_enabled
     * @param string $iso_4217
     * @param float $opening_balance
     * @param float $balance
     * @param int $i_billing_period
     * @param int $i_acl
     * @param int $i_routing_plan
     * @param int $i_vd_plan
     * @param int $i_moh
     * @param int $i_customer_class
     * @param int $i_tariff
     * @param int $i_tariff_incoming
     * @param int $i_template
     * @param int $i_rep
     * @param int $i_time_zone
     * @param string $time_zone_name
     * @param int $i_ui_time_zone
     * @param string $ui_time_zone_name
     * @param string $i_lang
     * @param string $service_flags
     * @param \StructType\ServiceFeatureInfo[] $service_features
     * @param string $companyname
     * @param string $salutation
     * @param string $firstname
     * @param string $midinit
     * @param string $lastname
     * @param string $baddr1
     * @param string $baddr2
     * @param string $baddr3
     * @param string $baddr4
     * @param string $baddr5
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param string $note
     * @param string $faxnum
     * @param string $cont1
     * @param string $phone1
     * @param string $cont2
     * @param string $phone2
     * @param string $email
     * @param string $bcc
     * @param string $login
     * @param string $password
     * @param string $tax_id
     * @param float $credit_limit
     * @param string $credit_limit_warning
     * @param int $temp_credit_limit
     * @param string $credit_limit_until
     * @param float $perm_credit_limit
     * @param string $send_statistics
     * @param string $blocked
     * @param string $ppm_enabled
     * @param string $drm_enabled
     * @param string $callshop_enabled
     * @param string $bp_charge_cc
     * @param string $bill_status
     * @param int $max_abbreviated_length
     * @param float $discount_rate
     * @param string $out_date_format
     * @param string $out_time_format
     * @param string $out_date_time_format
     * @param string $in_date_format
     * @param string $in_time_format
     * @param string $cld_translation_rule
     * @param string $cli_in_translation_rule
     * @param \StructType\DialingRuleOptionsInfo $dialing_rules
     * @param string $send_invoices
     * @param string $creation_date
     * @param \StructType\PaymentMethodInfo $payment_method_info
     * @param float $sale_commission_rate
     * @param float $payment_commission_rate
     * @param int $bill_suspension_delayed
     * @param int $credit_exceed
     * @param int $i_do_batch
     * @param int $new_i_billing_period
     * @param int $new_i_time_zone
     * @param string $scheduled_billing_change
     * @param string $shifted_billing_date
     * @param int $has_custom_fields
     */
    public function __construct($i_customer = null, $refnum = null, $name = null, $i_customer_type = null, $i_parent = null, $i_distributor = null, $override_tariffs_enabled = null, $iso_4217 = null, $opening_balance = null, $balance = null, $i_billing_period = null, $i_acl = null, $i_routing_plan = null, $i_vd_plan = null, $i_moh = null, $i_customer_class = null, $i_tariff = null, $i_tariff_incoming = null, $i_template = null, $i_rep = null, $i_time_zone = null, $time_zone_name = null, $i_ui_time_zone = null, $ui_time_zone_name = null, $i_lang = null, $service_flags = null, array $service_features = array(), $companyname = null, $salutation = null, $firstname = null, $midinit = null, $lastname = null, $baddr1 = null, $baddr2 = null, $baddr3 = null, $baddr4 = null, $baddr5 = null, $city = null, $state = null, $zip = null, $country = null, $note = null, $faxnum = null, $cont1 = null, $phone1 = null, $cont2 = null, $phone2 = null, $email = null, $bcc = null, $login = null, $password = null, $tax_id = null, $credit_limit = null, $credit_limit_warning = null, $temp_credit_limit = null, $credit_limit_until = null, $perm_credit_limit = null, $send_statistics = null, $blocked = null, $ppm_enabled = null, $drm_enabled = null, $callshop_enabled = null, $bp_charge_cc = null, $bill_status = null, $max_abbreviated_length = null, $discount_rate = null, $out_date_format = null, $out_time_format = null, $out_date_time_format = null, $in_date_format = null, $in_time_format = null, $cld_translation_rule = null, $cli_in_translation_rule = null, \StructType\DialingRuleOptionsInfo $dialing_rules = null, $send_invoices = null, $creation_date = null, \StructType\PaymentMethodInfo $payment_method_info = null, $sale_commission_rate = null, $payment_commission_rate = null, $bill_suspension_delayed = null, $credit_exceed = null, $i_do_batch = null, $new_i_billing_period = null, $new_i_time_zone = null, $scheduled_billing_change = null, $shifted_billing_date = null, $has_custom_fields = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setRefnum($refnum)
            ->setName($name)
            ->setI_customer_type($i_customer_type)
            ->setI_parent($i_parent)
            ->setI_distributor($i_distributor)
            ->setOverride_tariffs_enabled($override_tariffs_enabled)
            ->setIso_4217($iso_4217)
            ->setOpening_balance($opening_balance)
            ->setBalance($balance)
            ->setI_billing_period($i_billing_period)
            ->setI_acl($i_acl)
            ->setI_routing_plan($i_routing_plan)
            ->setI_vd_plan($i_vd_plan)
            ->setI_moh($i_moh)
            ->setI_customer_class($i_customer_class)
            ->setI_tariff($i_tariff)
            ->setI_tariff_incoming($i_tariff_incoming)
            ->setI_template($i_template)
            ->setI_rep($i_rep)
            ->setI_time_zone($i_time_zone)
            ->setTime_zone_name($time_zone_name)
            ->setI_ui_time_zone($i_ui_time_zone)
            ->setUi_time_zone_name($ui_time_zone_name)
            ->setI_lang($i_lang)
            ->setService_flags($service_flags)
            ->setService_features($service_features)
            ->setCompanyname($companyname)
            ->setSalutation($salutation)
            ->setFirstname($firstname)
            ->setMidinit($midinit)
            ->setLastname($lastname)
            ->setBaddr1($baddr1)
            ->setBaddr2($baddr2)
            ->setBaddr3($baddr3)
            ->setBaddr4($baddr4)
            ->setBaddr5($baddr5)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setNote($note)
            ->setFaxnum($faxnum)
            ->setCont1($cont1)
            ->setPhone1($phone1)
            ->setCont2($cont2)
            ->setPhone2($phone2)
            ->setEmail($email)
            ->setBcc($bcc)
            ->setLogin($login)
            ->setPassword($password)
            ->setTax_id($tax_id)
            ->setCredit_limit($credit_limit)
            ->setCredit_limit_warning($credit_limit_warning)
            ->setTemp_credit_limit($temp_credit_limit)
            ->setCredit_limit_until($credit_limit_until)
            ->setPerm_credit_limit($perm_credit_limit)
            ->setSend_statistics($send_statistics)
            ->setBlocked($blocked)
            ->setPpm_enabled($ppm_enabled)
            ->setDrm_enabled($drm_enabled)
            ->setCallshop_enabled($callshop_enabled)
            ->setBp_charge_cc($bp_charge_cc)
            ->setBill_status($bill_status)
            ->setMax_abbreviated_length($max_abbreviated_length)
            ->setDiscount_rate($discount_rate)
            ->setOut_date_format($out_date_format)
            ->setOut_time_format($out_time_format)
            ->setOut_date_time_format($out_date_time_format)
            ->setIn_date_format($in_date_format)
            ->setIn_time_format($in_time_format)
            ->setCld_translation_rule($cld_translation_rule)
            ->setCli_in_translation_rule($cli_in_translation_rule)
            ->setDialing_rules($dialing_rules)
            ->setSend_invoices($send_invoices)
            ->setCreation_date($creation_date)
            ->setPayment_method_info($payment_method_info)
            ->setSale_commission_rate($sale_commission_rate)
            ->setPayment_commission_rate($payment_commission_rate)
            ->setBill_suspension_delayed($bill_suspension_delayed)
            ->setCredit_exceed($credit_exceed)
            ->setI_do_batch($i_do_batch)
            ->setNew_i_billing_period($new_i_billing_period)
            ->setNew_i_time_zone($new_i_time_zone)
            ->setScheduled_billing_change($scheduled_billing_change)
            ->setShifted_billing_date($shifted_billing_date)
            ->setHas_custom_fields($has_custom_fields);
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CustomerInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get refnum value
     * @return string|null
     */
    public function getRefnum()
    {
        return $this->refnum;
    }
    /**
     * Set refnum value
     * @param string $refnum
     * @return \StructType\CustomerInfo
     */
    public function setRefnum($refnum = null)
    {
        // validation for constraint: string
        if (!is_null($refnum) && !is_string($refnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refnum)), __LINE__);
        }
        $this->refnum = $refnum;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomerInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_customer_type value
     * @return int|null
     */
    public function getI_customer_type()
    {
        return $this->i_customer_type;
    }
    /**
     * Set i_customer_type value
     * @param int $i_customer_type
     * @return \StructType\CustomerInfo
     */
    public function setI_customer_type($i_customer_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer_type) && !is_numeric($i_customer_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer_type)), __LINE__);
        }
        $this->i_customer_type = $i_customer_type;
        return $this;
    }
    /**
     * Get i_parent value
     * @return int|null
     */
    public function getI_parent()
    {
        return $this->i_parent;
    }
    /**
     * Set i_parent value
     * @param int $i_parent
     * @return \StructType\CustomerInfo
     */
    public function setI_parent($i_parent = null)
    {
        // validation for constraint: int
        if (!is_null($i_parent) && !is_numeric($i_parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_parent)), __LINE__);
        }
        $this->i_parent = $i_parent;
        return $this;
    }
    /**
     * Get i_distributor value
     * @return int|null
     */
    public function getI_distributor()
    {
        return $this->i_distributor;
    }
    /**
     * Set i_distributor value
     * @param int $i_distributor
     * @return \StructType\CustomerInfo
     */
    public function setI_distributor($i_distributor = null)
    {
        // validation for constraint: int
        if (!is_null($i_distributor) && !is_numeric($i_distributor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_distributor)), __LINE__);
        }
        $this->i_distributor = $i_distributor;
        return $this;
    }
    /**
     * Get override_tariffs_enabled value
     * @return string|null
     */
    public function getOverride_tariffs_enabled()
    {
        return $this->override_tariffs_enabled;
    }
    /**
     * Set override_tariffs_enabled value
     * @param string $override_tariffs_enabled
     * @return \StructType\CustomerInfo
     */
    public function setOverride_tariffs_enabled($override_tariffs_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($override_tariffs_enabled) && !is_string($override_tariffs_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($override_tariffs_enabled)), __LINE__);
        }
        $this->override_tariffs_enabled = $override_tariffs_enabled;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\CustomerInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get opening_balance value
     * @return float|null
     */
    public function getOpening_balance()
    {
        return $this->opening_balance;
    }
    /**
     * Set opening_balance value
     * @param float $opening_balance
     * @return \StructType\CustomerInfo
     */
    public function setOpening_balance($opening_balance = null)
    {
        $this->opening_balance = $opening_balance;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\CustomerInfo
     */
    public function setBalance($balance = null)
    {
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get i_billing_period value
     * @return int|null
     */
    public function getI_billing_period()
    {
        return $this->i_billing_period;
    }
    /**
     * Set i_billing_period value
     * @param int $i_billing_period
     * @return \StructType\CustomerInfo
     */
    public function setI_billing_period($i_billing_period = null)
    {
        // validation for constraint: int
        if (!is_null($i_billing_period) && !is_numeric($i_billing_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_billing_period)), __LINE__);
        }
        $this->i_billing_period = $i_billing_period;
        return $this;
    }
    /**
     * Get i_acl value
     * @return int|null
     */
    public function getI_acl()
    {
        return $this->i_acl;
    }
    /**
     * Set i_acl value
     * @param int $i_acl
     * @return \StructType\CustomerInfo
     */
    public function setI_acl($i_acl = null)
    {
        // validation for constraint: int
        if (!is_null($i_acl) && !is_numeric($i_acl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_acl)), __LINE__);
        }
        $this->i_acl = $i_acl;
        return $this;
    }
    /**
     * Get i_routing_plan value
     * @return int|null
     */
    public function getI_routing_plan()
    {
        return $this->i_routing_plan;
    }
    /**
     * Set i_routing_plan value
     * @param int $i_routing_plan
     * @return \StructType\CustomerInfo
     */
    public function setI_routing_plan($i_routing_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_routing_plan) && !is_numeric($i_routing_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_routing_plan)), __LINE__);
        }
        $this->i_routing_plan = $i_routing_plan;
        return $this;
    }
    /**
     * Get i_vd_plan value
     * @return int|null
     */
    public function getI_vd_plan()
    {
        return $this->i_vd_plan;
    }
    /**
     * Set i_vd_plan value
     * @param int $i_vd_plan
     * @return \StructType\CustomerInfo
     */
    public function setI_vd_plan($i_vd_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_vd_plan) && !is_numeric($i_vd_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vd_plan)), __LINE__);
        }
        $this->i_vd_plan = $i_vd_plan;
        return $this;
    }
    /**
     * Get i_moh value
     * @return int|null
     */
    public function getI_moh()
    {
        return $this->i_moh;
    }
    /**
     * Set i_moh value
     * @param int $i_moh
     * @return \StructType\CustomerInfo
     */
    public function setI_moh($i_moh = null)
    {
        // validation for constraint: int
        if (!is_null($i_moh) && !is_numeric($i_moh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_moh)), __LINE__);
        }
        $this->i_moh = $i_moh;
        return $this;
    }
    /**
     * Get i_customer_class value
     * @return int|null
     */
    public function getI_customer_class()
    {
        return $this->i_customer_class;
    }
    /**
     * Set i_customer_class value
     * @param int $i_customer_class
     * @return \StructType\CustomerInfo
     */
    public function setI_customer_class($i_customer_class = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer_class) && !is_numeric($i_customer_class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer_class)), __LINE__);
        }
        $this->i_customer_class = $i_customer_class;
        return $this;
    }
    /**
     * Get i_tariff value
     * @return int|null
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\CustomerInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get i_tariff_incoming value
     * @return int|null
     */
    public function getI_tariff_incoming()
    {
        return $this->i_tariff_incoming;
    }
    /**
     * Set i_tariff_incoming value
     * @param int $i_tariff_incoming
     * @return \StructType\CustomerInfo
     */
    public function setI_tariff_incoming($i_tariff_incoming = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff_incoming) && !is_numeric($i_tariff_incoming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff_incoming)), __LINE__);
        }
        $this->i_tariff_incoming = $i_tariff_incoming;
        return $this;
    }
    /**
     * Get i_template value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_template()
    {
        return isset($this->i_template) ? $this->i_template : null;
    }
    /**
     * Set i_template value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_template
     * @return \StructType\CustomerInfo
     */
    public function setI_template($i_template = null)
    {
        // validation for constraint: int
        if (!is_null($i_template) && !is_numeric($i_template)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_template)), __LINE__);
        }
        if (is_null($i_template) || (is_array($i_template) && empty($i_template))) {
            unset($this->i_template);
        } else {
            $this->i_template = $i_template;
        }
        return $this;
    }
    /**
     * Get i_rep value
     * @return int|null
     */
    public function getI_rep()
    {
        return $this->i_rep;
    }
    /**
     * Set i_rep value
     * @param int $i_rep
     * @return \StructType\CustomerInfo
     */
    public function setI_rep($i_rep = null)
    {
        // validation for constraint: int
        if (!is_null($i_rep) && !is_numeric($i_rep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_rep)), __LINE__);
        }
        $this->i_rep = $i_rep;
        return $this;
    }
    /**
     * Get i_time_zone value
     * @return int|null
     */
    public function getI_time_zone()
    {
        return $this->i_time_zone;
    }
    /**
     * Set i_time_zone value
     * @param int $i_time_zone
     * @return \StructType\CustomerInfo
     */
    public function setI_time_zone($i_time_zone = null)
    {
        // validation for constraint: int
        if (!is_null($i_time_zone) && !is_numeric($i_time_zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_time_zone)), __LINE__);
        }
        $this->i_time_zone = $i_time_zone;
        return $this;
    }
    /**
     * Get time_zone_name value
     * @return string|null
     */
    public function getTime_zone_name()
    {
        return $this->time_zone_name;
    }
    /**
     * Set time_zone_name value
     * @param string $time_zone_name
     * @return \StructType\CustomerInfo
     */
    public function setTime_zone_name($time_zone_name = null)
    {
        // validation for constraint: string
        if (!is_null($time_zone_name) && !is_string($time_zone_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_zone_name)), __LINE__);
        }
        $this->time_zone_name = $time_zone_name;
        return $this;
    }
    /**
     * Get i_ui_time_zone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_ui_time_zone()
    {
        return isset($this->i_ui_time_zone) ? $this->i_ui_time_zone : null;
    }
    /**
     * Set i_ui_time_zone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_ui_time_zone
     * @return \StructType\CustomerInfo
     */
    public function setI_ui_time_zone($i_ui_time_zone = null)
    {
        // validation for constraint: int
        if (!is_null($i_ui_time_zone) && !is_numeric($i_ui_time_zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_ui_time_zone)), __LINE__);
        }
        if (is_null($i_ui_time_zone) || (is_array($i_ui_time_zone) && empty($i_ui_time_zone))) {
            unset($this->i_ui_time_zone);
        } else {
            $this->i_ui_time_zone = $i_ui_time_zone;
        }
        return $this;
    }
    /**
     * Get ui_time_zone_name value
     * @return string|null
     */
    public function getUi_time_zone_name()
    {
        return $this->ui_time_zone_name;
    }
    /**
     * Set ui_time_zone_name value
     * @param string $ui_time_zone_name
     * @return \StructType\CustomerInfo
     */
    public function setUi_time_zone_name($ui_time_zone_name = null)
    {
        // validation for constraint: string
        if (!is_null($ui_time_zone_name) && !is_string($ui_time_zone_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ui_time_zone_name)), __LINE__);
        }
        $this->ui_time_zone_name = $ui_time_zone_name;
        return $this;
    }
    /**
     * Get i_lang value
     * @return string|null
     */
    public function getI_lang()
    {
        return $this->i_lang;
    }
    /**
     * Set i_lang value
     * @param string $i_lang
     * @return \StructType\CustomerInfo
     */
    public function setI_lang($i_lang = null)
    {
        // validation for constraint: string
        if (!is_null($i_lang) && !is_string($i_lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($i_lang)), __LINE__);
        }
        $this->i_lang = $i_lang;
        return $this;
    }
    /**
     * Get service_flags value
     * @return string|null
     */
    public function getService_flags()
    {
        return $this->service_flags;
    }
    /**
     * Set service_flags value
     * @param string $service_flags
     * @return \StructType\CustomerInfo
     */
    public function setService_flags($service_flags = null)
    {
        // validation for constraint: string
        if (!is_null($service_flags) && !is_string($service_flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service_flags)), __LINE__);
        }
        $this->service_flags = $service_flags;
        return $this;
    }
    /**
     * Get service_features value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceFeatureInfo[]|null
     */
    public function getService_features()
    {
        return isset($this->service_features) ? $this->service_features : null;
    }
    /**
     * Set service_features value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo[] $service_features
     * @return \StructType\CustomerInfo
     */
    public function setService_features(array $service_features = array())
    {
        foreach ($service_features as $customerInfoService_featuresItem) {
            // validation for constraint: itemType
            if (!$customerInfoService_featuresItem instanceof \StructType\ServiceFeatureInfo) {
                throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($customerInfoService_featuresItem) ? get_class($customerInfoService_featuresItem) : gettype($customerInfoService_featuresItem)), __LINE__);
            }
        }
        if (is_null($service_features) || (is_array($service_features) && empty($service_features))) {
            unset($this->service_features);
        } else {
            $this->service_features = $service_features;
        }
        return $this;
    }
    /**
     * Add item to service_features value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo $item
     * @return \StructType\CustomerInfo
     */
    public function addToService_features(\StructType\ServiceFeatureInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureInfo) {
            throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service_features[] = $item;
        return $this;
    }
    /**
     * Get companyname value
     * @return string|null
     */
    public function getCompanyname()
    {
        return $this->companyname;
    }
    /**
     * Set companyname value
     * @param string $companyname
     * @return \StructType\CustomerInfo
     */
    public function setCompanyname($companyname = null)
    {
        // validation for constraint: string
        if (!is_null($companyname) && !is_string($companyname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyname)), __LINE__);
        }
        $this->companyname = $companyname;
        return $this;
    }
    /**
     * Get salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\CustomerInfo
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\CustomerInfo
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get midinit value
     * @return string|null
     */
    public function getMidinit()
    {
        return $this->midinit;
    }
    /**
     * Set midinit value
     * @param string $midinit
     * @return \StructType\CustomerInfo
     */
    public function setMidinit($midinit = null)
    {
        // validation for constraint: string
        if (!is_null($midinit) && !is_string($midinit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($midinit)), __LINE__);
        }
        $this->midinit = $midinit;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \StructType\CustomerInfo
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get baddr1 value
     * @return string|null
     */
    public function getBaddr1()
    {
        return $this->baddr1;
    }
    /**
     * Set baddr1 value
     * @param string $baddr1
     * @return \StructType\CustomerInfo
     */
    public function setBaddr1($baddr1 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr1) && !is_string($baddr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr1)), __LINE__);
        }
        $this->baddr1 = $baddr1;
        return $this;
    }
    /**
     * Get baddr2 value
     * @return string|null
     */
    public function getBaddr2()
    {
        return $this->baddr2;
    }
    /**
     * Set baddr2 value
     * @param string $baddr2
     * @return \StructType\CustomerInfo
     */
    public function setBaddr2($baddr2 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr2) && !is_string($baddr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr2)), __LINE__);
        }
        $this->baddr2 = $baddr2;
        return $this;
    }
    /**
     * Get baddr3 value
     * @return string|null
     */
    public function getBaddr3()
    {
        return $this->baddr3;
    }
    /**
     * Set baddr3 value
     * @param string $baddr3
     * @return \StructType\CustomerInfo
     */
    public function setBaddr3($baddr3 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr3) && !is_string($baddr3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr3)), __LINE__);
        }
        $this->baddr3 = $baddr3;
        return $this;
    }
    /**
     * Get baddr4 value
     * @return string|null
     */
    public function getBaddr4()
    {
        return $this->baddr4;
    }
    /**
     * Set baddr4 value
     * @param string $baddr4
     * @return \StructType\CustomerInfo
     */
    public function setBaddr4($baddr4 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr4) && !is_string($baddr4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr4)), __LINE__);
        }
        $this->baddr4 = $baddr4;
        return $this;
    }
    /**
     * Get baddr5 value
     * @return string|null
     */
    public function getBaddr5()
    {
        return $this->baddr5;
    }
    /**
     * Set baddr5 value
     * @param string $baddr5
     * @return \StructType\CustomerInfo
     */
    public function setBaddr5($baddr5 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr5) && !is_string($baddr5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr5)), __LINE__);
        }
        $this->baddr5 = $baddr5;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\CustomerInfo
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\CustomerInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\CustomerInfo
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\CustomerInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\CustomerInfo
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get faxnum value
     * @return string|null
     */
    public function getFaxnum()
    {
        return $this->faxnum;
    }
    /**
     * Set faxnum value
     * @param string $faxnum
     * @return \StructType\CustomerInfo
     */
    public function setFaxnum($faxnum = null)
    {
        // validation for constraint: string
        if (!is_null($faxnum) && !is_string($faxnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxnum)), __LINE__);
        }
        $this->faxnum = $faxnum;
        return $this;
    }
    /**
     * Get cont1 value
     * @return string|null
     */
    public function getCont1()
    {
        return $this->cont1;
    }
    /**
     * Set cont1 value
     * @param string $cont1
     * @return \StructType\CustomerInfo
     */
    public function setCont1($cont1 = null)
    {
        // validation for constraint: string
        if (!is_null($cont1) && !is_string($cont1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cont1)), __LINE__);
        }
        $this->cont1 = $cont1;
        return $this;
    }
    /**
     * Get phone1 value
     * @return string|null
     */
    public function getPhone1()
    {
        return $this->phone1;
    }
    /**
     * Set phone1 value
     * @param string $phone1
     * @return \StructType\CustomerInfo
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone1)), __LINE__);
        }
        $this->phone1 = $phone1;
        return $this;
    }
    /**
     * Get cont2 value
     * @return string|null
     */
    public function getCont2()
    {
        return $this->cont2;
    }
    /**
     * Set cont2 value
     * @param string $cont2
     * @return \StructType\CustomerInfo
     */
    public function setCont2($cont2 = null)
    {
        // validation for constraint: string
        if (!is_null($cont2) && !is_string($cont2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cont2)), __LINE__);
        }
        $this->cont2 = $cont2;
        return $this;
    }
    /**
     * Get phone2 value
     * @return string|null
     */
    public function getPhone2()
    {
        return $this->phone2;
    }
    /**
     * Set phone2 value
     * @param string $phone2
     * @return \StructType\CustomerInfo
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone2)), __LINE__);
        }
        $this->phone2 = $phone2;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CustomerInfo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get bcc value
     * @return string|null
     */
    public function getBcc()
    {
        return $this->bcc;
    }
    /**
     * Set bcc value
     * @param string $bcc
     * @return \StructType\CustomerInfo
     */
    public function setBcc($bcc = null)
    {
        // validation for constraint: string
        if (!is_null($bcc) && !is_string($bcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bcc)), __LINE__);
        }
        $this->bcc = $bcc;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\CustomerInfo
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\CustomerInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get tax_id value
     * @return string|null
     */
    public function getTax_id()
    {
        return $this->tax_id;
    }
    /**
     * Set tax_id value
     * @param string $tax_id
     * @return \StructType\CustomerInfo
     */
    public function setTax_id($tax_id = null)
    {
        // validation for constraint: string
        if (!is_null($tax_id) && !is_string($tax_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tax_id)), __LINE__);
        }
        $this->tax_id = $tax_id;
        return $this;
    }
    /**
     * Get credit_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCredit_limit()
    {
        return isset($this->credit_limit) ? $this->credit_limit : null;
    }
    /**
     * Set credit_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $credit_limit
     * @return \StructType\CustomerInfo
     */
    public function setCredit_limit($credit_limit = null)
    {
        if (is_null($credit_limit) || (is_array($credit_limit) && empty($credit_limit))) {
            unset($this->credit_limit);
        } else {
            $this->credit_limit = $credit_limit;
        }
        return $this;
    }
    /**
     * Get credit_limit_warning value
     * @return string|null
     */
    public function getCredit_limit_warning()
    {
        return $this->credit_limit_warning;
    }
    /**
     * Set credit_limit_warning value
     * @param string $credit_limit_warning
     * @return \StructType\CustomerInfo
     */
    public function setCredit_limit_warning($credit_limit_warning = null)
    {
        // validation for constraint: string
        if (!is_null($credit_limit_warning) && !is_string($credit_limit_warning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credit_limit_warning)), __LINE__);
        }
        $this->credit_limit_warning = $credit_limit_warning;
        return $this;
    }
    /**
     * Get temp_credit_limit value
     * @return int|null
     */
    public function getTemp_credit_limit()
    {
        return $this->temp_credit_limit;
    }
    /**
     * Set temp_credit_limit value
     * @param int $temp_credit_limit
     * @return \StructType\CustomerInfo
     */
    public function setTemp_credit_limit($temp_credit_limit = null)
    {
        // validation for constraint: int
        if (!is_null($temp_credit_limit) && !is_numeric($temp_credit_limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($temp_credit_limit)), __LINE__);
        }
        $this->temp_credit_limit = $temp_credit_limit;
        return $this;
    }
    /**
     * Get credit_limit_until value
     * @return string|null
     */
    public function getCredit_limit_until()
    {
        return $this->credit_limit_until;
    }
    /**
     * Set credit_limit_until value
     * @param string $credit_limit_until
     * @return \StructType\CustomerInfo
     */
    public function setCredit_limit_until($credit_limit_until = null)
    {
        // validation for constraint: string
        if (!is_null($credit_limit_until) && !is_string($credit_limit_until)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credit_limit_until)), __LINE__);
        }
        $this->credit_limit_until = $credit_limit_until;
        return $this;
    }
    /**
     * Get perm_credit_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPerm_credit_limit()
    {
        return isset($this->perm_credit_limit) ? $this->perm_credit_limit : null;
    }
    /**
     * Set perm_credit_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $perm_credit_limit
     * @return \StructType\CustomerInfo
     */
    public function setPerm_credit_limit($perm_credit_limit = null)
    {
        if (is_null($perm_credit_limit) || (is_array($perm_credit_limit) && empty($perm_credit_limit))) {
            unset($this->perm_credit_limit);
        } else {
            $this->perm_credit_limit = $perm_credit_limit;
        }
        return $this;
    }
    /**
     * Get send_statistics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSend_statistics()
    {
        return isset($this->send_statistics) ? $this->send_statistics : null;
    }
    /**
     * Set send_statistics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $send_statistics
     * @return \StructType\CustomerInfo
     */
    public function setSend_statistics($send_statistics = null)
    {
        // validation for constraint: string
        if (!is_null($send_statistics) && !is_string($send_statistics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($send_statistics)), __LINE__);
        }
        if (is_null($send_statistics) || (is_array($send_statistics) && empty($send_statistics))) {
            unset($this->send_statistics);
        } else {
            $this->send_statistics = $send_statistics;
        }
        return $this;
    }
    /**
     * Get blocked value
     * @return string|null
     */
    public function getBlocked()
    {
        return $this->blocked;
    }
    /**
     * Set blocked value
     * @param string $blocked
     * @return \StructType\CustomerInfo
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: string
        if (!is_null($blocked) && !is_string($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blocked)), __LINE__);
        }
        $this->blocked = $blocked;
        return $this;
    }
    /**
     * Get ppm_enabled value
     * @return string|null
     */
    public function getPpm_enabled()
    {
        return $this->ppm_enabled;
    }
    /**
     * Set ppm_enabled value
     * @param string $ppm_enabled
     * @return \StructType\CustomerInfo
     */
    public function setPpm_enabled($ppm_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($ppm_enabled) && !is_string($ppm_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ppm_enabled)), __LINE__);
        }
        $this->ppm_enabled = $ppm_enabled;
        return $this;
    }
    /**
     * Get drm_enabled value
     * @return string|null
     */
    public function getDrm_enabled()
    {
        return $this->drm_enabled;
    }
    /**
     * Set drm_enabled value
     * @param string $drm_enabled
     * @return \StructType\CustomerInfo
     */
    public function setDrm_enabled($drm_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($drm_enabled) && !is_string($drm_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($drm_enabled)), __LINE__);
        }
        $this->drm_enabled = $drm_enabled;
        return $this;
    }
    /**
     * Get callshop_enabled value
     * @return string|null
     */
    public function getCallshop_enabled()
    {
        return $this->callshop_enabled;
    }
    /**
     * Set callshop_enabled value
     * @param string $callshop_enabled
     * @return \StructType\CustomerInfo
     */
    public function setCallshop_enabled($callshop_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($callshop_enabled) && !is_string($callshop_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callshop_enabled)), __LINE__);
        }
        $this->callshop_enabled = $callshop_enabled;
        return $this;
    }
    /**
     * Get bp_charge_cc value
     * @return string|null
     */
    public function getBp_charge_cc()
    {
        return $this->bp_charge_cc;
    }
    /**
     * Set bp_charge_cc value
     * @param string $bp_charge_cc
     * @return \StructType\CustomerInfo
     */
    public function setBp_charge_cc($bp_charge_cc = null)
    {
        // validation for constraint: string
        if (!is_null($bp_charge_cc) && !is_string($bp_charge_cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bp_charge_cc)), __LINE__);
        }
        $this->bp_charge_cc = $bp_charge_cc;
        return $this;
    }
    /**
     * Get bill_status value
     * @return string|null
     */
    public function getBill_status()
    {
        return $this->bill_status;
    }
    /**
     * Set bill_status value
     * @param string $bill_status
     * @return \StructType\CustomerInfo
     */
    public function setBill_status($bill_status = null)
    {
        // validation for constraint: string
        if (!is_null($bill_status) && !is_string($bill_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bill_status)), __LINE__);
        }
        $this->bill_status = $bill_status;
        return $this;
    }
    /**
     * Get max_abbreviated_length value
     * @return int|null
     */
    public function getMax_abbreviated_length()
    {
        return $this->max_abbreviated_length;
    }
    /**
     * Set max_abbreviated_length value
     * @param int $max_abbreviated_length
     * @return \StructType\CustomerInfo
     */
    public function setMax_abbreviated_length($max_abbreviated_length = null)
    {
        // validation for constraint: int
        if (!is_null($max_abbreviated_length) && !is_numeric($max_abbreviated_length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($max_abbreviated_length)), __LINE__);
        }
        $this->max_abbreviated_length = $max_abbreviated_length;
        return $this;
    }
    /**
     * Get discount_rate value
     * @return float|null
     */
    public function getDiscount_rate()
    {
        return $this->discount_rate;
    }
    /**
     * Set discount_rate value
     * @param float $discount_rate
     * @return \StructType\CustomerInfo
     */
    public function setDiscount_rate($discount_rate = null)
    {
        $this->discount_rate = $discount_rate;
        return $this;
    }
    /**
     * Get out_date_format value
     * @return string|null
     */
    public function getOut_date_format()
    {
        return $this->out_date_format;
    }
    /**
     * Set out_date_format value
     * @param string $out_date_format
     * @return \StructType\CustomerInfo
     */
    public function setOut_date_format($out_date_format = null)
    {
        // validation for constraint: string
        if (!is_null($out_date_format) && !is_string($out_date_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_date_format)), __LINE__);
        }
        $this->out_date_format = $out_date_format;
        return $this;
    }
    /**
     * Get out_time_format value
     * @return string|null
     */
    public function getOut_time_format()
    {
        return $this->out_time_format;
    }
    /**
     * Set out_time_format value
     * @param string $out_time_format
     * @return \StructType\CustomerInfo
     */
    public function setOut_time_format($out_time_format = null)
    {
        // validation for constraint: string
        if (!is_null($out_time_format) && !is_string($out_time_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_time_format)), __LINE__);
        }
        $this->out_time_format = $out_time_format;
        return $this;
    }
    /**
     * Get out_date_time_format value
     * @return string|null
     */
    public function getOut_date_time_format()
    {
        return $this->out_date_time_format;
    }
    /**
     * Set out_date_time_format value
     * @param string $out_date_time_format
     * @return \StructType\CustomerInfo
     */
    public function setOut_date_time_format($out_date_time_format = null)
    {
        // validation for constraint: string
        if (!is_null($out_date_time_format) && !is_string($out_date_time_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_date_time_format)), __LINE__);
        }
        $this->out_date_time_format = $out_date_time_format;
        return $this;
    }
    /**
     * Get in_date_format value
     * @return string|null
     */
    public function getIn_date_format()
    {
        return $this->in_date_format;
    }
    /**
     * Set in_date_format value
     * @param string $in_date_format
     * @return \StructType\CustomerInfo
     */
    public function setIn_date_format($in_date_format = null)
    {
        // validation for constraint: string
        if (!is_null($in_date_format) && !is_string($in_date_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($in_date_format)), __LINE__);
        }
        $this->in_date_format = $in_date_format;
        return $this;
    }
    /**
     * Get in_time_format value
     * @return string|null
     */
    public function getIn_time_format()
    {
        return $this->in_time_format;
    }
    /**
     * Set in_time_format value
     * @param string $in_time_format
     * @return \StructType\CustomerInfo
     */
    public function setIn_time_format($in_time_format = null)
    {
        // validation for constraint: string
        if (!is_null($in_time_format) && !is_string($in_time_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($in_time_format)), __LINE__);
        }
        $this->in_time_format = $in_time_format;
        return $this;
    }
    /**
     * Get cld_translation_rule value
     * @return string|null
     */
    public function getCld_translation_rule()
    {
        return $this->cld_translation_rule;
    }
    /**
     * Set cld_translation_rule value
     * @param string $cld_translation_rule
     * @return \StructType\CustomerInfo
     */
    public function setCld_translation_rule($cld_translation_rule = null)
    {
        // validation for constraint: string
        if (!is_null($cld_translation_rule) && !is_string($cld_translation_rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cld_translation_rule)), __LINE__);
        }
        $this->cld_translation_rule = $cld_translation_rule;
        return $this;
    }
    /**
     * Get cli_in_translation_rule value
     * @return string|null
     */
    public function getCli_in_translation_rule()
    {
        return $this->cli_in_translation_rule;
    }
    /**
     * Set cli_in_translation_rule value
     * @param string $cli_in_translation_rule
     * @return \StructType\CustomerInfo
     */
    public function setCli_in_translation_rule($cli_in_translation_rule = null)
    {
        // validation for constraint: string
        if (!is_null($cli_in_translation_rule) && !is_string($cli_in_translation_rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cli_in_translation_rule)), __LINE__);
        }
        $this->cli_in_translation_rule = $cli_in_translation_rule;
        return $this;
    }
    /**
     * Get dialing_rules value
     * @return \StructType\DialingRuleOptionsInfo|null
     */
    public function getDialing_rules()
    {
        return $this->dialing_rules;
    }
    /**
     * Set dialing_rules value
     * @param \StructType\DialingRuleOptionsInfo $dialing_rules
     * @return \StructType\CustomerInfo
     */
    public function setDialing_rules(\StructType\DialingRuleOptionsInfo $dialing_rules = null)
    {
        $this->dialing_rules = $dialing_rules;
        return $this;
    }
    /**
     * Get send_invoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSend_invoices()
    {
        return isset($this->send_invoices) ? $this->send_invoices : null;
    }
    /**
     * Set send_invoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $send_invoices
     * @return \StructType\CustomerInfo
     */
    public function setSend_invoices($send_invoices = null)
    {
        // validation for constraint: string
        if (!is_null($send_invoices) && !is_string($send_invoices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($send_invoices)), __LINE__);
        }
        if (is_null($send_invoices) || (is_array($send_invoices) && empty($send_invoices))) {
            unset($this->send_invoices);
        } else {
            $this->send_invoices = $send_invoices;
        }
        return $this;
    }
    /**
     * Get creation_date value
     * @return string|null
     */
    public function getCreation_date()
    {
        return $this->creation_date;
    }
    /**
     * Set creation_date value
     * @param string $creation_date
     * @return \StructType\CustomerInfo
     */
    public function setCreation_date($creation_date = null)
    {
        // validation for constraint: string
        if (!is_null($creation_date) && !is_string($creation_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creation_date)), __LINE__);
        }
        $this->creation_date = $creation_date;
        return $this;
    }
    /**
     * Get payment_method_info value
     * @return \StructType\PaymentMethodInfo|null
     */
    public function getPayment_method_info()
    {
        return $this->payment_method_info;
    }
    /**
     * Set payment_method_info value
     * @param \StructType\PaymentMethodInfo $payment_method_info
     * @return \StructType\CustomerInfo
     */
    public function setPayment_method_info(\StructType\PaymentMethodInfo $payment_method_info = null)
    {
        $this->payment_method_info = $payment_method_info;
        return $this;
    }
    /**
     * Get sale_commission_rate value
     * @return float|null
     */
    public function getSale_commission_rate()
    {
        return $this->sale_commission_rate;
    }
    /**
     * Set sale_commission_rate value
     * @param float $sale_commission_rate
     * @return \StructType\CustomerInfo
     */
    public function setSale_commission_rate($sale_commission_rate = null)
    {
        $this->sale_commission_rate = $sale_commission_rate;
        return $this;
    }
    /**
     * Get payment_commission_rate value
     * @return float|null
     */
    public function getPayment_commission_rate()
    {
        return $this->payment_commission_rate;
    }
    /**
     * Set payment_commission_rate value
     * @param float $payment_commission_rate
     * @return \StructType\CustomerInfo
     */
    public function setPayment_commission_rate($payment_commission_rate = null)
    {
        $this->payment_commission_rate = $payment_commission_rate;
        return $this;
    }
    /**
     * Get bill_suspension_delayed value
     * @return int|null
     */
    public function getBill_suspension_delayed()
    {
        return $this->bill_suspension_delayed;
    }
    /**
     * Set bill_suspension_delayed value
     * @param int $bill_suspension_delayed
     * @return \StructType\CustomerInfo
     */
    public function setBill_suspension_delayed($bill_suspension_delayed = null)
    {
        // validation for constraint: int
        if (!is_null($bill_suspension_delayed) && !is_numeric($bill_suspension_delayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bill_suspension_delayed)), __LINE__);
        }
        $this->bill_suspension_delayed = $bill_suspension_delayed;
        return $this;
    }
    /**
     * Get credit_exceed value
     * @return int|null
     */
    public function getCredit_exceed()
    {
        return $this->credit_exceed;
    }
    /**
     * Set credit_exceed value
     * @param int $credit_exceed
     * @return \StructType\CustomerInfo
     */
    public function setCredit_exceed($credit_exceed = null)
    {
        // validation for constraint: int
        if (!is_null($credit_exceed) && !is_numeric($credit_exceed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($credit_exceed)), __LINE__);
        }
        $this->credit_exceed = $credit_exceed;
        return $this;
    }
    /**
     * Get i_do_batch value
     * @return int|null
     */
    public function getI_do_batch()
    {
        return $this->i_do_batch;
    }
    /**
     * Set i_do_batch value
     * @param int $i_do_batch
     * @return \StructType\CustomerInfo
     */
    public function setI_do_batch($i_do_batch = null)
    {
        // validation for constraint: int
        if (!is_null($i_do_batch) && !is_numeric($i_do_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_do_batch)), __LINE__);
        }
        $this->i_do_batch = $i_do_batch;
        return $this;
    }
    /**
     * Get new_i_billing_period value
     * @return int|null
     */
    public function getNew_i_billing_period()
    {
        return $this->new_i_billing_period;
    }
    /**
     * Set new_i_billing_period value
     * @param int $new_i_billing_period
     * @return \StructType\CustomerInfo
     */
    public function setNew_i_billing_period($new_i_billing_period = null)
    {
        // validation for constraint: int
        if (!is_null($new_i_billing_period) && !is_numeric($new_i_billing_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($new_i_billing_period)), __LINE__);
        }
        $this->new_i_billing_period = $new_i_billing_period;
        return $this;
    }
    /**
     * Get new_i_time_zone value
     * @return int|null
     */
    public function getNew_i_time_zone()
    {
        return $this->new_i_time_zone;
    }
    /**
     * Set new_i_time_zone value
     * @param int $new_i_time_zone
     * @return \StructType\CustomerInfo
     */
    public function setNew_i_time_zone($new_i_time_zone = null)
    {
        // validation for constraint: int
        if (!is_null($new_i_time_zone) && !is_numeric($new_i_time_zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($new_i_time_zone)), __LINE__);
        }
        $this->new_i_time_zone = $new_i_time_zone;
        return $this;
    }
    /**
     * Get scheduled_billing_change value
     * @return string|null
     */
    public function getScheduled_billing_change()
    {
        return $this->scheduled_billing_change;
    }
    /**
     * Set scheduled_billing_change value
     * @param string $scheduled_billing_change
     * @return \StructType\CustomerInfo
     */
    public function setScheduled_billing_change($scheduled_billing_change = null)
    {
        // validation for constraint: string
        if (!is_null($scheduled_billing_change) && !is_string($scheduled_billing_change)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduled_billing_change)), __LINE__);
        }
        $this->scheduled_billing_change = $scheduled_billing_change;
        return $this;
    }
    /**
     * Get shifted_billing_date value
     * @return string|null
     */
    public function getShifted_billing_date()
    {
        return $this->shifted_billing_date;
    }
    /**
     * Set shifted_billing_date value
     * @param string $shifted_billing_date
     * @return \StructType\CustomerInfo
     */
    public function setShifted_billing_date($shifted_billing_date = null)
    {
        // validation for constraint: string
        if (!is_null($shifted_billing_date) && !is_string($shifted_billing_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shifted_billing_date)), __LINE__);
        }
        $this->shifted_billing_date = $shifted_billing_date;
        return $this;
    }
    /**
     * Get has_custom_fields value
     * @return int|null
     */
    public function getHas_custom_fields()
    {
        return $this->has_custom_fields;
    }
    /**
     * Set has_custom_fields value
     * @param int $has_custom_fields
     * @return \StructType\CustomerInfo
     */
    public function setHas_custom_fields($has_custom_fields = null)
    {
        // validation for constraint: int
        if (!is_null($has_custom_fields) && !is_numeric($has_custom_fields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($has_custom_fields)), __LINE__);
        }
        $this->has_custom_fields = $has_custom_fields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
