<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelDIDProvisionRequest StructType
 * @subpackage Structs
 */
class CancelDIDProvisionRequest extends AbstractStructBase
{
    /**
     * The i_did_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_did_number;
    /**
     * The did_provider_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerDIDProviderIdent
     */
    public $did_provider_info;
    /**
     * Constructor method for CancelDIDProvisionRequest
     * @uses CancelDIDProvisionRequest::setI_did_number()
     * @uses CancelDIDProvisionRequest::setDid_provider_info()
     * @param int $i_did_number
     * @param \StructType\CustomerDIDProviderIdent $did_provider_info
     */
    public function __construct($i_did_number = null, \StructType\CustomerDIDProviderIdent $did_provider_info = null)
    {
        $this
            ->setI_did_number($i_did_number)
            ->setDid_provider_info($did_provider_info);
    }
    /**
     * Get i_did_number value
     * @return int
     */
    public function getI_did_number()
    {
        return $this->i_did_number;
    }
    /**
     * Set i_did_number value
     * @param int $i_did_number
     * @return \StructType\CancelDIDProvisionRequest
     */
    public function setI_did_number($i_did_number = null)
    {
        // validation for constraint: int
        if (!is_null($i_did_number) && !is_numeric($i_did_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_did_number)), __LINE__);
        }
        $this->i_did_number = $i_did_number;
        return $this;
    }
    /**
     * Get did_provider_info value
     * @return \StructType\CustomerDIDProviderIdent|null
     */
    public function getDid_provider_info()
    {
        return $this->did_provider_info;
    }
    /**
     * Set did_provider_info value
     * @param \StructType\CustomerDIDProviderIdent $did_provider_info
     * @return \StructType\CancelDIDProvisionRequest
     */
    public function setDid_provider_info(\StructType\CustomerDIDProviderIdent $did_provider_info = null)
    {
        $this->did_provider_info = $did_provider_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelDIDProvisionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
