<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddonsValidationResults StructType
 * @subpackage Structs
 */
class AddonsValidationResults extends AbstractStructBase
{
    /**
     * The disallowed_products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:DisallowedProducts[]
     * - ref: soapenc:arrayType
     * @var \StructType\DisallowedProducts[]
     */
    public $disallowed_products;
    /**
     * The service_features_conflicts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:ServiceFeaturesConflicts[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeaturesConflicts[]
     */
    public $service_features_conflicts;
    /**
     * Constructor method for AddonsValidationResults
     * @uses AddonsValidationResults::setDisallowed_products()
     * @uses AddonsValidationResults::setService_features_conflicts()
     * @param \StructType\DisallowedProducts[] $disallowed_products
     * @param \StructType\ServiceFeaturesConflicts[] $service_features_conflicts
     */
    public function __construct(array $disallowed_products = array(), array $service_features_conflicts = array())
    {
        $this
            ->setDisallowed_products($disallowed_products)
            ->setService_features_conflicts($service_features_conflicts);
    }
    /**
     * Get disallowed_products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DisallowedProducts[]|null
     */
    public function getDisallowed_products()
    {
        return isset($this->disallowed_products) ? $this->disallowed_products : null;
    }
    /**
     * Set disallowed_products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DisallowedProducts[] $disallowed_products
     * @return \StructType\AddonsValidationResults
     */
    public function setDisallowed_products(array $disallowed_products = array())
    {
        foreach ($disallowed_products as $addonsValidationResultsDisallowed_productsItem) {
            // validation for constraint: itemType
            if (!$addonsValidationResultsDisallowed_productsItem instanceof \StructType\DisallowedProducts) {
                throw new \InvalidArgumentException(sprintf('The disallowed_products property can only contain items of \StructType\DisallowedProducts, "%s" given', is_object($addonsValidationResultsDisallowed_productsItem) ? get_class($addonsValidationResultsDisallowed_productsItem) : gettype($addonsValidationResultsDisallowed_productsItem)), __LINE__);
            }
        }
        if (is_null($disallowed_products) || (is_array($disallowed_products) && empty($disallowed_products))) {
            unset($this->disallowed_products);
        } else {
            $this->disallowed_products = $disallowed_products;
        }
        return $this;
    }
    /**
     * Add item to disallowed_products value
     * @throws \InvalidArgumentException
     * @param \StructType\DisallowedProducts $item
     * @return \StructType\AddonsValidationResults
     */
    public function addToDisallowed_products(\StructType\DisallowedProducts $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DisallowedProducts) {
            throw new \InvalidArgumentException(sprintf('The disallowed_products property can only contain items of \StructType\DisallowedProducts, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->disallowed_products[] = $item;
        return $this;
    }
    /**
     * Get service_features_conflicts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceFeaturesConflicts[]|null
     */
    public function getService_features_conflicts()
    {
        return isset($this->service_features_conflicts) ? $this->service_features_conflicts : null;
    }
    /**
     * Set service_features_conflicts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeaturesConflicts[] $service_features_conflicts
     * @return \StructType\AddonsValidationResults
     */
    public function setService_features_conflicts(array $service_features_conflicts = array())
    {
        foreach ($service_features_conflicts as $addonsValidationResultsService_features_conflictsItem) {
            // validation for constraint: itemType
            if (!$addonsValidationResultsService_features_conflictsItem instanceof \StructType\ServiceFeaturesConflicts) {
                throw new \InvalidArgumentException(sprintf('The service_features_conflicts property can only contain items of \StructType\ServiceFeaturesConflicts, "%s" given', is_object($addonsValidationResultsService_features_conflictsItem) ? get_class($addonsValidationResultsService_features_conflictsItem) : gettype($addonsValidationResultsService_features_conflictsItem)), __LINE__);
            }
        }
        if (is_null($service_features_conflicts) || (is_array($service_features_conflicts) && empty($service_features_conflicts))) {
            unset($this->service_features_conflicts);
        } else {
            $this->service_features_conflicts = $service_features_conflicts;
        }
        return $this;
    }
    /**
     * Add item to service_features_conflicts value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeaturesConflicts $item
     * @return \StructType\AddonsValidationResults
     */
    public function addToService_features_conflicts(\StructType\ServiceFeaturesConflicts $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeaturesConflicts) {
            throw new \InvalidArgumentException(sprintf('The service_features_conflicts property can only contain items of \StructType\ServiceFeaturesConflicts, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service_features_conflicts[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddonsValidationResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
