<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDestGroupRequest StructType
 * @subpackage Structs
 */
class AddDestGroupRequest extends AbstractStructBase
{
    /**
     * The i_dest_group_set
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_dest_group_set;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The add_destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $add_destinations;
    /**
     * Constructor method for AddDestGroupRequest
     * @uses AddDestGroupRequest::setI_dest_group_set()
     * @uses AddDestGroupRequest::setName()
     * @uses AddDestGroupRequest::setAdd_destinations()
     * @param int $i_dest_group_set
     * @param string $name
     * @param int[] $add_destinations
     */
    public function __construct($i_dest_group_set = null, $name = null, array $add_destinations = array())
    {
        $this
            ->setI_dest_group_set($i_dest_group_set)
            ->setName($name)
            ->setAdd_destinations($add_destinations);
    }
    /**
     * Get i_dest_group_set value
     * @return int
     */
    public function getI_dest_group_set()
    {
        return $this->i_dest_group_set;
    }
    /**
     * Set i_dest_group_set value
     * @param int $i_dest_group_set
     * @return \StructType\AddDestGroupRequest
     */
    public function setI_dest_group_set($i_dest_group_set = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest_group_set) && !is_numeric($i_dest_group_set)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest_group_set)), __LINE__);
        }
        $this->i_dest_group_set = $i_dest_group_set;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AddDestGroupRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get add_destinations value
     * @return int[]|null
     */
    public function getAdd_destinations()
    {
        return $this->add_destinations;
    }
    /**
     * Set add_destinations value
     * @throws \InvalidArgumentException
     * @param int[] $add_destinations
     * @return \StructType\AddDestGroupRequest
     */
    public function setAdd_destinations(array $add_destinations = array())
    {
        foreach ($add_destinations as $addDestGroupRequestAdd_destinationsItem) {
            // validation for constraint: itemType
            if (!is_numeric($addDestGroupRequestAdd_destinationsItem)) {
                throw new \InvalidArgumentException(sprintf('The add_destinations property can only contain items of int, "%s" given', is_object($addDestGroupRequestAdd_destinationsItem) ? get_class($addDestGroupRequestAdd_destinationsItem) : gettype($addDestGroupRequestAdd_destinationsItem)), __LINE__);
            }
        }
        $this->add_destinations = $add_destinations;
        return $this;
    }
    /**
     * Add item to add_destinations value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\AddDestGroupRequest
     */
    public function addToAdd_destinations($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The add_destinations property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->add_destinations[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddDestGroupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
