<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAccountSubscriptionRequest StructType
 * @subpackage Structs
 */
class AddAccountSubscriptionRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The subscription_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountSubscriptionInfo
     */
    public $subscription_info;
    /**
     * Constructor method for AddAccountSubscriptionRequest
     * @uses AddAccountSubscriptionRequest::setI_account()
     * @uses AddAccountSubscriptionRequest::setSubscription_info()
     * @param int $i_account
     * @param \StructType\AccountSubscriptionInfo $subscription_info
     */
    public function __construct($i_account = null, \StructType\AccountSubscriptionInfo $subscription_info = null)
    {
        $this
            ->setI_account($i_account)
            ->setSubscription_info($subscription_info);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\AddAccountSubscriptionRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get subscription_info value
     * @return \StructType\AccountSubscriptionInfo
     */
    public function getSubscription_info()
    {
        return $this->subscription_info;
    }
    /**
     * Set subscription_info value
     * @param \StructType\AccountSubscriptionInfo $subscription_info
     * @return \StructType\AddAccountSubscriptionRequest
     */
    public function setSubscription_info(\StructType\AccountSubscriptionInfo $subscription_info = null)
    {
        $this->subscription_info = $subscription_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddAccountSubscriptionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
