<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAccountAliasResponse StructType
 * @subpackage Structs
 */
class AddAccountAliasResponse extends AbstractStructBase
{
    /**
     * The success
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $success;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_account;
    /**
     * Constructor method for AddAccountAliasResponse
     * @uses AddAccountAliasResponse::setSuccess()
     * @uses AddAccountAliasResponse::setI_account()
     * @param int $success
     * @param int $i_account
     */
    public function __construct($success = null, $i_account = null)
    {
        $this
            ->setSuccess($success)
            ->setI_account($i_account);
    }
    /**
     * Get success value
     * @return int
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param int $success
     * @return \StructType\AddAccountAliasResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: int
        if (!is_null($success) && !is_numeric($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($success)), __LINE__);
        }
        $this->success = $success;
        return $this;
    }
    /**
     * Get i_account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_account()
    {
        return isset($this->i_account) ? $this->i_account : null;
    }
    /**
     * Set i_account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_account
     * @return \StructType\AddAccountAliasResponse
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        if (is_null($i_account) || (is_array($i_account) && empty($i_account))) {
            unset($this->i_account);
        } else {
            $this->i_account = $i_account;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddAccountAliasResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
