<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountInfo StructType
 * @subpackage Structs
 */
class AccountInfo extends AbstractStructBase
{
    /**
     * The assigned_addons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:ProductInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ProductInfo[]
     */
    public $assigned_addons;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The billing_model
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $billing_model;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The i_distributor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_distributor;
    /**
     * The i_batch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_batch;
    /**
     * The batch_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $batch_name;
    /**
     * The control_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $control_number;
    /**
     * The iso_4217
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_4217;
    /**
     * The opening_balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $opening_balance;
    /**
     * The balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance;
    /**
     * The issue_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issue_date;
    /**
     * The activation_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activation_date;
    /**
     * The expiration_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $expiration_date;
    /**
     * The first_usage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $first_usage;
    /**
     * The first_usage_time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $first_usage_time;
    /**
     * The last_usage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_usage;
    /**
     * The last_recharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $last_recharge;
    /**
     * The life_time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $life_time;
    /**
     * The redirect_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $redirect_number;
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_product;
    /**
     * The i_routing_plan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_routing_plan;
    /**
     * The i_acl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_acl;
    /**
     * The i_vd_plan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_vd_plan;
    /**
     * The i_moh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_moh;
    /**
     * The ua_profile_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ua_profile_id;
    /**
     * The i_time_zone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_time_zone;
    /**
     * The time_zone_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $time_zone_name;
    /**
     * The i_lang
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $i_lang;
    /**
     * The iso_639_1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_639_1;
    /**
     * The service_flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service_flags;
    /**
     * The service_features
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:ServiceFeatureInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureInfo[]
     */
    public $service_features;
    /**
     * The companyname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $companyname;
    /**
     * The salutation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salutation;
    /**
     * The firstname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The midinit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $midinit;
    /**
     * The lastname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastname;
    /**
     * The baddr1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr1;
    /**
     * The baddr2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr2;
    /**
     * The baddr3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr3;
    /**
     * The baddr4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr4;
    /**
     * The baddr5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $baddr5;
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The zip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * The faxnum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faxnum;
    /**
     * The cont1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cont1;
    /**
     * The phone1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone1;
    /**
     * The cont2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cont2;
    /**
     * The phone2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone2;
    /**
     * The subscriber_email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriber_email;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The h323_password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $h323_password;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The credit_limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $credit_limit;
    /**
     * The blocked
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $blocked;
    /**
     * The um_enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $um_enabled;
    /**
     * The follow_me_enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $follow_me_enabled;
    /**
     * The ecommerce_enabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ecommerce_enabled;
    /**
     * The out_date_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $out_date_format;
    /**
     * The out_time_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $out_time_format;
    /**
     * The out_date_time_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $out_date_time_format;
    /**
     * The in_date_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $in_date_format;
    /**
     * The in_time_format
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $in_time_format;
    /**
     * The i_parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_parent;
    /**
     * The refunds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $refunds;
    /**
     * The mac
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mac;
    /**
     * The bill_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bill_status;
    /**
     * The i_master_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_master_account;
    /**
     * The timer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timer;
    /**
     * The timer_allowed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timer_allowed;
    /**
     * The timer_start_allowed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timer_start_allowed;
    /**
     * The timer_stop_allowed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timer_stop_allowed;
    /**
     * The timer_stopped
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timer_stopped;
    /**
     * The i_subscriber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_subscriber;
    /**
     * The password_timestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password_timestamp;
    /**
     * The i_credit_card
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_credit_card;
    /**
     * The customer_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_name;
    /**
     * The zero_balance_date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zero_balance_date;
    /**
     * The bcc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bcc;
    /**
     * The voucher_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VoucherInfo
     */
    public $voucher_info;
    /**
     * The um_domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $um_domain;
    /**
     * The um_ip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $um_ip;
    /**
     * The um_url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $um_url;
    /**
     * The um_h323_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $um_h323_id;
    /**
     * The um_url_valid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $um_url_valid;
    /**
     * The login_to_um_is_available
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $login_to_um_is_available;
    /**
     * The sip_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sip_status;
    /**
     * The sip_contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sip_contact;
    /**
     * The sip_agent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sip_agent;
    /**
     * The extension_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $extension_id;
    /**
     * The extension_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $extension_name;
    /**
     * The idle_days
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idle_days;
    /**
     * The product_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product_name;
    /**
     * The credit_exceed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $credit_exceed;
    /**
     * The zero_balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $zero_balance;
    /**
     * The customer_bill_suspended
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $customer_bill_suspended;
    /**
     * The cust_bill_suspension_delayed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cust_bill_suspension_delayed;
    /**
     * The customer_blocked
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_blocked;
    /**
     * The customer_status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_status;
    /**
     * The customer_credit_exceed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customer_credit_exceed;
    /**
     * The account_inactive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $account_inactive;
    /**
     * The account_expired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $account_expired;
    /**
     * The is_active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $is_active;
    /**
     * The has_custom_fields
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $has_custom_fields;
    /**
     * The i_customer_site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer_site;
    /**
     * The site_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $site_name;
    /**
     * Constructor method for AccountInfo
     * @uses AccountInfo::setAssigned_addons()
     * @uses AccountInfo::setI_account()
     * @uses AccountInfo::setId()
     * @uses AccountInfo::setBilling_model()
     * @uses AccountInfo::setI_customer()
     * @uses AccountInfo::setI_distributor()
     * @uses AccountInfo::setI_batch()
     * @uses AccountInfo::setBatch_name()
     * @uses AccountInfo::setControl_number()
     * @uses AccountInfo::setIso_4217()
     * @uses AccountInfo::setOpening_balance()
     * @uses AccountInfo::setBalance()
     * @uses AccountInfo::setIssue_date()
     * @uses AccountInfo::setActivation_date()
     * @uses AccountInfo::setExpiration_date()
     * @uses AccountInfo::setFirst_usage()
     * @uses AccountInfo::setFirst_usage_time()
     * @uses AccountInfo::setLast_usage()
     * @uses AccountInfo::setLast_recharge()
     * @uses AccountInfo::setLife_time()
     * @uses AccountInfo::setRedirect_number()
     * @uses AccountInfo::setI_product()
     * @uses AccountInfo::setI_routing_plan()
     * @uses AccountInfo::setI_acl()
     * @uses AccountInfo::setI_vd_plan()
     * @uses AccountInfo::setI_moh()
     * @uses AccountInfo::setUa_profile_id()
     * @uses AccountInfo::setI_time_zone()
     * @uses AccountInfo::setTime_zone_name()
     * @uses AccountInfo::setI_lang()
     * @uses AccountInfo::setIso_639_1()
     * @uses AccountInfo::setService_flags()
     * @uses AccountInfo::setService_features()
     * @uses AccountInfo::setCompanyname()
     * @uses AccountInfo::setSalutation()
     * @uses AccountInfo::setFirstname()
     * @uses AccountInfo::setMidinit()
     * @uses AccountInfo::setLastname()
     * @uses AccountInfo::setBaddr1()
     * @uses AccountInfo::setBaddr2()
     * @uses AccountInfo::setBaddr3()
     * @uses AccountInfo::setBaddr4()
     * @uses AccountInfo::setBaddr5()
     * @uses AccountInfo::setCity()
     * @uses AccountInfo::setState()
     * @uses AccountInfo::setZip()
     * @uses AccountInfo::setCountry()
     * @uses AccountInfo::setNote()
     * @uses AccountInfo::setFaxnum()
     * @uses AccountInfo::setCont1()
     * @uses AccountInfo::setPhone1()
     * @uses AccountInfo::setCont2()
     * @uses AccountInfo::setPhone2()
     * @uses AccountInfo::setSubscriber_email()
     * @uses AccountInfo::setLogin()
     * @uses AccountInfo::setPassword()
     * @uses AccountInfo::setH323_password()
     * @uses AccountInfo::setEmail()
     * @uses AccountInfo::setCredit_limit()
     * @uses AccountInfo::setBlocked()
     * @uses AccountInfo::setUm_enabled()
     * @uses AccountInfo::setFollow_me_enabled()
     * @uses AccountInfo::setEcommerce_enabled()
     * @uses AccountInfo::setOut_date_format()
     * @uses AccountInfo::setOut_time_format()
     * @uses AccountInfo::setOut_date_time_format()
     * @uses AccountInfo::setIn_date_format()
     * @uses AccountInfo::setIn_time_format()
     * @uses AccountInfo::setI_parent()
     * @uses AccountInfo::setRefunds()
     * @uses AccountInfo::setMac()
     * @uses AccountInfo::setBill_status()
     * @uses AccountInfo::setI_master_account()
     * @uses AccountInfo::setTimer()
     * @uses AccountInfo::setTimer_allowed()
     * @uses AccountInfo::setTimer_start_allowed()
     * @uses AccountInfo::setTimer_stop_allowed()
     * @uses AccountInfo::setTimer_stopped()
     * @uses AccountInfo::setI_subscriber()
     * @uses AccountInfo::setPassword_timestamp()
     * @uses AccountInfo::setI_credit_card()
     * @uses AccountInfo::setCustomer_name()
     * @uses AccountInfo::setZero_balance_date()
     * @uses AccountInfo::setBcc()
     * @uses AccountInfo::setVoucher_info()
     * @uses AccountInfo::setUm_domain()
     * @uses AccountInfo::setUm_ip()
     * @uses AccountInfo::setUm_url()
     * @uses AccountInfo::setUm_h323_id()
     * @uses AccountInfo::setUm_url_valid()
     * @uses AccountInfo::setLogin_to_um_is_available()
     * @uses AccountInfo::setSip_status()
     * @uses AccountInfo::setSip_contact()
     * @uses AccountInfo::setSip_agent()
     * @uses AccountInfo::setExtension_id()
     * @uses AccountInfo::setExtension_name()
     * @uses AccountInfo::setIdle_days()
     * @uses AccountInfo::setProduct_name()
     * @uses AccountInfo::setCredit_exceed()
     * @uses AccountInfo::setZero_balance()
     * @uses AccountInfo::setCustomer_bill_suspended()
     * @uses AccountInfo::setCust_bill_suspension_delayed()
     * @uses AccountInfo::setCustomer_blocked()
     * @uses AccountInfo::setCustomer_status()
     * @uses AccountInfo::setCustomer_credit_exceed()
     * @uses AccountInfo::setAccount_inactive()
     * @uses AccountInfo::setAccount_expired()
     * @uses AccountInfo::setIs_active()
     * @uses AccountInfo::setHas_custom_fields()
     * @uses AccountInfo::setI_customer_site()
     * @uses AccountInfo::setSite_name()
     * @param \StructType\ProductInfo[] $assigned_addons
     * @param int $i_account
     * @param string $id
     * @param int $billing_model
     * @param int $i_customer
     * @param int $i_distributor
     * @param int $i_batch
     * @param string $batch_name
     * @param int $control_number
     * @param string $iso_4217
     * @param float $opening_balance
     * @param float $balance
     * @param string $issue_date
     * @param string $activation_date
     * @param string $expiration_date
     * @param string $first_usage
     * @param string $first_usage_time
     * @param string $last_usage
     * @param string $last_recharge
     * @param int $life_time
     * @param string $redirect_number
     * @param int $i_product
     * @param int $i_routing_plan
     * @param int $i_acl
     * @param int $i_vd_plan
     * @param int $i_moh
     * @param int $ua_profile_id
     * @param int $i_time_zone
     * @param string $time_zone_name
     * @param string $i_lang
     * @param string $iso_639_1
     * @param string $service_flags
     * @param \StructType\ServiceFeatureInfo[] $service_features
     * @param string $companyname
     * @param string $salutation
     * @param string $firstname
     * @param string $midinit
     * @param string $lastname
     * @param string $baddr1
     * @param string $baddr2
     * @param string $baddr3
     * @param string $baddr4
     * @param string $baddr5
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param string $note
     * @param string $faxnum
     * @param string $cont1
     * @param string $phone1
     * @param string $cont2
     * @param string $phone2
     * @param string $subscriber_email
     * @param string $login
     * @param string $password
     * @param string $h323_password
     * @param string $email
     * @param float $credit_limit
     * @param string $blocked
     * @param string $um_enabled
     * @param string $follow_me_enabled
     * @param string $ecommerce_enabled
     * @param string $out_date_format
     * @param string $out_time_format
     * @param string $out_date_time_format
     * @param string $in_date_format
     * @param string $in_time_format
     * @param int $i_parent
     * @param float $refunds
     * @param string $mac
     * @param string $bill_status
     * @param int $i_master_account
     * @param string $timer
     * @param int $timer_allowed
     * @param int $timer_start_allowed
     * @param int $timer_stop_allowed
     * @param int $timer_stopped
     * @param int $i_subscriber
     * @param string $password_timestamp
     * @param int $i_credit_card
     * @param string $customer_name
     * @param string $zero_balance_date
     * @param string $bcc
     * @param \StructType\VoucherInfo $voucher_info
     * @param string $um_domain
     * @param string $um_ip
     * @param string $um_url
     * @param string $um_h323_id
     * @param int $um_url_valid
     * @param int $login_to_um_is_available
     * @param int $sip_status
     * @param string $sip_contact
     * @param string $sip_agent
     * @param string $extension_id
     * @param string $extension_name
     * @param int $idle_days
     * @param string $product_name
     * @param string $credit_exceed
     * @param int $zero_balance
     * @param int $customer_bill_suspended
     * @param int $cust_bill_suspension_delayed
     * @param string $customer_blocked
     * @param string $customer_status
     * @param string $customer_credit_exceed
     * @param int $account_inactive
     * @param int $account_expired
     * @param int $is_active
     * @param int $has_custom_fields
     * @param int $i_customer_site
     * @param int $site_name
     */
    public function __construct(array $assigned_addons = array(), $i_account = null, $id = null, $billing_model = null, $i_customer = null, $i_distributor = null, $i_batch = null, $batch_name = null, $control_number = null, $iso_4217 = null, $opening_balance = null, $balance = null, $issue_date = null, $activation_date = null, $expiration_date = null, $first_usage = null, $first_usage_time = null, $last_usage = null, $last_recharge = null, $life_time = null, $redirect_number = null, $i_product = null, $i_routing_plan = null, $i_acl = null, $i_vd_plan = null, $i_moh = null, $ua_profile_id = null, $i_time_zone = null, $time_zone_name = null, $i_lang = null, $iso_639_1 = null, $service_flags = null, array $service_features = array(), $companyname = null, $salutation = null, $firstname = null, $midinit = null, $lastname = null, $baddr1 = null, $baddr2 = null, $baddr3 = null, $baddr4 = null, $baddr5 = null, $city = null, $state = null, $zip = null, $country = null, $note = null, $faxnum = null, $cont1 = null, $phone1 = null, $cont2 = null, $phone2 = null, $subscriber_email = null, $login = null, $password = null, $h323_password = null, $email = null, $credit_limit = null, $blocked = null, $um_enabled = null, $follow_me_enabled = null, $ecommerce_enabled = null, $out_date_format = null, $out_time_format = null, $out_date_time_format = null, $in_date_format = null, $in_time_format = null, $i_parent = null, $refunds = null, $mac = null, $bill_status = null, $i_master_account = null, $timer = null, $timer_allowed = null, $timer_start_allowed = null, $timer_stop_allowed = null, $timer_stopped = null, $i_subscriber = null, $password_timestamp = null, $i_credit_card = null, $customer_name = null, $zero_balance_date = null, $bcc = null, \StructType\VoucherInfo $voucher_info = null, $um_domain = null, $um_ip = null, $um_url = null, $um_h323_id = null, $um_url_valid = null, $login_to_um_is_available = null, $sip_status = null, $sip_contact = null, $sip_agent = null, $extension_id = null, $extension_name = null, $idle_days = null, $product_name = null, $credit_exceed = null, $zero_balance = null, $customer_bill_suspended = null, $cust_bill_suspension_delayed = null, $customer_blocked = null, $customer_status = null, $customer_credit_exceed = null, $account_inactive = null, $account_expired = null, $is_active = null, $has_custom_fields = null, $i_customer_site = null, $site_name = null)
    {
        $this
            ->setAssigned_addons($assigned_addons)
            ->setI_account($i_account)
            ->setId($id)
            ->setBilling_model($billing_model)
            ->setI_customer($i_customer)
            ->setI_distributor($i_distributor)
            ->setI_batch($i_batch)
            ->setBatch_name($batch_name)
            ->setControl_number($control_number)
            ->setIso_4217($iso_4217)
            ->setOpening_balance($opening_balance)
            ->setBalance($balance)
            ->setIssue_date($issue_date)
            ->setActivation_date($activation_date)
            ->setExpiration_date($expiration_date)
            ->setFirst_usage($first_usage)
            ->setFirst_usage_time($first_usage_time)
            ->setLast_usage($last_usage)
            ->setLast_recharge($last_recharge)
            ->setLife_time($life_time)
            ->setRedirect_number($redirect_number)
            ->setI_product($i_product)
            ->setI_routing_plan($i_routing_plan)
            ->setI_acl($i_acl)
            ->setI_vd_plan($i_vd_plan)
            ->setI_moh($i_moh)
            ->setUa_profile_id($ua_profile_id)
            ->setI_time_zone($i_time_zone)
            ->setTime_zone_name($time_zone_name)
            ->setI_lang($i_lang)
            ->setIso_639_1($iso_639_1)
            ->setService_flags($service_flags)
            ->setService_features($service_features)
            ->setCompanyname($companyname)
            ->setSalutation($salutation)
            ->setFirstname($firstname)
            ->setMidinit($midinit)
            ->setLastname($lastname)
            ->setBaddr1($baddr1)
            ->setBaddr2($baddr2)
            ->setBaddr3($baddr3)
            ->setBaddr4($baddr4)
            ->setBaddr5($baddr5)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setNote($note)
            ->setFaxnum($faxnum)
            ->setCont1($cont1)
            ->setPhone1($phone1)
            ->setCont2($cont2)
            ->setPhone2($phone2)
            ->setSubscriber_email($subscriber_email)
            ->setLogin($login)
            ->setPassword($password)
            ->setH323_password($h323_password)
            ->setEmail($email)
            ->setCredit_limit($credit_limit)
            ->setBlocked($blocked)
            ->setUm_enabled($um_enabled)
            ->setFollow_me_enabled($follow_me_enabled)
            ->setEcommerce_enabled($ecommerce_enabled)
            ->setOut_date_format($out_date_format)
            ->setOut_time_format($out_time_format)
            ->setOut_date_time_format($out_date_time_format)
            ->setIn_date_format($in_date_format)
            ->setIn_time_format($in_time_format)
            ->setI_parent($i_parent)
            ->setRefunds($refunds)
            ->setMac($mac)
            ->setBill_status($bill_status)
            ->setI_master_account($i_master_account)
            ->setTimer($timer)
            ->setTimer_allowed($timer_allowed)
            ->setTimer_start_allowed($timer_start_allowed)
            ->setTimer_stop_allowed($timer_stop_allowed)
            ->setTimer_stopped($timer_stopped)
            ->setI_subscriber($i_subscriber)
            ->setPassword_timestamp($password_timestamp)
            ->setI_credit_card($i_credit_card)
            ->setCustomer_name($customer_name)
            ->setZero_balance_date($zero_balance_date)
            ->setBcc($bcc)
            ->setVoucher_info($voucher_info)
            ->setUm_domain($um_domain)
            ->setUm_ip($um_ip)
            ->setUm_url($um_url)
            ->setUm_h323_id($um_h323_id)
            ->setUm_url_valid($um_url_valid)
            ->setLogin_to_um_is_available($login_to_um_is_available)
            ->setSip_status($sip_status)
            ->setSip_contact($sip_contact)
            ->setSip_agent($sip_agent)
            ->setExtension_id($extension_id)
            ->setExtension_name($extension_name)
            ->setIdle_days($idle_days)
            ->setProduct_name($product_name)
            ->setCredit_exceed($credit_exceed)
            ->setZero_balance($zero_balance)
            ->setCustomer_bill_suspended($customer_bill_suspended)
            ->setCust_bill_suspension_delayed($cust_bill_suspension_delayed)
            ->setCustomer_blocked($customer_blocked)
            ->setCustomer_status($customer_status)
            ->setCustomer_credit_exceed($customer_credit_exceed)
            ->setAccount_inactive($account_inactive)
            ->setAccount_expired($account_expired)
            ->setIs_active($is_active)
            ->setHas_custom_fields($has_custom_fields)
            ->setI_customer_site($i_customer_site)
            ->setSite_name($site_name);
    }
    /**
     * Get assigned_addons value
     * @return \StructType\ProductInfo[]
     */
    public function getAssigned_addons()
    {
        return $this->assigned_addons;
    }
    /**
     * Set assigned_addons value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo[] $assigned_addons
     * @return \StructType\AccountInfo
     */
    public function setAssigned_addons(array $assigned_addons = array())
    {
        foreach ($assigned_addons as $accountInfoAssigned_addonsItem) {
            // validation for constraint: itemType
            if (!$accountInfoAssigned_addonsItem instanceof \StructType\ProductInfo) {
                throw new \InvalidArgumentException(sprintf('The assigned_addons property can only contain items of \StructType\ProductInfo, "%s" given', is_object($accountInfoAssigned_addonsItem) ? get_class($accountInfoAssigned_addonsItem) : gettype($accountInfoAssigned_addonsItem)), __LINE__);
            }
        }
        $this->assigned_addons = $assigned_addons;
        return $this;
    }
    /**
     * Add item to assigned_addons value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo $item
     * @return \StructType\AccountInfo
     */
    public function addToAssigned_addons(\StructType\ProductInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInfo) {
            throw new \InvalidArgumentException(sprintf('The assigned_addons property can only contain items of \StructType\ProductInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->assigned_addons[] = $item;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\AccountInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AccountInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get billing_model value
     * @return int|null
     */
    public function getBilling_model()
    {
        return $this->billing_model;
    }
    /**
     * Set billing_model value
     * @param int $billing_model
     * @return \StructType\AccountInfo
     */
    public function setBilling_model($billing_model = null)
    {
        // validation for constraint: int
        if (!is_null($billing_model) && !is_numeric($billing_model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billing_model)), __LINE__);
        }
        $this->billing_model = $billing_model;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\AccountInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_distributor value
     * @return int|null
     */
    public function getI_distributor()
    {
        return $this->i_distributor;
    }
    /**
     * Set i_distributor value
     * @param int $i_distributor
     * @return \StructType\AccountInfo
     */
    public function setI_distributor($i_distributor = null)
    {
        // validation for constraint: int
        if (!is_null($i_distributor) && !is_numeric($i_distributor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_distributor)), __LINE__);
        }
        $this->i_distributor = $i_distributor;
        return $this;
    }
    /**
     * Get i_batch value
     * @return int|null
     */
    public function getI_batch()
    {
        return $this->i_batch;
    }
    /**
     * Set i_batch value
     * @param int $i_batch
     * @return \StructType\AccountInfo
     */
    public function setI_batch($i_batch = null)
    {
        // validation for constraint: int
        if (!is_null($i_batch) && !is_numeric($i_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_batch)), __LINE__);
        }
        $this->i_batch = $i_batch;
        return $this;
    }
    /**
     * Get batch_name value
     * @return string|null
     */
    public function getBatch_name()
    {
        return $this->batch_name;
    }
    /**
     * Set batch_name value
     * @param string $batch_name
     * @return \StructType\AccountInfo
     */
    public function setBatch_name($batch_name = null)
    {
        // validation for constraint: string
        if (!is_null($batch_name) && !is_string($batch_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($batch_name)), __LINE__);
        }
        $this->batch_name = $batch_name;
        return $this;
    }
    /**
     * Get control_number value
     * @return int|null
     */
    public function getControl_number()
    {
        return $this->control_number;
    }
    /**
     * Set control_number value
     * @param int $control_number
     * @return \StructType\AccountInfo
     */
    public function setControl_number($control_number = null)
    {
        // validation for constraint: int
        if (!is_null($control_number) && !is_numeric($control_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($control_number)), __LINE__);
        }
        $this->control_number = $control_number;
        return $this;
    }
    /**
     * Get iso_4217 value
     * @return string|null
     */
    public function getIso_4217()
    {
        return $this->iso_4217;
    }
    /**
     * Set iso_4217 value
     * @param string $iso_4217
     * @return \StructType\AccountInfo
     */
    public function setIso_4217($iso_4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_4217) && !is_string($iso_4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_4217)), __LINE__);
        }
        $this->iso_4217 = $iso_4217;
        return $this;
    }
    /**
     * Get opening_balance value
     * @return float|null
     */
    public function getOpening_balance()
    {
        return $this->opening_balance;
    }
    /**
     * Set opening_balance value
     * @param float $opening_balance
     * @return \StructType\AccountInfo
     */
    public function setOpening_balance($opening_balance = null)
    {
        $this->opening_balance = $opening_balance;
        return $this;
    }
    /**
     * Get balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\AccountInfo
     */
    public function setBalance($balance = null)
    {
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get issue_date value
     * @return string|null
     */
    public function getIssue_date()
    {
        return $this->issue_date;
    }
    /**
     * Set issue_date value
     * @param string $issue_date
     * @return \StructType\AccountInfo
     */
    public function setIssue_date($issue_date = null)
    {
        // validation for constraint: string
        if (!is_null($issue_date) && !is_string($issue_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issue_date)), __LINE__);
        }
        $this->issue_date = $issue_date;
        return $this;
    }
    /**
     * Get activation_date value
     * @return string|null
     */
    public function getActivation_date()
    {
        return $this->activation_date;
    }
    /**
     * Set activation_date value
     * @param string $activation_date
     * @return \StructType\AccountInfo
     */
    public function setActivation_date($activation_date = null)
    {
        // validation for constraint: string
        if (!is_null($activation_date) && !is_string($activation_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activation_date)), __LINE__);
        }
        $this->activation_date = $activation_date;
        return $this;
    }
    /**
     * Get expiration_date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiration_date()
    {
        return isset($this->expiration_date) ? $this->expiration_date : null;
    }
    /**
     * Set expiration_date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiration_date
     * @return \StructType\AccountInfo
     */
    public function setExpiration_date($expiration_date = null)
    {
        // validation for constraint: string
        if (!is_null($expiration_date) && !is_string($expiration_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiration_date)), __LINE__);
        }
        if (is_null($expiration_date) || (is_array($expiration_date) && empty($expiration_date))) {
            unset($this->expiration_date);
        } else {
            $this->expiration_date = $expiration_date;
        }
        return $this;
    }
    /**
     * Get first_usage value
     * @return string|null
     */
    public function getFirst_usage()
    {
        return $this->first_usage;
    }
    /**
     * Set first_usage value
     * @param string $first_usage
     * @return \StructType\AccountInfo
     */
    public function setFirst_usage($first_usage = null)
    {
        // validation for constraint: string
        if (!is_null($first_usage) && !is_string($first_usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($first_usage)), __LINE__);
        }
        $this->first_usage = $first_usage;
        return $this;
    }
    /**
     * Get first_usage_time value
     * @return string|null
     */
    public function getFirst_usage_time()
    {
        return $this->first_usage_time;
    }
    /**
     * Set first_usage_time value
     * @param string $first_usage_time
     * @return \StructType\AccountInfo
     */
    public function setFirst_usage_time($first_usage_time = null)
    {
        // validation for constraint: string
        if (!is_null($first_usage_time) && !is_string($first_usage_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($first_usage_time)), __LINE__);
        }
        $this->first_usage_time = $first_usage_time;
        return $this;
    }
    /**
     * Get last_usage value
     * @return string|null
     */
    public function getLast_usage()
    {
        return $this->last_usage;
    }
    /**
     * Set last_usage value
     * @param string $last_usage
     * @return \StructType\AccountInfo
     */
    public function setLast_usage($last_usage = null)
    {
        // validation for constraint: string
        if (!is_null($last_usage) && !is_string($last_usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_usage)), __LINE__);
        }
        $this->last_usage = $last_usage;
        return $this;
    }
    /**
     * Get last_recharge value
     * @return string|null
     */
    public function getLast_recharge()
    {
        return $this->last_recharge;
    }
    /**
     * Set last_recharge value
     * @param string $last_recharge
     * @return \StructType\AccountInfo
     */
    public function setLast_recharge($last_recharge = null)
    {
        // validation for constraint: string
        if (!is_null($last_recharge) && !is_string($last_recharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_recharge)), __LINE__);
        }
        $this->last_recharge = $last_recharge;
        return $this;
    }
    /**
     * Get life_time value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLife_time()
    {
        return isset($this->life_time) ? $this->life_time : null;
    }
    /**
     * Set life_time value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $life_time
     * @return \StructType\AccountInfo
     */
    public function setLife_time($life_time = null)
    {
        // validation for constraint: int
        if (!is_null($life_time) && !is_numeric($life_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($life_time)), __LINE__);
        }
        if (is_null($life_time) || (is_array($life_time) && empty($life_time))) {
            unset($this->life_time);
        } else {
            $this->life_time = $life_time;
        }
        return $this;
    }
    /**
     * Get redirect_number value
     * @return string|null
     */
    public function getRedirect_number()
    {
        return $this->redirect_number;
    }
    /**
     * Set redirect_number value
     * @param string $redirect_number
     * @return \StructType\AccountInfo
     */
    public function setRedirect_number($redirect_number = null)
    {
        // validation for constraint: string
        if (!is_null($redirect_number) && !is_string($redirect_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirect_number)), __LINE__);
        }
        $this->redirect_number = $redirect_number;
        return $this;
    }
    /**
     * Get i_product value
     * @return int|null
     */
    public function getI_product()
    {
        return $this->i_product;
    }
    /**
     * Set i_product value
     * @param int $i_product
     * @return \StructType\AccountInfo
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        $this->i_product = $i_product;
        return $this;
    }
    /**
     * Get i_routing_plan value
     * @return int|null
     */
    public function getI_routing_plan()
    {
        return $this->i_routing_plan;
    }
    /**
     * Set i_routing_plan value
     * @param int $i_routing_plan
     * @return \StructType\AccountInfo
     */
    public function setI_routing_plan($i_routing_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_routing_plan) && !is_numeric($i_routing_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_routing_plan)), __LINE__);
        }
        $this->i_routing_plan = $i_routing_plan;
        return $this;
    }
    /**
     * Get i_acl value
     * @return int|null
     */
    public function getI_acl()
    {
        return $this->i_acl;
    }
    /**
     * Set i_acl value
     * @param int $i_acl
     * @return \StructType\AccountInfo
     */
    public function setI_acl($i_acl = null)
    {
        // validation for constraint: int
        if (!is_null($i_acl) && !is_numeric($i_acl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_acl)), __LINE__);
        }
        $this->i_acl = $i_acl;
        return $this;
    }
    /**
     * Get i_vd_plan value
     * @return int|null
     */
    public function getI_vd_plan()
    {
        return $this->i_vd_plan;
    }
    /**
     * Set i_vd_plan value
     * @param int $i_vd_plan
     * @return \StructType\AccountInfo
     */
    public function setI_vd_plan($i_vd_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_vd_plan) && !is_numeric($i_vd_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vd_plan)), __LINE__);
        }
        $this->i_vd_plan = $i_vd_plan;
        return $this;
    }
    /**
     * Get i_moh value
     * @return int|null
     */
    public function getI_moh()
    {
        return $this->i_moh;
    }
    /**
     * Set i_moh value
     * @param int $i_moh
     * @return \StructType\AccountInfo
     */
    public function setI_moh($i_moh = null)
    {
        // validation for constraint: int
        if (!is_null($i_moh) && !is_numeric($i_moh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_moh)), __LINE__);
        }
        $this->i_moh = $i_moh;
        return $this;
    }
    /**
     * Get ua_profile_id value
     * @return int|null
     */
    public function getUa_profile_id()
    {
        return $this->ua_profile_id;
    }
    /**
     * Set ua_profile_id value
     * @param int $ua_profile_id
     * @return \StructType\AccountInfo
     */
    public function setUa_profile_id($ua_profile_id = null)
    {
        // validation for constraint: int
        if (!is_null($ua_profile_id) && !is_numeric($ua_profile_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ua_profile_id)), __LINE__);
        }
        $this->ua_profile_id = $ua_profile_id;
        return $this;
    }
    /**
     * Get i_time_zone value
     * @return int|null
     */
    public function getI_time_zone()
    {
        return $this->i_time_zone;
    }
    /**
     * Set i_time_zone value
     * @param int $i_time_zone
     * @return \StructType\AccountInfo
     */
    public function setI_time_zone($i_time_zone = null)
    {
        // validation for constraint: int
        if (!is_null($i_time_zone) && !is_numeric($i_time_zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_time_zone)), __LINE__);
        }
        $this->i_time_zone = $i_time_zone;
        return $this;
    }
    /**
     * Get time_zone_name value
     * @return string|null
     */
    public function getTime_zone_name()
    {
        return $this->time_zone_name;
    }
    /**
     * Set time_zone_name value
     * @param string $time_zone_name
     * @return \StructType\AccountInfo
     */
    public function setTime_zone_name($time_zone_name = null)
    {
        // validation for constraint: string
        if (!is_null($time_zone_name) && !is_string($time_zone_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time_zone_name)), __LINE__);
        }
        $this->time_zone_name = $time_zone_name;
        return $this;
    }
    /**
     * Get i_lang value
     * @return string|null
     */
    public function getI_lang()
    {
        return $this->i_lang;
    }
    /**
     * Set i_lang value
     * @param string $i_lang
     * @return \StructType\AccountInfo
     */
    public function setI_lang($i_lang = null)
    {
        // validation for constraint: string
        if (!is_null($i_lang) && !is_string($i_lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($i_lang)), __LINE__);
        }
        $this->i_lang = $i_lang;
        return $this;
    }
    /**
     * Get iso_639_1 value
     * @return string|null
     */
    public function getIso_639_1()
    {
        return $this->iso_639_1;
    }
    /**
     * Set iso_639_1 value
     * @param string $iso_639_1
     * @return \StructType\AccountInfo
     */
    public function setIso_639_1($iso_639_1 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_639_1) && !is_string($iso_639_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_639_1)), __LINE__);
        }
        $this->iso_639_1 = $iso_639_1;
        return $this;
    }
    /**
     * Get service_flags value
     * @return string|null
     */
    public function getService_flags()
    {
        return $this->service_flags;
    }
    /**
     * Set service_flags value
     * @param string $service_flags
     * @return \StructType\AccountInfo
     */
    public function setService_flags($service_flags = null)
    {
        // validation for constraint: string
        if (!is_null($service_flags) && !is_string($service_flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service_flags)), __LINE__);
        }
        $this->service_flags = $service_flags;
        return $this;
    }
    /**
     * Get service_features value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceFeatureInfo[]|null
     */
    public function getService_features()
    {
        return isset($this->service_features) ? $this->service_features : null;
    }
    /**
     * Set service_features value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo[] $service_features
     * @return \StructType\AccountInfo
     */
    public function setService_features(array $service_features = array())
    {
        foreach ($service_features as $accountInfoService_featuresItem) {
            // validation for constraint: itemType
            if (!$accountInfoService_featuresItem instanceof \StructType\ServiceFeatureInfo) {
                throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($accountInfoService_featuresItem) ? get_class($accountInfoService_featuresItem) : gettype($accountInfoService_featuresItem)), __LINE__);
            }
        }
        if (is_null($service_features) || (is_array($service_features) && empty($service_features))) {
            unset($this->service_features);
        } else {
            $this->service_features = $service_features;
        }
        return $this;
    }
    /**
     * Add item to service_features value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo $item
     * @return \StructType\AccountInfo
     */
    public function addToService_features(\StructType\ServiceFeatureInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureInfo) {
            throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service_features[] = $item;
        return $this;
    }
    /**
     * Get companyname value
     * @return string|null
     */
    public function getCompanyname()
    {
        return $this->companyname;
    }
    /**
     * Set companyname value
     * @param string $companyname
     * @return \StructType\AccountInfo
     */
    public function setCompanyname($companyname = null)
    {
        // validation for constraint: string
        if (!is_null($companyname) && !is_string($companyname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyname)), __LINE__);
        }
        $this->companyname = $companyname;
        return $this;
    }
    /**
     * Get salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\AccountInfo
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\AccountInfo
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get midinit value
     * @return string|null
     */
    public function getMidinit()
    {
        return $this->midinit;
    }
    /**
     * Set midinit value
     * @param string $midinit
     * @return \StructType\AccountInfo
     */
    public function setMidinit($midinit = null)
    {
        // validation for constraint: string
        if (!is_null($midinit) && !is_string($midinit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($midinit)), __LINE__);
        }
        $this->midinit = $midinit;
        return $this;
    }
    /**
     * Get lastname value
     * @return string|null
     */
    public function getLastname()
    {
        return $this->lastname;
    }
    /**
     * Set lastname value
     * @param string $lastname
     * @return \StructType\AccountInfo
     */
    public function setLastname($lastname = null)
    {
        // validation for constraint: string
        if (!is_null($lastname) && !is_string($lastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastname)), __LINE__);
        }
        $this->lastname = $lastname;
        return $this;
    }
    /**
     * Get baddr1 value
     * @return string|null
     */
    public function getBaddr1()
    {
        return $this->baddr1;
    }
    /**
     * Set baddr1 value
     * @param string $baddr1
     * @return \StructType\AccountInfo
     */
    public function setBaddr1($baddr1 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr1) && !is_string($baddr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr1)), __LINE__);
        }
        $this->baddr1 = $baddr1;
        return $this;
    }
    /**
     * Get baddr2 value
     * @return string|null
     */
    public function getBaddr2()
    {
        return $this->baddr2;
    }
    /**
     * Set baddr2 value
     * @param string $baddr2
     * @return \StructType\AccountInfo
     */
    public function setBaddr2($baddr2 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr2) && !is_string($baddr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr2)), __LINE__);
        }
        $this->baddr2 = $baddr2;
        return $this;
    }
    /**
     * Get baddr3 value
     * @return string|null
     */
    public function getBaddr3()
    {
        return $this->baddr3;
    }
    /**
     * Set baddr3 value
     * @param string $baddr3
     * @return \StructType\AccountInfo
     */
    public function setBaddr3($baddr3 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr3) && !is_string($baddr3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr3)), __LINE__);
        }
        $this->baddr3 = $baddr3;
        return $this;
    }
    /**
     * Get baddr4 value
     * @return string|null
     */
    public function getBaddr4()
    {
        return $this->baddr4;
    }
    /**
     * Set baddr4 value
     * @param string $baddr4
     * @return \StructType\AccountInfo
     */
    public function setBaddr4($baddr4 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr4) && !is_string($baddr4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr4)), __LINE__);
        }
        $this->baddr4 = $baddr4;
        return $this;
    }
    /**
     * Get baddr5 value
     * @return string|null
     */
    public function getBaddr5()
    {
        return $this->baddr5;
    }
    /**
     * Set baddr5 value
     * @param string $baddr5
     * @return \StructType\AccountInfo
     */
    public function setBaddr5($baddr5 = null)
    {
        // validation for constraint: string
        if (!is_null($baddr5) && !is_string($baddr5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baddr5)), __LINE__);
        }
        $this->baddr5 = $baddr5;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\AccountInfo
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\AccountInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\AccountInfo
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\AccountInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\AccountInfo
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get faxnum value
     * @return string|null
     */
    public function getFaxnum()
    {
        return $this->faxnum;
    }
    /**
     * Set faxnum value
     * @param string $faxnum
     * @return \StructType\AccountInfo
     */
    public function setFaxnum($faxnum = null)
    {
        // validation for constraint: string
        if (!is_null($faxnum) && !is_string($faxnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxnum)), __LINE__);
        }
        $this->faxnum = $faxnum;
        return $this;
    }
    /**
     * Get cont1 value
     * @return string|null
     */
    public function getCont1()
    {
        return $this->cont1;
    }
    /**
     * Set cont1 value
     * @param string $cont1
     * @return \StructType\AccountInfo
     */
    public function setCont1($cont1 = null)
    {
        // validation for constraint: string
        if (!is_null($cont1) && !is_string($cont1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cont1)), __LINE__);
        }
        $this->cont1 = $cont1;
        return $this;
    }
    /**
     * Get phone1 value
     * @return string|null
     */
    public function getPhone1()
    {
        return $this->phone1;
    }
    /**
     * Set phone1 value
     * @param string $phone1
     * @return \StructType\AccountInfo
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone1)), __LINE__);
        }
        $this->phone1 = $phone1;
        return $this;
    }
    /**
     * Get cont2 value
     * @return string|null
     */
    public function getCont2()
    {
        return $this->cont2;
    }
    /**
     * Set cont2 value
     * @param string $cont2
     * @return \StructType\AccountInfo
     */
    public function setCont2($cont2 = null)
    {
        // validation for constraint: string
        if (!is_null($cont2) && !is_string($cont2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cont2)), __LINE__);
        }
        $this->cont2 = $cont2;
        return $this;
    }
    /**
     * Get phone2 value
     * @return string|null
     */
    public function getPhone2()
    {
        return $this->phone2;
    }
    /**
     * Set phone2 value
     * @param string $phone2
     * @return \StructType\AccountInfo
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone2)), __LINE__);
        }
        $this->phone2 = $phone2;
        return $this;
    }
    /**
     * Get subscriber_email value
     * @return string|null
     */
    public function getSubscriber_email()
    {
        return $this->subscriber_email;
    }
    /**
     * Set subscriber_email value
     * @param string $subscriber_email
     * @return \StructType\AccountInfo
     */
    public function setSubscriber_email($subscriber_email = null)
    {
        // validation for constraint: string
        if (!is_null($subscriber_email) && !is_string($subscriber_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriber_email)), __LINE__);
        }
        $this->subscriber_email = $subscriber_email;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\AccountInfo
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\AccountInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get h323_password value
     * @return string|null
     */
    public function getH323_password()
    {
        return $this->h323_password;
    }
    /**
     * Set h323_password value
     * @param string $h323_password
     * @return \StructType\AccountInfo
     */
    public function setH323_password($h323_password = null)
    {
        // validation for constraint: string
        if (!is_null($h323_password) && !is_string($h323_password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323_password)), __LINE__);
        }
        $this->h323_password = $h323_password;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\AccountInfo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get credit_limit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCredit_limit()
    {
        return isset($this->credit_limit) ? $this->credit_limit : null;
    }
    /**
     * Set credit_limit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $credit_limit
     * @return \StructType\AccountInfo
     */
    public function setCredit_limit($credit_limit = null)
    {
        if (is_null($credit_limit) || (is_array($credit_limit) && empty($credit_limit))) {
            unset($this->credit_limit);
        } else {
            $this->credit_limit = $credit_limit;
        }
        return $this;
    }
    /**
     * Get blocked value
     * @return string|null
     */
    public function getBlocked()
    {
        return $this->blocked;
    }
    /**
     * Set blocked value
     * @param string $blocked
     * @return \StructType\AccountInfo
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: string
        if (!is_null($blocked) && !is_string($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blocked)), __LINE__);
        }
        $this->blocked = $blocked;
        return $this;
    }
    /**
     * Get um_enabled value
     * @return string|null
     */
    public function getUm_enabled()
    {
        return $this->um_enabled;
    }
    /**
     * Set um_enabled value
     * @param string $um_enabled
     * @return \StructType\AccountInfo
     */
    public function setUm_enabled($um_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($um_enabled) && !is_string($um_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($um_enabled)), __LINE__);
        }
        $this->um_enabled = $um_enabled;
        return $this;
    }
    /**
     * Get follow_me_enabled value
     * @return string|null
     */
    public function getFollow_me_enabled()
    {
        return $this->follow_me_enabled;
    }
    /**
     * Set follow_me_enabled value
     * @param string $follow_me_enabled
     * @return \StructType\AccountInfo
     */
    public function setFollow_me_enabled($follow_me_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($follow_me_enabled) && !is_string($follow_me_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($follow_me_enabled)), __LINE__);
        }
        $this->follow_me_enabled = $follow_me_enabled;
        return $this;
    }
    /**
     * Get ecommerce_enabled value
     * @return string|null
     */
    public function getEcommerce_enabled()
    {
        return $this->ecommerce_enabled;
    }
    /**
     * Set ecommerce_enabled value
     * @param string $ecommerce_enabled
     * @return \StructType\AccountInfo
     */
    public function setEcommerce_enabled($ecommerce_enabled = null)
    {
        // validation for constraint: string
        if (!is_null($ecommerce_enabled) && !is_string($ecommerce_enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ecommerce_enabled)), __LINE__);
        }
        $this->ecommerce_enabled = $ecommerce_enabled;
        return $this;
    }
    /**
     * Get out_date_format value
     * @return string|null
     */
    public function getOut_date_format()
    {
        return $this->out_date_format;
    }
    /**
     * Set out_date_format value
     * @param string $out_date_format
     * @return \StructType\AccountInfo
     */
    public function setOut_date_format($out_date_format = null)
    {
        // validation for constraint: string
        if (!is_null($out_date_format) && !is_string($out_date_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_date_format)), __LINE__);
        }
        $this->out_date_format = $out_date_format;
        return $this;
    }
    /**
     * Get out_time_format value
     * @return string|null
     */
    public function getOut_time_format()
    {
        return $this->out_time_format;
    }
    /**
     * Set out_time_format value
     * @param string $out_time_format
     * @return \StructType\AccountInfo
     */
    public function setOut_time_format($out_time_format = null)
    {
        // validation for constraint: string
        if (!is_null($out_time_format) && !is_string($out_time_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_time_format)), __LINE__);
        }
        $this->out_time_format = $out_time_format;
        return $this;
    }
    /**
     * Get out_date_time_format value
     * @return string|null
     */
    public function getOut_date_time_format()
    {
        return $this->out_date_time_format;
    }
    /**
     * Set out_date_time_format value
     * @param string $out_date_time_format
     * @return \StructType\AccountInfo
     */
    public function setOut_date_time_format($out_date_time_format = null)
    {
        // validation for constraint: string
        if (!is_null($out_date_time_format) && !is_string($out_date_time_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($out_date_time_format)), __LINE__);
        }
        $this->out_date_time_format = $out_date_time_format;
        return $this;
    }
    /**
     * Get in_date_format value
     * @return string|null
     */
    public function getIn_date_format()
    {
        return $this->in_date_format;
    }
    /**
     * Set in_date_format value
     * @param string $in_date_format
     * @return \StructType\AccountInfo
     */
    public function setIn_date_format($in_date_format = null)
    {
        // validation for constraint: string
        if (!is_null($in_date_format) && !is_string($in_date_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($in_date_format)), __LINE__);
        }
        $this->in_date_format = $in_date_format;
        return $this;
    }
    /**
     * Get in_time_format value
     * @return string|null
     */
    public function getIn_time_format()
    {
        return $this->in_time_format;
    }
    /**
     * Set in_time_format value
     * @param string $in_time_format
     * @return \StructType\AccountInfo
     */
    public function setIn_time_format($in_time_format = null)
    {
        // validation for constraint: string
        if (!is_null($in_time_format) && !is_string($in_time_format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($in_time_format)), __LINE__);
        }
        $this->in_time_format = $in_time_format;
        return $this;
    }
    /**
     * Get i_parent value
     * @return int|null
     */
    public function getI_parent()
    {
        return $this->i_parent;
    }
    /**
     * Set i_parent value
     * @param int $i_parent
     * @return \StructType\AccountInfo
     */
    public function setI_parent($i_parent = null)
    {
        // validation for constraint: int
        if (!is_null($i_parent) && !is_numeric($i_parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_parent)), __LINE__);
        }
        $this->i_parent = $i_parent;
        return $this;
    }
    /**
     * Get refunds value
     * @return float|null
     */
    public function getRefunds()
    {
        return $this->refunds;
    }
    /**
     * Set refunds value
     * @param float $refunds
     * @return \StructType\AccountInfo
     */
    public function setRefunds($refunds = null)
    {
        $this->refunds = $refunds;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \StructType\AccountInfo
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mac)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get bill_status value
     * @return string|null
     */
    public function getBill_status()
    {
        return $this->bill_status;
    }
    /**
     * Set bill_status value
     * @param string $bill_status
     * @return \StructType\AccountInfo
     */
    public function setBill_status($bill_status = null)
    {
        // validation for constraint: string
        if (!is_null($bill_status) && !is_string($bill_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bill_status)), __LINE__);
        }
        $this->bill_status = $bill_status;
        return $this;
    }
    /**
     * Get i_master_account value
     * @return int|null
     */
    public function getI_master_account()
    {
        return $this->i_master_account;
    }
    /**
     * Set i_master_account value
     * @param int $i_master_account
     * @return \StructType\AccountInfo
     */
    public function setI_master_account($i_master_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_master_account) && !is_numeric($i_master_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_master_account)), __LINE__);
        }
        $this->i_master_account = $i_master_account;
        return $this;
    }
    /**
     * Get timer value
     * @return string|null
     */
    public function getTimer()
    {
        return $this->timer;
    }
    /**
     * Set timer value
     * @param string $timer
     * @return \StructType\AccountInfo
     */
    public function setTimer($timer = null)
    {
        // validation for constraint: string
        if (!is_null($timer) && !is_string($timer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timer)), __LINE__);
        }
        $this->timer = $timer;
        return $this;
    }
    /**
     * Get timer_allowed value
     * @return int|null
     */
    public function getTimer_allowed()
    {
        return $this->timer_allowed;
    }
    /**
     * Set timer_allowed value
     * @param int $timer_allowed
     * @return \StructType\AccountInfo
     */
    public function setTimer_allowed($timer_allowed = null)
    {
        // validation for constraint: int
        if (!is_null($timer_allowed) && !is_numeric($timer_allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timer_allowed)), __LINE__);
        }
        $this->timer_allowed = $timer_allowed;
        return $this;
    }
    /**
     * Get timer_start_allowed value
     * @return int|null
     */
    public function getTimer_start_allowed()
    {
        return $this->timer_start_allowed;
    }
    /**
     * Set timer_start_allowed value
     * @param int $timer_start_allowed
     * @return \StructType\AccountInfo
     */
    public function setTimer_start_allowed($timer_start_allowed = null)
    {
        // validation for constraint: int
        if (!is_null($timer_start_allowed) && !is_numeric($timer_start_allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timer_start_allowed)), __LINE__);
        }
        $this->timer_start_allowed = $timer_start_allowed;
        return $this;
    }
    /**
     * Get timer_stop_allowed value
     * @return int|null
     */
    public function getTimer_stop_allowed()
    {
        return $this->timer_stop_allowed;
    }
    /**
     * Set timer_stop_allowed value
     * @param int $timer_stop_allowed
     * @return \StructType\AccountInfo
     */
    public function setTimer_stop_allowed($timer_stop_allowed = null)
    {
        // validation for constraint: int
        if (!is_null($timer_stop_allowed) && !is_numeric($timer_stop_allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timer_stop_allowed)), __LINE__);
        }
        $this->timer_stop_allowed = $timer_stop_allowed;
        return $this;
    }
    /**
     * Get timer_stopped value
     * @return int|null
     */
    public function getTimer_stopped()
    {
        return $this->timer_stopped;
    }
    /**
     * Set timer_stopped value
     * @param int $timer_stopped
     * @return \StructType\AccountInfo
     */
    public function setTimer_stopped($timer_stopped = null)
    {
        // validation for constraint: int
        if (!is_null($timer_stopped) && !is_numeric($timer_stopped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timer_stopped)), __LINE__);
        }
        $this->timer_stopped = $timer_stopped;
        return $this;
    }
    /**
     * Get i_subscriber value
     * @return int|null
     */
    public function getI_subscriber()
    {
        return $this->i_subscriber;
    }
    /**
     * Set i_subscriber value
     * @param int $i_subscriber
     * @return \StructType\AccountInfo
     */
    public function setI_subscriber($i_subscriber = null)
    {
        // validation for constraint: int
        if (!is_null($i_subscriber) && !is_numeric($i_subscriber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_subscriber)), __LINE__);
        }
        $this->i_subscriber = $i_subscriber;
        return $this;
    }
    /**
     * Get password_timestamp value
     * @return string|null
     */
    public function getPassword_timestamp()
    {
        return $this->password_timestamp;
    }
    /**
     * Set password_timestamp value
     * @param string $password_timestamp
     * @return \StructType\AccountInfo
     */
    public function setPassword_timestamp($password_timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($password_timestamp) && !is_string($password_timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password_timestamp)), __LINE__);
        }
        $this->password_timestamp = $password_timestamp;
        return $this;
    }
    /**
     * Get i_credit_card value
     * @return int|null
     */
    public function getI_credit_card()
    {
        return $this->i_credit_card;
    }
    /**
     * Set i_credit_card value
     * @param int $i_credit_card
     * @return \StructType\AccountInfo
     */
    public function setI_credit_card($i_credit_card = null)
    {
        // validation for constraint: int
        if (!is_null($i_credit_card) && !is_numeric($i_credit_card)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_credit_card)), __LINE__);
        }
        $this->i_credit_card = $i_credit_card;
        return $this;
    }
    /**
     * Get customer_name value
     * @return string|null
     */
    public function getCustomer_name()
    {
        return $this->customer_name;
    }
    /**
     * Set customer_name value
     * @param string $customer_name
     * @return \StructType\AccountInfo
     */
    public function setCustomer_name($customer_name = null)
    {
        // validation for constraint: string
        if (!is_null($customer_name) && !is_string($customer_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_name)), __LINE__);
        }
        $this->customer_name = $customer_name;
        return $this;
    }
    /**
     * Get zero_balance_date value
     * @return string|null
     */
    public function getZero_balance_date()
    {
        return $this->zero_balance_date;
    }
    /**
     * Set zero_balance_date value
     * @param string $zero_balance_date
     * @return \StructType\AccountInfo
     */
    public function setZero_balance_date($zero_balance_date = null)
    {
        // validation for constraint: string
        if (!is_null($zero_balance_date) && !is_string($zero_balance_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zero_balance_date)), __LINE__);
        }
        $this->zero_balance_date = $zero_balance_date;
        return $this;
    }
    /**
     * Get bcc value
     * @return string|null
     */
    public function getBcc()
    {
        return $this->bcc;
    }
    /**
     * Set bcc value
     * @param string $bcc
     * @return \StructType\AccountInfo
     */
    public function setBcc($bcc = null)
    {
        // validation for constraint: string
        if (!is_null($bcc) && !is_string($bcc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bcc)), __LINE__);
        }
        $this->bcc = $bcc;
        return $this;
    }
    /**
     * Get voucher_info value
     * @return \StructType\VoucherInfo|null
     */
    public function getVoucher_info()
    {
        return $this->voucher_info;
    }
    /**
     * Set voucher_info value
     * @param \StructType\VoucherInfo $voucher_info
     * @return \StructType\AccountInfo
     */
    public function setVoucher_info(\StructType\VoucherInfo $voucher_info = null)
    {
        $this->voucher_info = $voucher_info;
        return $this;
    }
    /**
     * Get um_domain value
     * @return string|null
     */
    public function getUm_domain()
    {
        return $this->um_domain;
    }
    /**
     * Set um_domain value
     * @param string $um_domain
     * @return \StructType\AccountInfo
     */
    public function setUm_domain($um_domain = null)
    {
        // validation for constraint: string
        if (!is_null($um_domain) && !is_string($um_domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($um_domain)), __LINE__);
        }
        $this->um_domain = $um_domain;
        return $this;
    }
    /**
     * Get um_ip value
     * @return string|null
     */
    public function getUm_ip()
    {
        return $this->um_ip;
    }
    /**
     * Set um_ip value
     * @param string $um_ip
     * @return \StructType\AccountInfo
     */
    public function setUm_ip($um_ip = null)
    {
        // validation for constraint: string
        if (!is_null($um_ip) && !is_string($um_ip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($um_ip)), __LINE__);
        }
        $this->um_ip = $um_ip;
        return $this;
    }
    /**
     * Get um_url value
     * @return string|null
     */
    public function getUm_url()
    {
        return $this->um_url;
    }
    /**
     * Set um_url value
     * @param string $um_url
     * @return \StructType\AccountInfo
     */
    public function setUm_url($um_url = null)
    {
        // validation for constraint: string
        if (!is_null($um_url) && !is_string($um_url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($um_url)), __LINE__);
        }
        $this->um_url = $um_url;
        return $this;
    }
    /**
     * Get um_h323_id value
     * @return string|null
     */
    public function getUm_h323_id()
    {
        return $this->um_h323_id;
    }
    /**
     * Set um_h323_id value
     * @param string $um_h323_id
     * @return \StructType\AccountInfo
     */
    public function setUm_h323_id($um_h323_id = null)
    {
        // validation for constraint: string
        if (!is_null($um_h323_id) && !is_string($um_h323_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($um_h323_id)), __LINE__);
        }
        $this->um_h323_id = $um_h323_id;
        return $this;
    }
    /**
     * Get um_url_valid value
     * @return int|null
     */
    public function getUm_url_valid()
    {
        return $this->um_url_valid;
    }
    /**
     * Set um_url_valid value
     * @param int $um_url_valid
     * @return \StructType\AccountInfo
     */
    public function setUm_url_valid($um_url_valid = null)
    {
        // validation for constraint: int
        if (!is_null($um_url_valid) && !is_numeric($um_url_valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($um_url_valid)), __LINE__);
        }
        $this->um_url_valid = $um_url_valid;
        return $this;
    }
    /**
     * Get login_to_um_is_available value
     * @return int|null
     */
    public function getLogin_to_um_is_available()
    {
        return $this->login_to_um_is_available;
    }
    /**
     * Set login_to_um_is_available value
     * @param int $login_to_um_is_available
     * @return \StructType\AccountInfo
     */
    public function setLogin_to_um_is_available($login_to_um_is_available = null)
    {
        // validation for constraint: int
        if (!is_null($login_to_um_is_available) && !is_numeric($login_to_um_is_available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($login_to_um_is_available)), __LINE__);
        }
        $this->login_to_um_is_available = $login_to_um_is_available;
        return $this;
    }
    /**
     * Get sip_status value
     * @return int|null
     */
    public function getSip_status()
    {
        return $this->sip_status;
    }
    /**
     * Set sip_status value
     * @param int $sip_status
     * @return \StructType\AccountInfo
     */
    public function setSip_status($sip_status = null)
    {
        // validation for constraint: int
        if (!is_null($sip_status) && !is_numeric($sip_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sip_status)), __LINE__);
        }
        $this->sip_status = $sip_status;
        return $this;
    }
    /**
     * Get sip_contact value
     * @return string|null
     */
    public function getSip_contact()
    {
        return $this->sip_contact;
    }
    /**
     * Set sip_contact value
     * @param string $sip_contact
     * @return \StructType\AccountInfo
     */
    public function setSip_contact($sip_contact = null)
    {
        // validation for constraint: string
        if (!is_null($sip_contact) && !is_string($sip_contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sip_contact)), __LINE__);
        }
        $this->sip_contact = $sip_contact;
        return $this;
    }
    /**
     * Get sip_agent value
     * @return string|null
     */
    public function getSip_agent()
    {
        return $this->sip_agent;
    }
    /**
     * Set sip_agent value
     * @param string $sip_agent
     * @return \StructType\AccountInfo
     */
    public function setSip_agent($sip_agent = null)
    {
        // validation for constraint: string
        if (!is_null($sip_agent) && !is_string($sip_agent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sip_agent)), __LINE__);
        }
        $this->sip_agent = $sip_agent;
        return $this;
    }
    /**
     * Get extension_id value
     * @return string|null
     */
    public function getExtension_id()
    {
        return $this->extension_id;
    }
    /**
     * Set extension_id value
     * @param string $extension_id
     * @return \StructType\AccountInfo
     */
    public function setExtension_id($extension_id = null)
    {
        // validation for constraint: string
        if (!is_null($extension_id) && !is_string($extension_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension_id)), __LINE__);
        }
        $this->extension_id = $extension_id;
        return $this;
    }
    /**
     * Get extension_name value
     * @return string|null
     */
    public function getExtension_name()
    {
        return $this->extension_name;
    }
    /**
     * Set extension_name value
     * @param string $extension_name
     * @return \StructType\AccountInfo
     */
    public function setExtension_name($extension_name = null)
    {
        // validation for constraint: string
        if (!is_null($extension_name) && !is_string($extension_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension_name)), __LINE__);
        }
        $this->extension_name = $extension_name;
        return $this;
    }
    /**
     * Get idle_days value
     * @return int|null
     */
    public function getIdle_days()
    {
        return $this->idle_days;
    }
    /**
     * Set idle_days value
     * @param int $idle_days
     * @return \StructType\AccountInfo
     */
    public function setIdle_days($idle_days = null)
    {
        // validation for constraint: int
        if (!is_null($idle_days) && !is_numeric($idle_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($idle_days)), __LINE__);
        }
        $this->idle_days = $idle_days;
        return $this;
    }
    /**
     * Get product_name value
     * @return string|null
     */
    public function getProduct_name()
    {
        return $this->product_name;
    }
    /**
     * Set product_name value
     * @param string $product_name
     * @return \StructType\AccountInfo
     */
    public function setProduct_name($product_name = null)
    {
        // validation for constraint: string
        if (!is_null($product_name) && !is_string($product_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product_name)), __LINE__);
        }
        $this->product_name = $product_name;
        return $this;
    }
    /**
     * Get credit_exceed value
     * @return string|null
     */
    public function getCredit_exceed()
    {
        return $this->credit_exceed;
    }
    /**
     * Set credit_exceed value
     * @param string $credit_exceed
     * @return \StructType\AccountInfo
     */
    public function setCredit_exceed($credit_exceed = null)
    {
        // validation for constraint: string
        if (!is_null($credit_exceed) && !is_string($credit_exceed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credit_exceed)), __LINE__);
        }
        $this->credit_exceed = $credit_exceed;
        return $this;
    }
    /**
     * Get zero_balance value
     * @return int|null
     */
    public function getZero_balance()
    {
        return $this->zero_balance;
    }
    /**
     * Set zero_balance value
     * @param int $zero_balance
     * @return \StructType\AccountInfo
     */
    public function setZero_balance($zero_balance = null)
    {
        // validation for constraint: int
        if (!is_null($zero_balance) && !is_numeric($zero_balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zero_balance)), __LINE__);
        }
        $this->zero_balance = $zero_balance;
        return $this;
    }
    /**
     * Get customer_bill_suspended value
     * @return int|null
     */
    public function getCustomer_bill_suspended()
    {
        return $this->customer_bill_suspended;
    }
    /**
     * Set customer_bill_suspended value
     * @param int $customer_bill_suspended
     * @return \StructType\AccountInfo
     */
    public function setCustomer_bill_suspended($customer_bill_suspended = null)
    {
        // validation for constraint: int
        if (!is_null($customer_bill_suspended) && !is_numeric($customer_bill_suspended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customer_bill_suspended)), __LINE__);
        }
        $this->customer_bill_suspended = $customer_bill_suspended;
        return $this;
    }
    /**
     * Get cust_bill_suspension_delayed value
     * @return int|null
     */
    public function getCust_bill_suspension_delayed()
    {
        return $this->cust_bill_suspension_delayed;
    }
    /**
     * Set cust_bill_suspension_delayed value
     * @param int $cust_bill_suspension_delayed
     * @return \StructType\AccountInfo
     */
    public function setCust_bill_suspension_delayed($cust_bill_suspension_delayed = null)
    {
        // validation for constraint: int
        if (!is_null($cust_bill_suspension_delayed) && !is_numeric($cust_bill_suspension_delayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cust_bill_suspension_delayed)), __LINE__);
        }
        $this->cust_bill_suspension_delayed = $cust_bill_suspension_delayed;
        return $this;
    }
    /**
     * Get customer_blocked value
     * @return string|null
     */
    public function getCustomer_blocked()
    {
        return $this->customer_blocked;
    }
    /**
     * Set customer_blocked value
     * @param string $customer_blocked
     * @return \StructType\AccountInfo
     */
    public function setCustomer_blocked($customer_blocked = null)
    {
        // validation for constraint: string
        if (!is_null($customer_blocked) && !is_string($customer_blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_blocked)), __LINE__);
        }
        $this->customer_blocked = $customer_blocked;
        return $this;
    }
    /**
     * Get customer_status value
     * @return string|null
     */
    public function getCustomer_status()
    {
        return $this->customer_status;
    }
    /**
     * Set customer_status value
     * @param string $customer_status
     * @return \StructType\AccountInfo
     */
    public function setCustomer_status($customer_status = null)
    {
        // validation for constraint: string
        if (!is_null($customer_status) && !is_string($customer_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_status)), __LINE__);
        }
        $this->customer_status = $customer_status;
        return $this;
    }
    /**
     * Get customer_credit_exceed value
     * @return string|null
     */
    public function getCustomer_credit_exceed()
    {
        return $this->customer_credit_exceed;
    }
    /**
     * Set customer_credit_exceed value
     * @param string $customer_credit_exceed
     * @return \StructType\AccountInfo
     */
    public function setCustomer_credit_exceed($customer_credit_exceed = null)
    {
        // validation for constraint: string
        if (!is_null($customer_credit_exceed) && !is_string($customer_credit_exceed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer_credit_exceed)), __LINE__);
        }
        $this->customer_credit_exceed = $customer_credit_exceed;
        return $this;
    }
    /**
     * Get account_inactive value
     * @return int|null
     */
    public function getAccount_inactive()
    {
        return $this->account_inactive;
    }
    /**
     * Set account_inactive value
     * @param int $account_inactive
     * @return \StructType\AccountInfo
     */
    public function setAccount_inactive($account_inactive = null)
    {
        // validation for constraint: int
        if (!is_null($account_inactive) && !is_numeric($account_inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($account_inactive)), __LINE__);
        }
        $this->account_inactive = $account_inactive;
        return $this;
    }
    /**
     * Get account_expired value
     * @return int|null
     */
    public function getAccount_expired()
    {
        return $this->account_expired;
    }
    /**
     * Set account_expired value
     * @param int $account_expired
     * @return \StructType\AccountInfo
     */
    public function setAccount_expired($account_expired = null)
    {
        // validation for constraint: int
        if (!is_null($account_expired) && !is_numeric($account_expired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($account_expired)), __LINE__);
        }
        $this->account_expired = $account_expired;
        return $this;
    }
    /**
     * Get is_active value
     * @return int|null
     */
    public function getIs_active()
    {
        return $this->is_active;
    }
    /**
     * Set is_active value
     * @param int $is_active
     * @return \StructType\AccountInfo
     */
    public function setIs_active($is_active = null)
    {
        // validation for constraint: int
        if (!is_null($is_active) && !is_numeric($is_active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_active)), __LINE__);
        }
        $this->is_active = $is_active;
        return $this;
    }
    /**
     * Get has_custom_fields value
     * @return int|null
     */
    public function getHas_custom_fields()
    {
        return $this->has_custom_fields;
    }
    /**
     * Set has_custom_fields value
     * @param int $has_custom_fields
     * @return \StructType\AccountInfo
     */
    public function setHas_custom_fields($has_custom_fields = null)
    {
        // validation for constraint: int
        if (!is_null($has_custom_fields) && !is_numeric($has_custom_fields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($has_custom_fields)), __LINE__);
        }
        $this->has_custom_fields = $has_custom_fields;
        return $this;
    }
    /**
     * Get i_customer_site value
     * @return int|null
     */
    public function getI_customer_site()
    {
        return $this->i_customer_site;
    }
    /**
     * Set i_customer_site value
     * @param int $i_customer_site
     * @return \StructType\AccountInfo
     */
    public function setI_customer_site($i_customer_site = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer_site) && !is_numeric($i_customer_site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer_site)), __LINE__);
        }
        $this->i_customer_site = $i_customer_site;
        return $this;
    }
    /**
     * Get site_name value
     * @return int|null
     */
    public function getSite_name()
    {
        return $this->site_name;
    }
    /**
     * Set site_name value
     * @param int $site_name
     * @return \StructType\AccountInfo
     */
    public function setSite_name($site_name = null)
    {
        // validation for constraint: int
        if (!is_null($site_name) && !is_numeric($site_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($site_name)), __LINE__);
        }
        $this->site_name = $site_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
