<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCTariffTemplateBindingInfo StructType
 * @subpackage Structs
 */
class WCTariffTemplateBindingInfo extends AbstractStructBase
{
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the tariff record in case of success
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_tariff;
    /**
     * The email_from
     * Meta informations extracted from the WSDL
     * - documentation: Sender's e-mail; email_from and email_key combination must be unique; email_from and i_tariff_template combination must be unique
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email_from;
    /**
     * The email_key
     * Meta informations extracted from the WSDL
     * - documentation: Security key; tariff will be accepted only if the correct key is specified in the message's subject line or body; email_from and email_key combination must be unique
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email_key;
    /**
     * The i_tariff_template
     * Meta informations extracted from the WSDL
     * - documentation: ID of the Upload Template record; email_from and i_tariff_template combination must be unique
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_tariff_template;
    /**
     * Constructor method for WCTariffTemplateBindingInfo
     * @uses WCTariffTemplateBindingInfo::setI_tariff()
     * @uses WCTariffTemplateBindingInfo::setEmail_from()
     * @uses WCTariffTemplateBindingInfo::setEmail_key()
     * @uses WCTariffTemplateBindingInfo::setI_tariff_template()
     * @param int $i_tariff
     * @param string $email_from
     * @param string $email_key
     * @param int $i_tariff_template
     */
    public function __construct($i_tariff = null, $email_from = null, $email_key = null, $i_tariff_template = null)
    {
        $this
            ->setI_tariff($i_tariff)
            ->setEmail_from($email_from)
            ->setEmail_key($email_key)
            ->setI_tariff_template($i_tariff_template);
    }
    /**
     * Get i_tariff value
     * @return int
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\WCTariffTemplateBindingInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get email_from value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail_from()
    {
        return isset($this->email_from) ? $this->email_from : null;
    }
    /**
     * Set email_from value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email_from
     * @return \StructType\WCTariffTemplateBindingInfo
     */
    public function setEmail_from($email_from = null)
    {
        // validation for constraint: string
        if (!is_null($email_from) && !is_string($email_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email_from)), __LINE__);
        }
        if (is_null($email_from) || (is_array($email_from) && empty($email_from))) {
            unset($this->email_from);
        } else {
            $this->email_from = $email_from;
        }
        return $this;
    }
    /**
     * Get email_key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail_key()
    {
        return isset($this->email_key) ? $this->email_key : null;
    }
    /**
     * Set email_key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email_key
     * @return \StructType\WCTariffTemplateBindingInfo
     */
    public function setEmail_key($email_key = null)
    {
        // validation for constraint: string
        if (!is_null($email_key) && !is_string($email_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email_key)), __LINE__);
        }
        if (is_null($email_key) || (is_array($email_key) && empty($email_key))) {
            unset($this->email_key);
        } else {
            $this->email_key = $email_key;
        }
        return $this;
    }
    /**
     * Get i_tariff_template value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_tariff_template()
    {
        return isset($this->i_tariff_template) ? $this->i_tariff_template : null;
    }
    /**
     * Set i_tariff_template value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_tariff_template
     * @return \StructType\WCTariffTemplateBindingInfo
     */
    public function setI_tariff_template($i_tariff_template = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff_template) && !is_numeric($i_tariff_template)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff_template)), __LINE__);
        }
        if (is_null($i_tariff_template) || (is_array($i_tariff_template) && empty($i_tariff_template))) {
            unset($this->i_tariff_template);
        } else {
            $this->i_tariff_template = $i_tariff_template;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCTariffTemplateBindingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
