<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCServiceRatingInfo StructType
 * @subpackage Structs
 */
class WCServiceRatingInfo extends AbstractStructBase
{
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - documentation: ID of the Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_service;
    /**
     * The i_accessibility
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the product
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_accessibility;
    /**
     * The i_node
     * Meta informations extracted from the WSDL
     * - documentation: ID of the node, ANY if nil
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_node;
    /**
     * The CLD
     * Meta informations extracted from the WSDL
     * - documentation: Access Code, 64 chars max
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CLD;
    /**
     * The i_oli
     * Meta informations extracted from the WSDL
     * - documentation: ID of the Info Digits choice ((Voice Calls only), ANY if nil
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_oli;
    /**
     * The i_rate_match_mode
     * Meta informations extracted from the WSDL
     * - documentation: Rate Match Mode (Voice Calls only): nil - Default, 1 - Calling Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_rate_match_mode;
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - documentation: ID of the customer's tariff
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_tariff;
    /**
     * The i_tariff_reseller
     * Meta informations extracted from the WSDL
     * - documentation: ID of the reseller's tariff
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_tariff_reseller;
    /**
     * The check_funds
     * Meta informations extracted from the WSDL
     * - documentation: Check Minimum Funds: N - Do not check, B - Above breakage, Y - More than 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $check_funds;
    /**
     * The min_session_funds
     * Meta informations extracted from the WSDL
     * - documentation: Min. Session Deposit, product's currency
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $min_session_funds;
    /**
     * The max_session_funds
     * Meta informations extracted from the WSDL
     * - documentation: Max. Session Deposit, product's currency
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $max_session_funds;
    /**
     * The max_auth_funds
     * Meta informations extracted from the WSDL
     * - documentation: Max. Authorization Chunk, product's currency
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $max_auth_funds;
    /**
     * The alert_overuse_reject
     * Meta informations extracted from the WSDL
     * - documentation: Overuse Notification: N - off, Y - on
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $alert_overuse_reject;
    /**
     * Constructor method for WCServiceRatingInfo
     * @uses WCServiceRatingInfo::setI_service()
     * @uses WCServiceRatingInfo::setI_accessibility()
     * @uses WCServiceRatingInfo::setI_node()
     * @uses WCServiceRatingInfo::setCLD()
     * @uses WCServiceRatingInfo::setI_oli()
     * @uses WCServiceRatingInfo::setI_rate_match_mode()
     * @uses WCServiceRatingInfo::setI_tariff()
     * @uses WCServiceRatingInfo::setI_tariff_reseller()
     * @uses WCServiceRatingInfo::setCheck_funds()
     * @uses WCServiceRatingInfo::setMin_session_funds()
     * @uses WCServiceRatingInfo::setMax_session_funds()
     * @uses WCServiceRatingInfo::setMax_auth_funds()
     * @uses WCServiceRatingInfo::setAlert_overuse_reject()
     * @param int $i_service
     * @param int $i_accessibility
     * @param int $i_node
     * @param string $cLD
     * @param int $i_oli
     * @param int $i_rate_match_mode
     * @param int $i_tariff
     * @param int $i_tariff_reseller
     * @param string $check_funds
     * @param float $min_session_funds
     * @param float $max_session_funds
     * @param float $max_auth_funds
     * @param string $alert_overuse_reject
     */
    public function __construct($i_service = null, $i_accessibility = null, $i_node = null, $cLD = null, $i_oli = null, $i_rate_match_mode = null, $i_tariff = null, $i_tariff_reseller = null, $check_funds = null, $min_session_funds = null, $max_session_funds = null, $max_auth_funds = null, $alert_overuse_reject = null)
    {
        $this
            ->setI_service($i_service)
            ->setI_accessibility($i_accessibility)
            ->setI_node($i_node)
            ->setCLD($cLD)
            ->setI_oli($i_oli)
            ->setI_rate_match_mode($i_rate_match_mode)
            ->setI_tariff($i_tariff)
            ->setI_tariff_reseller($i_tariff_reseller)
            ->setCheck_funds($check_funds)
            ->setMin_session_funds($min_session_funds)
            ->setMax_session_funds($max_session_funds)
            ->setMax_auth_funds($max_auth_funds)
            ->setAlert_overuse_reject($alert_overuse_reject);
    }
    /**
     * Get i_service value
     * @return int
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\WCServiceRatingInfo
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get i_accessibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_accessibility()
    {
        return isset($this->i_accessibility) ? $this->i_accessibility : null;
    }
    /**
     * Set i_accessibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_accessibility
     * @return \StructType\WCServiceRatingInfo
     */
    public function setI_accessibility($i_accessibility = null)
    {
        // validation for constraint: int
        if (!is_null($i_accessibility) && !is_numeric($i_accessibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_accessibility)), __LINE__);
        }
        if (is_null($i_accessibility) || (is_array($i_accessibility) && empty($i_accessibility))) {
            unset($this->i_accessibility);
        } else {
            $this->i_accessibility = $i_accessibility;
        }
        return $this;
    }
    /**
     * Get i_node value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_node()
    {
        return isset($this->i_node) ? $this->i_node : null;
    }
    /**
     * Set i_node value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_node
     * @return \StructType\WCServiceRatingInfo
     */
    public function setI_node($i_node = null)
    {
        // validation for constraint: int
        if (!is_null($i_node) && !is_numeric($i_node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_node)), __LINE__);
        }
        if (is_null($i_node) || (is_array($i_node) && empty($i_node))) {
            unset($this->i_node);
        } else {
            $this->i_node = $i_node;
        }
        return $this;
    }
    /**
     * Get CLD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCLD()
    {
        return isset($this->CLD) ? $this->CLD : null;
    }
    /**
     * Set CLD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cLD
     * @return \StructType\WCServiceRatingInfo
     */
    public function setCLD($cLD = null)
    {
        // validation for constraint: string
        if (!is_null($cLD) && !is_string($cLD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cLD)), __LINE__);
        }
        if (is_null($cLD) || (is_array($cLD) && empty($cLD))) {
            unset($this->CLD);
        } else {
            $this->CLD = $cLD;
        }
        return $this;
    }
    /**
     * Get i_oli value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_oli()
    {
        return isset($this->i_oli) ? $this->i_oli : null;
    }
    /**
     * Set i_oli value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_oli
     * @return \StructType\WCServiceRatingInfo
     */
    public function setI_oli($i_oli = null)
    {
        // validation for constraint: int
        if (!is_null($i_oli) && !is_numeric($i_oli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_oli)), __LINE__);
        }
        if (is_null($i_oli) || (is_array($i_oli) && empty($i_oli))) {
            unset($this->i_oli);
        } else {
            $this->i_oli = $i_oli;
        }
        return $this;
    }
    /**
     * Get i_rate_match_mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_rate_match_mode()
    {
        return isset($this->i_rate_match_mode) ? $this->i_rate_match_mode : null;
    }
    /**
     * Set i_rate_match_mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_rate_match_mode
     * @return \StructType\WCServiceRatingInfo
     */
    public function setI_rate_match_mode($i_rate_match_mode = null)
    {
        // validation for constraint: int
        if (!is_null($i_rate_match_mode) && !is_numeric($i_rate_match_mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_rate_match_mode)), __LINE__);
        }
        if (is_null($i_rate_match_mode) || (is_array($i_rate_match_mode) && empty($i_rate_match_mode))) {
            unset($this->i_rate_match_mode);
        } else {
            $this->i_rate_match_mode = $i_rate_match_mode;
        }
        return $this;
    }
    /**
     * Get i_tariff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_tariff()
    {
        return isset($this->i_tariff) ? $this->i_tariff : null;
    }
    /**
     * Set i_tariff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_tariff
     * @return \StructType\WCServiceRatingInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        if (is_null($i_tariff) || (is_array($i_tariff) && empty($i_tariff))) {
            unset($this->i_tariff);
        } else {
            $this->i_tariff = $i_tariff;
        }
        return $this;
    }
    /**
     * Get i_tariff_reseller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_tariff_reseller()
    {
        return isset($this->i_tariff_reseller) ? $this->i_tariff_reseller : null;
    }
    /**
     * Set i_tariff_reseller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_tariff_reseller
     * @return \StructType\WCServiceRatingInfo
     */
    public function setI_tariff_reseller($i_tariff_reseller = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff_reseller) && !is_numeric($i_tariff_reseller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff_reseller)), __LINE__);
        }
        if (is_null($i_tariff_reseller) || (is_array($i_tariff_reseller) && empty($i_tariff_reseller))) {
            unset($this->i_tariff_reseller);
        } else {
            $this->i_tariff_reseller = $i_tariff_reseller;
        }
        return $this;
    }
    /**
     * Get check_funds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheck_funds()
    {
        return isset($this->check_funds) ? $this->check_funds : null;
    }
    /**
     * Set check_funds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $check_funds
     * @return \StructType\WCServiceRatingInfo
     */
    public function setCheck_funds($check_funds = null)
    {
        // validation for constraint: string
        if (!is_null($check_funds) && !is_string($check_funds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($check_funds)), __LINE__);
        }
        if (is_null($check_funds) || (is_array($check_funds) && empty($check_funds))) {
            unset($this->check_funds);
        } else {
            $this->check_funds = $check_funds;
        }
        return $this;
    }
    /**
     * Get min_session_funds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMin_session_funds()
    {
        return isset($this->min_session_funds) ? $this->min_session_funds : null;
    }
    /**
     * Set min_session_funds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $min_session_funds
     * @return \StructType\WCServiceRatingInfo
     */
    public function setMin_session_funds($min_session_funds = null)
    {
        if (is_null($min_session_funds) || (is_array($min_session_funds) && empty($min_session_funds))) {
            unset($this->min_session_funds);
        } else {
            $this->min_session_funds = $min_session_funds;
        }
        return $this;
    }
    /**
     * Get max_session_funds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMax_session_funds()
    {
        return isset($this->max_session_funds) ? $this->max_session_funds : null;
    }
    /**
     * Set max_session_funds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $max_session_funds
     * @return \StructType\WCServiceRatingInfo
     */
    public function setMax_session_funds($max_session_funds = null)
    {
        if (is_null($max_session_funds) || (is_array($max_session_funds) && empty($max_session_funds))) {
            unset($this->max_session_funds);
        } else {
            $this->max_session_funds = $max_session_funds;
        }
        return $this;
    }
    /**
     * Get max_auth_funds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMax_auth_funds()
    {
        return isset($this->max_auth_funds) ? $this->max_auth_funds : null;
    }
    /**
     * Set max_auth_funds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $max_auth_funds
     * @return \StructType\WCServiceRatingInfo
     */
    public function setMax_auth_funds($max_auth_funds = null)
    {
        if (is_null($max_auth_funds) || (is_array($max_auth_funds) && empty($max_auth_funds))) {
            unset($this->max_auth_funds);
        } else {
            $this->max_auth_funds = $max_auth_funds;
        }
        return $this;
    }
    /**
     * Get alert_overuse_reject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlert_overuse_reject()
    {
        return isset($this->alert_overuse_reject) ? $this->alert_overuse_reject : null;
    }
    /**
     * Set alert_overuse_reject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alert_overuse_reject
     * @return \StructType\WCServiceRatingInfo
     */
    public function setAlert_overuse_reject($alert_overuse_reject = null)
    {
        // validation for constraint: string
        if (!is_null($alert_overuse_reject) && !is_string($alert_overuse_reject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alert_overuse_reject)), __LINE__);
        }
        if (is_null($alert_overuse_reject) || (is_array($alert_overuse_reject) && empty($alert_overuse_reject))) {
            unset($this->alert_overuse_reject);
        } else {
            $this->alert_overuse_reject = $alert_overuse_reject;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCServiceRatingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
