<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCProductTariffInfo StructType
 * @subpackage Structs
 */
class WCProductTariffInfo extends AbstractStructBase
{
    /**
     * The i_accessibility
     * Meta informations extracted from the WSDL
     * - documentation: Unique ID of the record
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $i_accessibility;
    /**
     * The i_node
     * Meta informations extracted from the WSDL
     * - documentation: Node ID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i_node;
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - documentation: Tariff ID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i_tariff;
    /**
     * The i_tariff_reseller
     * Meta informations extracted from the WSDL
     * - documentation: Reseller tariff ID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i_tariff_reseller;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - documentation: Tariff's service ID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i_service;
    /**
     * The i_service_type
     * Meta informations extracted from the WSDL
     * - documentation: Service type ID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i_service_type;
    /**
     * The access_code
     * Meta informations extracted from the WSDL
     * - documentation: Access Code
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $access_code;
    /**
     * The i_oli
     * Meta informations extracted from the WSDL
     * - documentation: Info Digits ID
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i_oli;
    /**
     * Constructor method for WCProductTariffInfo
     * @uses WCProductTariffInfo::setI_accessibility()
     * @uses WCProductTariffInfo::setI_node()
     * @uses WCProductTariffInfo::setI_tariff()
     * @uses WCProductTariffInfo::setI_tariff_reseller()
     * @uses WCProductTariffInfo::setI_service()
     * @uses WCProductTariffInfo::setI_service_type()
     * @uses WCProductTariffInfo::setAccess_code()
     * @uses WCProductTariffInfo::setI_oli()
     * @param int $i_accessibility
     * @param int $i_node
     * @param int $i_tariff
     * @param int $i_tariff_reseller
     * @param int $i_service
     * @param int $i_service_type
     * @param string $access_code
     * @param int $i_oli
     */
    public function __construct($i_accessibility = null, $i_node = null, $i_tariff = null, $i_tariff_reseller = null, $i_service = null, $i_service_type = null, $access_code = null, $i_oli = null)
    {
        $this
            ->setI_accessibility($i_accessibility)
            ->setI_node($i_node)
            ->setI_tariff($i_tariff)
            ->setI_tariff_reseller($i_tariff_reseller)
            ->setI_service($i_service)
            ->setI_service_type($i_service_type)
            ->setAccess_code($access_code)
            ->setI_oli($i_oli);
    }
    /**
     * Get i_accessibility value
     * @return int
     */
    public function getI_accessibility()
    {
        return $this->i_accessibility;
    }
    /**
     * Set i_accessibility value
     * @param int $i_accessibility
     * @return \StructType\WCProductTariffInfo
     */
    public function setI_accessibility($i_accessibility = null)
    {
        // validation for constraint: int
        if (!is_null($i_accessibility) && !is_numeric($i_accessibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_accessibility)), __LINE__);
        }
        $this->i_accessibility = $i_accessibility;
        return $this;
    }
    /**
     * Get i_node value
     * @return int
     */
    public function getI_node()
    {
        return $this->i_node;
    }
    /**
     * Set i_node value
     * @param int $i_node
     * @return \StructType\WCProductTariffInfo
     */
    public function setI_node($i_node = null)
    {
        // validation for constraint: int
        if (!is_null($i_node) && !is_numeric($i_node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_node)), __LINE__);
        }
        $this->i_node = $i_node;
        return $this;
    }
    /**
     * Get i_tariff value
     * @return int
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\WCProductTariffInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get i_tariff_reseller value
     * @return int
     */
    public function getI_tariff_reseller()
    {
        return $this->i_tariff_reseller;
    }
    /**
     * Set i_tariff_reseller value
     * @param int $i_tariff_reseller
     * @return \StructType\WCProductTariffInfo
     */
    public function setI_tariff_reseller($i_tariff_reseller = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff_reseller) && !is_numeric($i_tariff_reseller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff_reseller)), __LINE__);
        }
        $this->i_tariff_reseller = $i_tariff_reseller;
        return $this;
    }
    /**
     * Get i_service value
     * @return int
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\WCProductTariffInfo
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get i_service_type value
     * @return int
     */
    public function getI_service_type()
    {
        return $this->i_service_type;
    }
    /**
     * Set i_service_type value
     * @param int $i_service_type
     * @return \StructType\WCProductTariffInfo
     */
    public function setI_service_type($i_service_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_service_type) && !is_numeric($i_service_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service_type)), __LINE__);
        }
        $this->i_service_type = $i_service_type;
        return $this;
    }
    /**
     * Get access_code value
     * @return string
     */
    public function getAccess_code()
    {
        return $this->access_code;
    }
    /**
     * Set access_code value
     * @param string $access_code
     * @return \StructType\WCProductTariffInfo
     */
    public function setAccess_code($access_code = null)
    {
        // validation for constraint: string
        if (!is_null($access_code) && !is_string($access_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($access_code)), __LINE__);
        }
        $this->access_code = $access_code;
        return $this;
    }
    /**
     * Get i_oli value
     * @return int
     */
    public function getI_oli()
    {
        return $this->i_oli;
    }
    /**
     * Set i_oli value
     * @param int $i_oli
     * @return \StructType\WCProductTariffInfo
     */
    public function setI_oli($i_oli = null)
    {
        // validation for constraint: int
        if (!is_null($i_oli) && !is_numeric($i_oli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_oli)), __LINE__);
        }
        $this->i_oli = $i_oli;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCProductTariffInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
