<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetProductTariffsResponse StructType
 * @subpackage Structs
 */
class WCGetProductTariffsResponse extends AbstractStructBase
{
    /**
     * The product_tariffs
     * Meta informations extracted from the WSDL
     * - documentation: Array of product tariffs
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:WCProductTariffInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\WCProductTariffInfo[]
     */
    public $product_tariffs;
    /**
     * Constructor method for WCGetProductTariffsResponse
     * @uses WCGetProductTariffsResponse::setProduct_tariffs()
     * @param \StructType\WCProductTariffInfo[] $product_tariffs
     */
    public function __construct(array $product_tariffs = array())
    {
        $this
            ->setProduct_tariffs($product_tariffs);
    }
    /**
     * Get product_tariffs value
     * @return \StructType\WCProductTariffInfo[]
     */
    public function getProduct_tariffs()
    {
        return $this->product_tariffs;
    }
    /**
     * Set product_tariffs value
     * @throws \InvalidArgumentException
     * @param \StructType\WCProductTariffInfo[] $product_tariffs
     * @return \StructType\WCGetProductTariffsResponse
     */
    public function setProduct_tariffs(array $product_tariffs = array())
    {
        foreach ($product_tariffs as $wCGetProductTariffsResponseProduct_tariffsItem) {
            // validation for constraint: itemType
            if (!$wCGetProductTariffsResponseProduct_tariffsItem instanceof \StructType\WCProductTariffInfo) {
                throw new \InvalidArgumentException(sprintf('The product_tariffs property can only contain items of \StructType\WCProductTariffInfo, "%s" given', is_object($wCGetProductTariffsResponseProduct_tariffsItem) ? get_class($wCGetProductTariffsResponseProduct_tariffsItem) : gettype($wCGetProductTariffsResponseProduct_tariffsItem)), __LINE__);
            }
        }
        $this->product_tariffs = $product_tariffs;
        return $this;
    }
    /**
     * Add item to product_tariffs value
     * @throws \InvalidArgumentException
     * @param \StructType\WCProductTariffInfo $item
     * @return \StructType\WCGetProductTariffsResponse
     */
    public function addToProduct_tariffs(\StructType\WCProductTariffInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WCProductTariffInfo) {
            throw new \InvalidArgumentException(sprintf('The product_tariffs property can only contain items of \StructType\WCProductTariffInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->product_tariffs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetProductTariffsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
