<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WCGetCardInventoryResponse StructType
 * @subpackage Structs
 */
class WCGetCardInventoryResponse extends AbstractStructBase
{
    /**
     * The card_inventory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:WCCardInventoryEntryInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\WCCardInventoryEntryInfo[]
     */
    public $card_inventory;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - documentation: Customer that owns card inventory
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $i_customer;
    /**
     * Constructor method for WCGetCardInventoryResponse
     * @uses WCGetCardInventoryResponse::setCard_inventory()
     * @uses WCGetCardInventoryResponse::setI_customer()
     * @param \StructType\WCCardInventoryEntryInfo[] $card_inventory
     * @param int $i_customer
     */
    public function __construct(array $card_inventory = array(), $i_customer = null)
    {
        $this
            ->setCard_inventory($card_inventory)
            ->setI_customer($i_customer);
    }
    /**
     * Get card_inventory value
     * @return \StructType\WCCardInventoryEntryInfo[]
     */
    public function getCard_inventory()
    {
        return $this->card_inventory;
    }
    /**
     * Set card_inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\WCCardInventoryEntryInfo[] $card_inventory
     * @return \StructType\WCGetCardInventoryResponse
     */
    public function setCard_inventory(array $card_inventory = array())
    {
        foreach ($card_inventory as $wCGetCardInventoryResponseCard_inventoryItem) {
            // validation for constraint: itemType
            if (!$wCGetCardInventoryResponseCard_inventoryItem instanceof \StructType\WCCardInventoryEntryInfo) {
                throw new \InvalidArgumentException(sprintf('The card_inventory property can only contain items of \StructType\WCCardInventoryEntryInfo, "%s" given', is_object($wCGetCardInventoryResponseCard_inventoryItem) ? get_class($wCGetCardInventoryResponseCard_inventoryItem) : gettype($wCGetCardInventoryResponseCard_inventoryItem)), __LINE__);
            }
        }
        $this->card_inventory = $card_inventory;
        return $this;
    }
    /**
     * Add item to card_inventory value
     * @throws \InvalidArgumentException
     * @param \StructType\WCCardInventoryEntryInfo $item
     * @return \StructType\WCGetCardInventoryResponse
     */
    public function addToCard_inventory(\StructType\WCCardInventoryEntryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WCCardInventoryEntryInfo) {
            throw new \InvalidArgumentException(sprintf('The card_inventory property can only contain items of \StructType\WCCardInventoryEntryInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->card_inventory[] = $item;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\WCGetCardInventoryResponse
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WCGetCardInventoryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
